/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TriggerEngineHeat
extends BCTrigger {
    public TileEngine.EnergyStage stage;
    @SideOnly(value=Side.CLIENT)
    private Icon iconBlue;
    @SideOnly(value=Side.CLIENT)
    private Icon iconGreen;
    @SideOnly(value=Side.CLIENT)
    private Icon iconYellow;
    @SideOnly(value=Side.CLIENT)
    private Icon iconRed;

    public TriggerEngineHeat(int id, TileEngine.EnergyStage stage, String uniqueTag) {
        super(id, uniqueTag);
        this.stage = stage;
    }

    @Override
    public String getDescription() {
        switch (this.stage) {
            case BLUE: {
                return StringUtils.localize("gate.engine.blue");
            }
            case GREEN: {
                return StringUtils.localize("gate.engine.green");
            }
            case YELLOW: {
                return StringUtils.localize("gate.engine.yellow");
            }
        }
        return StringUtils.localize("gate.engine.red");
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof TileEngine) {
            TileEngine engine = (TileEngine)tile;
            return engine.getEnergyStage() == this.stage;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        switch (this.stage) {
            case BLUE: {
                return this.iconBlue;
            }
            case GREEN: {
                return this.iconGreen;
            }
            case YELLOW: {
                return this.iconYellow;
            }
        }
        return this.iconRed;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        this.iconBlue = iconRegister.func_94245_a("buildcraft:triggers/trigger_engineheat_blue");
        this.iconGreen = iconRegister.func_94245_a("buildcraft:triggers/trigger_engineheat_green");
        this.iconYellow = iconRegister.func_94245_a("buildcraft:triggers/trigger_engineheat_yellow");
        this.iconRed = iconRegister.func_94245_a("buildcraft:triggers/trigger_engineheat_red");
    }
}

