/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.api.recipes.RefineryRecipes;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.utils.StringUtils;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.gui.ContainerRefinery;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiRefinery
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/refinery_filter.png");
    ContainerRefinery container;

    public GuiRefinery(InventoryPlayer inventory, TileRefinery refinery) {
        super(new ContainerRefinery(inventory, refinery), refinery);
        this.field_74194_b = 175;
        this.field_74195_c = 207;
        this.container = (ContainerRefinery)this.field_74193_d;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[3];
        this.slots[0] = new GuiAdvancedInterface.FluidSlot(38, 54);
        this.slots[1] = new GuiAdvancedInterface.FluidSlot(126, 54);
        this.slots[2] = new GuiAdvancedInterface.FluidSlot(82, 54);
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        String title = StringUtils.localize("tile.refineryBlock");
        this.field_73886_k.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_73886_k.func_78276_b("->", 63, 59, 0x404040);
        this.field_73886_k.func_78276_b("<-", 106, 59, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_74195_c - 96 + 2, 0x404040);
        this.drawForegroundSelection(par1, par2);
    }

    protected void func_74185_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(TEXTURE);
        int j = (this.field_73880_f - this.field_74194_b) / 2;
        int k = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(j, k, 0, 0, this.field_74194_b, this.field_74195_c);
        this.updateSlots();
        this.drawBackgroundSlots();
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        if (position >= 0 && position < 2) {
            if (k == 0) {
                if (!GuiRefinery.func_73877_p()) {
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.field_73882_e.field_71439_g.field_71071_by.func_70445_o());
                    if (liquid == null) {
                        return;
                    }
                    this.container.setFilter(position, liquid.getFluid());
                } else {
                    this.container.setFilter(position, null);
                }
            } else {
                TileRefinery ref = (TileRefinery)this.tile;
                if (position == 0) {
                    this.container.setFilter(position, ref.tank1.getFluidType());
                } else if (position == 1) {
                    this.container.setFilter(position, ref.tank2.getFluidType());
                }
            }
        }
    }

    private void updateSlots() {
        RefineryRecipes.Recipe recipe;
        Fluid filter0 = this.container.getFilter(0);
        Fluid filter1 = this.container.getFilter(1);
        ((GuiAdvancedInterface.FluidSlot)this.slots[0]).fluid = filter0;
        ((GuiAdvancedInterface.FluidSlot)this.slots[1]).fluid = filter1;
        FluidStack liquid0 = null;
        FluidStack liquid1 = null;
        if (filter0 != null) {
            liquid0 = new FluidStack(filter0, 1000);
        }
        if (filter1 != null) {
            liquid1 = new FluidStack(filter1, 1000);
        }
        ((GuiAdvancedInterface.FluidSlot)this.slots[2]).fluid = (recipe = RefineryRecipes.findRefineryRecipe(liquid0, liquid1)) != null ? recipe.result.getFluid() : null;
    }
}

