/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.render;

import buildcraft.core.DefaultProps;
import buildcraft.core.IInventoryRenderer;
import buildcraft.core.fluids.Tank;
import buildcraft.core.render.FluidRenderer;
import buildcraft.factory.TileRefinery;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderRefinery
extends TileEntitySpecialRenderer
implements IInventoryRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/refinery.png");
    private static final float pixel = 0.0625f;
    private final ModelRenderer tank;
    private final ModelRenderer[] magnet = new ModelRenderer[4];
    private final ModelBase model = new ModelBase(){};

    public RenderRefinery() {
        this.tank = new ModelRenderer(this.model, 0, 0);
        this.tank.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 16, 8);
        this.tank.field_78800_c = 8.0f;
        this.tank.field_78797_d = 8.0f;
        this.tank.field_78798_e = 8.0f;
        for (int i = 0; i < 4; ++i) {
            this.magnet[i] = new ModelRenderer(this.model, 32, i * 8);
            this.magnet[i].func_78789_a(0.0f, -8.0f, -8.0f, 8, 4, 4);
            this.magnet[i].field_78800_c = 8.0f;
            this.magnet[i].field_78797_d = 8.0f;
            this.magnet[i].field_78798_e = 8.0f;
        }
        this.func_76893_a(TileEntityRenderer.field_76963_a);
    }

    public RenderRefinery(String baseTexture) {
        this();
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(null, x, y, z);
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        this.render((TileRefinery)tileentity, x, y, z);
    }

    private void render(TileRefinery tile, double x, double y, double z) {
        float trans2;
        float trans1;
        FluidStack liquid1 = null;
        FluidStack liquid2 = null;
        FluidStack liquidResult = null;
        float anim = 0.0f;
        int angle = 0;
        ModelRenderer theMagnet = this.magnet[0];
        if (tile != null) {
            if (tile.tank1.getFluid() != null) {
                liquid1 = tile.tank1.getFluid();
            }
            if (tile.tank2.getFluid() != null) {
                liquid2 = tile.tank2.getFluid();
            }
            if (tile.result.getFluid() != null) {
                liquidResult = tile.result.getFluid();
            }
            anim = tile.getAnimationStage();
            angle = 0;
            switch (tile.field_70331_k.func_72805_g(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)) {
                case 2: {
                    angle = 90;
                    break;
                }
                case 3: {
                    angle = 270;
                    break;
                }
                case 4: {
                    angle = 180;
                    break;
                }
                case 5: {
                    angle = 0;
                }
            }
            theMagnet = tile.animationSpeed <= 1.0f ? this.magnet[0] : ((double)tile.animationSpeed <= 2.5 ? this.magnet[1] : ((double)tile.animationSpeed <= 4.5 ? this.magnet[2] : this.magnet[3]));
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_110628_a(TEXTURE);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)-0.25f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.25f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.25f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)-0.25f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (anim <= 100.0f) {
            trans1 = 0.75f * anim / 100.0f;
            trans2 = 0.0f;
        } else if (anim <= 200.0f) {
            trans1 = 0.75f - 0.75f * (anim - 100.0f) / 100.0f;
            trans2 = 0.75f * (anim - 100.0f) / 100.0f;
        } else {
            trans1 = 0.75f * (anim - 200.0f) / 100.0f;
            trans2 = 0.75f - 0.75f * (anim - 200.0f) / 100.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glTranslatef((float)-0.51f, (float)(trans1 - 0.5f), (float)-0.5f);
        theMagnet.func_78785_a(0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glTranslatef((float)-0.51f, (float)(trans2 - 0.5f), (float)0.25f);
        theMagnet.func_78785_a(0.0625f);
        GL11.glPopMatrix();
        if (tile != null) {
            int[] list3;
            int[] list2;
            int[] list1;
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GL11.glScalef((float)0.5f, (float)1.0f, (float)0.5f);
            if (liquid1 != null && liquid1.amount > 0 && (list1 = FluidRenderer.getFluidDisplayLists(liquid1, tile.field_70331_k, false)) != null) {
                this.func_110628_a(FluidRenderer.getFluidSheet(liquid1));
                FluidRenderer.setColorForFluidStack(liquid1);
                GL11.glCallList((int)list1[this.getDisplayListIndex(tile.tank1)]);
            }
            if (liquid2 != null && liquid2.amount > 0 && (list2 = FluidRenderer.getFluidDisplayLists(liquid2, tile.field_70331_k, false)) != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                this.func_110628_a(FluidRenderer.getFluidSheet(liquid2));
                FluidRenderer.setColorForFluidStack(liquid2);
                GL11.glCallList((int)list2[this.getDisplayListIndex(tile.tank2)]);
                GL11.glPopMatrix();
            }
            if (liquidResult != null && liquidResult.amount > 0 && (list3 = FluidRenderer.getFluidDisplayLists(liquidResult, tile.field_70331_k, false)) != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.5f);
                this.func_110628_a(FluidRenderer.getFluidSheet(liquidResult));
                FluidRenderer.setColorForFluidStack(liquidResult);
                GL11.glCallList((int)list3[this.getDisplayListIndex(tile.result)]);
                GL11.glPopMatrix();
            }
            GL11.glPopAttrib();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private int getDisplayListIndex(Tank tank) {
        return Math.min((int)((float)tank.getFluidAmount() / (float)tank.getCapacity() * 99.0f), 99);
    }
}

