/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketNBT;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.StringUtils;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.gui.ContainerAssemblyTable;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiAssemblyTable
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/assembly_table.png");
    TileAssemblyTable assemblyTable;

    public GuiAssemblyTable(IInventory playerInventory, TileAssemblyTable assemblyTable) {
        super(new ContainerAssemblyTable(playerInventory, assemblyTable), assemblyTable);
        this.assemblyTable = assemblyTable;
        this.field_74194_b = 175;
        this.field_74195_c = 207;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[8];
        int p = 0;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 4; ++i) {
                this.slots[p] = new RecipeSlot(134 + 18 * j, 36 + 18 * i);
                ++p;
            }
        }
        this.updateRecipes();
        if (CoreProxy.proxy.isRenderWorld(assemblyTable.field_70331_k)) {
            CoreProxy.proxy.sendToServer(new PacketCoordinates(20, assemblyTable.field_70329_l, assemblyTable.field_70330_m, assemblyTable.field_70327_n).getPacket());
        }
    }

    public void updateRecipes() {
        LinkedList potentialRecipes = this.assemblyTable.getPotentialOutputs();
        Iterator cur = potentialRecipes.iterator();
        for (int p = 0; p < 8; ++p) {
            ((RecipeSlot)this.slots[p]).recipe = cur.hasNext() ? (AssemblyRecipe)cur.next() : null;
        }
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        super.func_74189_g(par1, par2);
        String title = StringUtils.localize("tile.assemblyTableBlock");
        this.field_73886_k.func_78276_b(title, this.getCenteredOffset(title), 15, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_74195_c - 97, 0x404040);
        this.drawForegroundSelection(par1, par2);
    }

    protected void func_74185_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(TEXTURE);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, this.field_74194_b, this.field_74195_c);
        this.updateRecipes();
        for (int s = 0; s < this.slots.length; ++s) {
            RecipeSlot slot = (RecipeSlot)this.slots[s];
            if (this.assemblyTable.isAssembling(slot.recipe)) {
                this.func_73729_b(cornerX + slot.x, cornerY + slot.y, 196, 1, 16, 16);
                continue;
            }
            if (!this.assemblyTable.isPlanned(slot.recipe)) continue;
            this.func_73729_b(cornerX + slot.x, cornerY + slot.y, 177, 1, 16, 16);
        }
        int height = (int)this.assemblyTable.getCompletionRatio(70.0f);
        this.func_73729_b(cornerX + 95, cornerY + 36 + 70 - height, 176, 18, 4, height);
        this.drawBackgroundSlots();
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        if (position != -1) {
            RecipeSlot slot = (RecipeSlot)this.slots[position];
            if (slot.recipe == null) {
                return;
            }
            TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
            if (this.assemblyTable.isPlanned(slot.recipe)) {
                this.assemblyTable.cancelPlanOutput(slot.recipe);
                message.select = false;
            } else {
                this.assemblyTable.planOutput(slot.recipe);
                message.select = true;
            }
            message.stack = slot.recipe.output;
            if (CoreProxy.proxy.isRenderWorld(this.assemblyTable.field_70331_k)) {
                PacketNBT packet = new PacketNBT(21, message.getNBT(), this.assemblyTable.field_70329_l, this.assemblyTable.field_70330_m, this.assemblyTable.field_70327_n);
                CoreProxy.proxy.sendToServer(packet.getPacket());
            }
        }
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add(new AssemblyLedger());
    }

    class RecipeSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        public AssemblyRecipe recipe;

        public RecipeSlot(int x, int y) {
            super(x, y);
        }

        @Override
        public ItemStack getItemStack() {
            if (this.recipe != null) {
                return this.recipe.output;
            }
            return null;
        }
    }

    class AssemblyLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public AssemblyLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            ((GuiAssemblyTable)GuiAssemblyTable.this).field_73882_e.field_71446_o.func_110577_a(TextureMap.field_110576_c);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiAssemblyTable.this.field_73886_k.func_78261_a(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiAssemblyTable.this.field_73886_k.func_78261_a(StringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, this.subheaderColour);
            GuiAssemblyTable.this.field_73886_k.func_78276_b(String.format("%2.1f MJ", Float.valueOf(GuiAssemblyTable.this.assemblyTable.getRequiredEnergy())), x + 22, y + 32, this.textColour);
            GuiAssemblyTable.this.field_73886_k.func_78261_a(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiAssemblyTable.this.field_73886_k.func_78276_b(String.format("%2.1f MJ", Float.valueOf(GuiAssemblyTable.this.assemblyTable.getStoredEnergy())), x + 22, y + 56, this.textColour);
            GuiAssemblyTable.this.field_73886_k.func_78261_a(StringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, this.subheaderColour);
            GuiAssemblyTable.this.field_73886_k.func_78276_b(String.format("%3.2f MJ/t", Float.valueOf((float)GuiAssemblyTable.this.assemblyTable.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%3.2f MJ/t", Float.valueOf((float)GuiAssemblyTable.this.assemblyTable.getRecentEnergyAverage() / 100.0f));
        }
    }
}

