/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadArrays;
import buildcraft.core.triggers.ActionRedstoneOutput;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.triggers.ActionSignalOutput;
import com.google.common.collect.HashMultiset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public abstract class Gate {
    protected Pipe pipe;
    public GateKind kind;
    public ITrigger[] triggers = new ITrigger[8];
    public ITriggerParameter[] triggerParameters = new ITriggerParameter[8];
    public IAction[] actions = new IAction[8];
    public boolean[] broadcastSignal = new boolean[4];
    public boolean broadcastRedstone = false;

    public Gate(Pipe pipe) {
        this.pipe = pipe;
    }

    public Gate(Pipe pipe, ItemStack stack) {
        this.pipe = pipe;
        this.kind = GateKind.getKindFromDamage(stack);
    }

    public void setTrigger(int position, ITrigger trigger) {
        this.triggers[position] = trigger;
    }

    public ITrigger getTrigger(int position) {
        return this.triggers[position];
    }

    public void setAction(int position, IAction action) {
        this.actions[position] = action;
    }

    public IAction getAction(int position) {
        return this.actions[position];
    }

    public void setTriggerParameter(int position, ITriggerParameter p) {
        this.triggerParameters[position] = p;
    }

    public ITriggerParameter getTriggerParameter(int position) {
        return this.triggerParameters[position];
    }

    public void writeToNBT(NBTTagCompound data) {
        int i;
        data.func_74768_a("Kind", this.kind.ordinal());
        for (i = 0; i < 8; ++i) {
            if (this.triggers[i] != null) {
                data.func_74778_a("trigger[" + i + "]", this.triggers[i].getUniqueTag());
            }
            if (this.actions[i] != null) {
                data.func_74778_a("action[" + i + "]", this.actions[i].getUniqueTag());
            }
            if (this.triggerParameters[i] == null) continue;
            NBTTagCompound cpt = new NBTTagCompound();
            this.triggerParameters[i].writeToNBT(cpt);
            data.func_74782_a("triggerParameters[" + i + "]", (NBTBase)cpt);
        }
        for (i = 0; i < 4; ++i) {
            data.func_74757_a("wireState[" + i + "]", this.broadcastSignal[i]);
        }
        data.func_74757_a("redstoneState", this.broadcastRedstone);
    }

    public void readFromNBT(NBTTagCompound data) {
        int i;
        this.kind = GateKind.values()[data.func_74762_e("Kind")];
        for (i = 0; i < 8; ++i) {
            if (data.func_74764_b("trigger[" + i + "]")) {
                this.triggers[i] = (ITrigger)ActionManager.triggers.get(data.func_74779_i("trigger[" + i + "]"));
            }
            if (data.func_74764_b("action[" + i + "]")) {
                this.actions[i] = (IAction)ActionManager.actions.get(data.func_74779_i("action[" + i + "]"));
            }
            if (!data.func_74764_b("triggerParameters[" + i + "]")) continue;
            this.triggerParameters[i] = new TriggerParameter();
            this.triggerParameters[i].readFromNBT(data.func_74775_l("triggerParameters[" + i + "]"));
        }
        for (i = 0; i < 4; ++i) {
            this.broadcastSignal[i] = data.func_74767_n("wireState[" + i + "]");
        }
        this.broadcastRedstone = data.func_74767_n("redstoneState");
    }

    public PacketPayload toPayload() {
        PacketPayloadArrays payload = new PacketPayloadArrays(1, 0, 0);
        payload.intPayload[0] = this.kind.ordinal();
        return payload;
    }

    public abstract void openGui(EntityPlayer var1);

    public abstract void update();

    public abstract void dropGate();

    public void resetGate() {
        if (this.broadcastRedstone) {
            this.broadcastRedstone = false;
            this.pipe.updateNeighbors(true);
        }
    }

    public abstract String getName();

    public abstract GateConditional getConditional();

    public boolean isGateActive() {
        for (boolean b : this.broadcastSignal) {
            if (!b) continue;
            return true;
        }
        return this.broadcastRedstone;
    }

    public boolean isEmittingRedstone() {
        return this.broadcastRedstone;
    }

    public abstract void startResolution();

    public void resolveActions() {
        IAction action;
        boolean oldBroadcastRedstone = this.broadcastRedstone;
        boolean[] oldBroadcastSignal = this.broadcastSignal;
        this.broadcastRedstone = false;
        this.broadcastSignal = new boolean[]{false, false, false, false};
        this.startResolution();
        HashMap<IAction, Boolean> activeActions = new HashMap<IAction, Boolean>();
        HashMultiset actionCount = HashMultiset.create();
        for (int it = 0; it < 8; ++it) {
            ITrigger trigger = this.triggers[it];
            action = this.actions[it];
            ITriggerParameter parameter = this.triggerParameters[it];
            if (trigger == null || action == null) continue;
            actionCount.add((Object)action);
            if (!activeActions.containsKey(action)) {
                activeActions.put(action, this.isNearbyTriggerActive(trigger, parameter));
                continue;
            }
            if (this.getConditional() == GateConditional.AND) {
                activeActions.put(action, (Boolean)activeActions.get(action) != false && this.isNearbyTriggerActive(trigger, parameter));
                continue;
            }
            activeActions.put(action, (Boolean)activeActions.get(action) != false || this.isNearbyTriggerActive(trigger, parameter));
        }
        for (Map.Entry entry : activeActions.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue() || this.resolveAction(action = (IAction)entry.getKey(), actionCount.count((Object)action))) continue;
            if (action instanceof ActionRedstoneOutput) {
                this.broadcastRedstone = true;
                continue;
            }
            if (action instanceof ActionSignalOutput) {
                this.broadcastSignal[((ActionSignalOutput)action).color.ordinal()] = true;
                continue;
            }
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.pipe.container.getTile(side);
                if (!(tile instanceof IActionReceptor)) continue;
                IActionReceptor recept = (IActionReceptor)tile;
                recept.actionActivated(action);
            }
        }
        this.pipe.actionsActivated(activeActions);
        if (oldBroadcastRedstone != this.broadcastRedstone) {
            this.pipe.container.scheduleRenderUpdate();
            this.pipe.updateNeighbors(true);
        }
        for (int i = 0; i < oldBroadcastSignal.length; ++i) {
            if (oldBroadcastSignal[i] == this.broadcastSignal[i]) continue;
            this.pipe.container.scheduleRenderUpdate();
            this.pipe.updateSignalState();
            break;
        }
    }

    public abstract boolean resolveAction(IAction var1, int var2);

    public boolean isNearbyTriggerActive(ITrigger trigger, ITriggerParameter parameter) {
        if (trigger instanceof ITriggerPipe) {
            return ((ITriggerPipe)((Object)trigger)).isTriggerActive(this.pipe, parameter);
        }
        if (trigger != null) {
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.pipe.container.getTile(o);
                if (tile == null || tile instanceof TileGenericPipe || !trigger.isTriggerActive(o.getOpposite(), tile, parameter)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void addTrigger(LinkedList var1);

    public abstract void addActions(LinkedList var1);

    public abstract int getTextureIconIndex(boolean var1);

    public abstract ResourceLocation getGuiFile();

    public static boolean isGateItem(ItemStack stack) {
        return stack.field_77993_c == BuildCraftTransport.pipeGate.field_77779_bT || stack.field_77993_c == BuildCraftTransport.pipeGateAutarchic.field_77779_bT;
    }

    public static Gate makeGate(Pipe pipe, NBTTagCompound data) {
        GateVanilla gate = new GateVanilla(pipe);
        ((Gate)gate).readFromNBT(data);
        return gate;
    }

    public static Gate makeGate(Pipe pipe, ItemStack stack) {
        return new GateVanilla(pipe, stack);
    }

    public static enum GateConditional {
        None,
        AND,
        OR;

    }

    public static enum GateKind {
        None,
        Single,
        AND_2,
        OR_2,
        AND_3,
        OR_3,
        AND_4,
        OR_4;


        public static GateKind getKindFromDamage(ItemStack itemstack) {
            switch (itemstack.func_77960_j()) {
                case 0: {
                    return Single;
                }
                case 1: {
                    return AND_2;
                }
                case 2: {
                    return OR_2;
                }
                case 3: {
                    return AND_3;
                }
                case 4: {
                    return OR_3;
                }
                case 5: {
                    return AND_4;
                }
                case 6: {
                    return OR_4;
                }
            }
            return None;
        }
    }
}

