/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipe;
import buildcraft.core.DefaultProps;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.EnergyPulser;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.triggers.ActionEnergyPulser;
import buildcraft.transport.triggers.ActionSingleEnergyPulse;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GateVanilla
extends Gate {
    private EnergyPulser pulser;
    private static final ResourceLocation TEXTURE1 = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/gate_interface_1.png");
    private static final ResourceLocation TEXTURE2 = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/gate_interface_2.png");
    private static final ResourceLocation TEXTURE3 = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/gate_interface_3.png");
    private static final ResourceLocation TEXTURE4 = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/gate_interface_4.png");

    public GateVanilla(Pipe pipe) {
        super(pipe);
    }

    public GateVanilla(Pipe pipe, ItemStack stack) {
        super(pipe, stack);
        if (stack.field_77993_c == BuildCraftTransport.pipeGateAutarchic.field_77779_bT) {
            this.addEnergyPulser(pipe);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.pulser != null) {
            NBTTagCompound nbttagcompoundC = new NBTTagCompound();
            this.pulser.writeToNBT(nbttagcompoundC);
            nbttagcompound.func_74782_a("Pulser", (NBTBase)nbttagcompoundC);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("Pulser")) {
            NBTTagCompound nbttagcompoundP = nbttagcompound.func_74775_l("Pulser");
            this.addEnergyPulser(this.pipe);
            this.pulser.readFromNBT(nbttagcompoundP);
        }
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (!CoreProxy.proxy.isRenderWorld(player.field_70170_p)) {
            player.openGui((Object)BuildCraftTransport.instance, 51, this.pipe.container.field_70331_k, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n);
        }
    }

    @Override
    public void update() {
        if (this.hasPulser()) {
            this.pulser.update();
        }
    }

    public boolean hasPulser() {
        return this.pulser != null;
    }

    @Override
    public String getName() {
        switch (this.kind) {
            case Single: {
                return StringUtils.localize("item.pipeGate.0");
            }
            case AND_2: {
                return StringUtils.localize("item.pipeGate.1");
            }
            case AND_3: {
                return StringUtils.localize("item.pipeGate.3");
            }
            case AND_4: {
                return StringUtils.localize("item.pipeGate.5");
            }
            case OR_2: {
                return StringUtils.localize("item.pipeGate.2");
            }
            case OR_3: {
                return StringUtils.localize("item.pipeGate.4");
            }
            case OR_4: {
                return StringUtils.localize("item.pipeGate.6");
            }
        }
        return "";
    }

    @Override
    public Gate.GateConditional getConditional() {
        if (this.kind == Gate.GateKind.OR_2 || this.kind == Gate.GateKind.OR_3 || this.kind == Gate.GateKind.OR_4) {
            return Gate.GateConditional.OR;
        }
        if (this.kind == Gate.GateKind.AND_2 || this.kind == Gate.GateKind.AND_3 || this.kind == Gate.GateKind.AND_4) {
            return Gate.GateConditional.AND;
        }
        return Gate.GateConditional.None;
    }

    private boolean addEnergyPulser(Pipe pipe) {
        if (!(pipe instanceof IPowerReceptor) || pipe instanceof PipePowerWood) {
            this.pulser = new EnergyPulser(null);
            return false;
        }
        this.pulser = new EnergyPulser((IPowerReceptor)((Object)pipe));
        return true;
    }

    @Override
    public void dropGate() {
        int gateDamage;
        switch (this.kind) {
            case Single: {
                gateDamage = 0;
                break;
            }
            case AND_2: {
                gateDamage = 1;
                break;
            }
            case OR_2: {
                gateDamage = 2;
                break;
            }
            case AND_3: {
                gateDamage = 3;
                break;
            }
            case OR_3: {
                gateDamage = 4;
                break;
            }
            case AND_4: {
                gateDamage = 5;
                break;
            }
            default: {
                gateDamage = 6;
            }
        }
        Item gateItem = this.hasPulser() ? BuildCraftTransport.pipeGateAutarchic : BuildCraftTransport.pipeGate;
        this.pipe.dropItem(new ItemStack(gateItem, 1, gateDamage));
    }

    @Override
    public void addActions(LinkedList list) {
        if (this.pipe.wireSet[IPipe.WireColor.Red.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_2.ordinal()) {
            list.add(BuildCraftTransport.actionRedSignal);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Blue.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_3.ordinal()) {
            list.add(BuildCraftTransport.actionBlueSignal);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Green.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_4.ordinal()) {
            list.add(BuildCraftTransport.actionGreenSignal);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Yellow.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_4.ordinal()) {
            list.add(BuildCraftTransport.actionYellowSignal);
        }
        if (this.hasPulser()) {
            list.add(BuildCraftTransport.actionEnergyPulser);
            list.add(BuildCraftTransport.actionSingleEnergyPulse);
        }
    }

    @Override
    public void startResolution() {
        if (this.hasPulser() && this.pulser.isActive()) {
            this.pulser.disablePulse();
            this.pipe.container.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean resolveAction(IAction action, int count) {
        if (action instanceof ActionEnergyPulser) {
            this.pulser.enablePulse(count);
            this.pipe.container.scheduleRenderUpdate();
            return true;
        }
        if (action instanceof ActionSingleEnergyPulse) {
            this.pulser.enableSinglePulse(count);
            this.pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void addTrigger(LinkedList list) {
        if (this.pipe.wireSet[IPipe.WireColor.Red.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_2.ordinal()) {
            list.add(BuildCraftTransport.triggerRedSignalActive);
            list.add(BuildCraftTransport.triggerRedSignalInactive);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Blue.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_3.ordinal()) {
            list.add(BuildCraftTransport.triggerBlueSignalActive);
            list.add(BuildCraftTransport.triggerBlueSignalInactive);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Green.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_4.ordinal()) {
            list.add(BuildCraftTransport.triggerGreenSignalActive);
            list.add(BuildCraftTransport.triggerGreenSignalInactive);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Yellow.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_4.ordinal()) {
            list.add(BuildCraftTransport.triggerYellowSignalActive);
            list.add(BuildCraftTransport.triggerYellowSignalInactive);
        }
    }

    @Override
    public final int getTextureIconIndex(boolean isSignalActive) {
        boolean isGateActive = isSignalActive;
        if (this.hasPulser() && this.pulser.isActive()) {
            isGateActive = true;
        }
        if (!this.hasPulser()) {
            switch (this.kind) {
                case None: {
                    return 0;
                }
                case Single: {
                    return isGateActive ? 1 : 0;
                }
                case AND_2: {
                    return isGateActive ? 3 : 2;
                }
                case OR_2: {
                    return isGateActive ? 5 : 4;
                }
                case AND_3: {
                    return isGateActive ? 7 : 6;
                }
                case OR_3: {
                    return isGateActive ? 9 : 8;
                }
                case AND_4: {
                    return isGateActive ? 11 : 10;
                }
                case OR_4: {
                    return isGateActive ? 13 : 12;
                }
            }
        } else {
            switch (this.kind) {
                case None: {
                    return 0;
                }
                case Single: {
                    return isGateActive ? 15 : 14;
                }
                case AND_2: {
                    return isGateActive ? 17 : 16;
                }
                case OR_2: {
                    return isGateActive ? 19 : 18;
                }
                case AND_3: {
                    return isGateActive ? 21 : 20;
                }
                case OR_3: {
                    return isGateActive ? 23 : 22;
                }
                case AND_4: {
                    return isGateActive ? 25 : 24;
                }
                case OR_4: {
                    return isGateActive ? 27 : 26;
                }
            }
        }
        return 0;
    }

    @Override
    public ResourceLocation getGuiFile() {
        if (this.kind == Gate.GateKind.Single) {
            return TEXTURE1;
        }
        if (this.kind == Gate.GateKind.AND_2 || this.kind == Gate.GateKind.OR_2) {
            return TEXTURE2;
        }
        if (this.kind == Gate.GateKind.AND_3 || this.kind == Gate.GateKind.OR_3) {
            return TEXTURE3;
        }
        return TEXTURE4;
    }
}

