/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsQuartz;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipePowerWood;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;

public class PipeConnectionBans {
    private static final SetMultimap connectionBans = HashMultimap.create();

    private PipeConnectionBans() {
    }

    public static void banConnection(Class ... types) {
        if (types.length == 0) {
            return;
        }
        if (types.length == 1) {
            connectionBans.put((Object)types[0], (Object)types[0]);
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < types.length; ++j) {
                if (i == j) continue;
                connectionBans.put((Object)types[i], (Object)types[j]);
            }
        }
    }

    public static boolean canPipesConnect(Class type1, Class type2) {
        return !connectionBans.containsEntry((Object)type1, (Object)type2);
    }

    static {
        PipeConnectionBans.banConnection(PipeFluidsStone.class, PipeFluidsCobblestone.class);
        PipeConnectionBans.banConnection(PipeFluidsWood.class);
        PipeConnectionBans.banConnection(PipeItemsStone.class, PipeItemsCobblestone.class, PipeItemsQuartz.class);
        PipeConnectionBans.banConnection(PipeItemsWood.class);
        PipeConnectionBans.banConnection(PipeItemsObsidian.class);
        PipeConnectionBans.banConnection(PipePowerWood.class);
    }
}

