/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.network.PacketUpdate;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gui.ContainerGateInterface;
import buildcraft.transport.network.PacketFluidUpdate;
import buildcraft.transport.network.PacketPipeTransportContent;
import buildcraft.transport.network.PacketPipeTransportNBT;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.network.PacketSimpleId;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandlerTransport
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet2, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet2.field_73629_c));
        try {
            int packetID = data.read();
            PacketUpdate packet = new PacketUpdate();
            switch (packetID) {
                case 4: {
                    PacketPowerUpdate packetPower = new PacketPowerUpdate();
                    packetPower.readData(data);
                    this.onPacketPower((EntityPlayer)player, packetPower);
                    break;
                }
                case 3: {
                    PacketFluidUpdate packetFluid = new PacketFluidUpdate();
                    packetFluid.readData(data);
                    break;
                }
                case 2: {
                    PacketPipeTransportContent packetC = new PacketPipeTransportContent();
                    packetC.readData(data);
                    this.onPipeContentUpdate((EntityPlayer)player, packetC);
                    break;
                }
                case 40: {
                    packet.readData(data);
                    this.onGateActions((EntityPlayer)player, packet);
                    break;
                }
                case 45: {
                    packet.readData(data);
                    this.onGateTriggers((EntityPlayer)player, packet);
                    break;
                }
                case 43: {
                    packet.readData(data);
                    this.onGateSelection((EntityPlayer)player, packet);
                    break;
                }
                case 6: {
                    PacketPipeTransportNBT packetD = new PacketPipeTransportNBT();
                    packetD.readData(data);
                    this.onPipeContentNBT((EntityPlayer)player, packetD);
                    break;
                }
                case 31: {
                    PacketSlotChange packet1 = new PacketSlotChange();
                    packet1.readData(data);
                    this.onDiamondPipeSelect((EntityPlayer)player, packet1);
                    break;
                }
                case 32: {
                    PacketSlotChange packet1 = new PacketSlotChange();
                    packet1.readData(data);
                    this.onEmeraldPipeSelect((EntityPlayer)player, packet1);
                    break;
                }
                case 41: {
                    PacketCoordinates packetU = new PacketCoordinates();
                    packetU.readData(data);
                    this.onGateInitRequest((EntityPlayer)player, packetU);
                    break;
                }
                case 42: {
                    PacketCoordinates packetS = new PacketCoordinates();
                    packetS.readData(data);
                    this.onGateSelectionRequest((EntityPlayer)((EntityPlayerMP)player), packetS);
                    break;
                }
                case 44: {
                    PacketUpdate packet3 = new PacketUpdate();
                    packet3.readData(data);
                    this.onGateSelectionChange((EntityPlayer)((EntityPlayerMP)player), packet3);
                    break;
                }
                case 5: {
                    PacketSimpleId packet4 = new PacketSimpleId();
                    packet4.readData(data);
                    this.onItemNBTRequest((EntityPlayerMP)player, packet4);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onGateActions(EntityPlayer player, PacketUpdate packet) {
        Container container = player.field_71070_bA;
        if (!(container instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)container).updateActions(packet);
    }

    private void onGateTriggers(EntityPlayer player, PacketUpdate packet) {
        Container container = player.field_71070_bA;
        if (!(container instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)container).updateTriggers(packet);
    }

    private void onGateSelection(EntityPlayer player, PacketUpdate packet) {
        Container container = player.field_71070_bA;
        if (!(container instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)container).setSelection(packet, false);
    }

    private void onPipeContentNBT(EntityPlayer player, PacketPipeTransportNBT packet) {
        TileGenericPipe pipe = this.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportItems)) {
            return;
        }
        ((PipeTransportItems)pipe.pipe.transport).handleNBTPacket(packet);
    }

    private void onPipeContentUpdate(EntityPlayer player, PacketPipeTransportContent packet) {
        World world = player.field_70170_p;
        if (!world.func_72899_e(packet.posX, packet.posY, packet.posZ)) {
            return;
        }
        TileEntity entity = world.func_72796_p(packet.posX, packet.posY, packet.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportItems)) {
            return;
        }
        ((PipeTransportItems)pipe.pipe.transport).handleItemPacket(packet);
    }

    private void onPacketPower(EntityPlayer player, PacketPowerUpdate packetPower) {
        World world = player.field_70170_p;
        if (!world.func_72899_e(packetPower.posX, packetPower.posY, packetPower.posZ)) {
            return;
        }
        TileEntity entity = world.func_72796_p(packetPower.posX, packetPower.posY, packetPower.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportPower)) {
            return;
        }
        ((PipeTransportPower)pipe.pipe.transport).handlePowerPacket(packetPower);
    }

    private void onGateSelectionChange(EntityPlayer playerEntity, PacketUpdate packet) {
        if (!(playerEntity.field_71070_bA instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)playerEntity.field_71070_bA).setSelection(packet, true);
    }

    private void onGateSelectionRequest(EntityPlayer playerEntity, PacketCoordinates packet) {
        if (!(playerEntity.field_71070_bA instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)playerEntity.field_71070_bA).sendSelection(playerEntity);
    }

    private void onGateInitRequest(EntityPlayer playerEntity, PacketCoordinates packet) {
        if (!(playerEntity.field_71070_bA instanceof ContainerGateInterface)) {
            return;
        }
        ((ContainerGateInterface)playerEntity.field_71070_bA).handleInitRequest(playerEntity);
    }

    private TileGenericPipe getPipe(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }

    private void onDiamondPipeSelect(EntityPlayer player, PacketSlotChange packet) {
        TileGenericPipe pipe = this.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeItemsDiamond)) {
            return;
        }
        ((PipeItemsDiamond)pipe.pipe).getFilters().func_70299_a(packet.slot, packet.stack);
    }

    private void onEmeraldPipeSelect(EntityPlayer player, PacketSlotChange packet) {
        TileGenericPipe pipe = this.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe instanceof PipeItemsEmerald)) {
            return;
        }
        ((PipeItemsEmerald)pipe.pipe).getFilters().func_70299_a(packet.slot, packet.stack);
    }

    private void onItemNBTRequest(EntityPlayerMP player, PacketSimpleId packet) {
        TileGenericPipe pipe = this.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportItems)) {
            return;
        }
        ((PipeTransportItems)pipe.pipe.transport).handleNBTRequestPacket((EntityPlayer)player, packet.entityId);
    }
}

