/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.triggers.ActionPipeDirection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsIron
extends Pipe {
    private int standardIconIndex = PipeIconProvider.TYPE.PipeItemsIron_Standard.ordinal();
    private int solidIconIndex = PipeIconProvider.TYPE.PipeAllIron_Solid.ordinal();
    private PipeLogicIron logic = new PipeLogicIron(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof TileGenericPipe) {
                Pipe otherPipe = ((TileGenericPipe)tile).pipe;
                if (otherPipe instanceof PipeItemsWood) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportItems;
            }
            return tile instanceof IInventory;
        }
    };

    public PipeItemsIron(int itemID) {
        super(new PipeTransportItems(), itemID);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.switchOnRedstone();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        return super.outputOpen(to) && this.logic.outputOpen(to);
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_70322_n();
        if (metadata != direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    protected void actionsActivated(Map actions) {
        super.actionsActivated(actions);
        for (Map.Entry action : actions.entrySet()) {
            if (!(action.getKey() instanceof ActionPipeDirection) || action.getValue() == null || !((Boolean)action.getValue()).booleanValue()) continue;
            this.logic.setFacing(((ActionPipeDirection)action.getKey()).direction);
            break;
        }
    }

    @Override
    public LinkedList getActions() {
        LinkedList action = super.getActions();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }
}

