/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.TileBuffer;
import buildcraft.transport.Pipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class PipeLogicIron {
    private boolean lastPower = false;
    protected final Pipe pipe;

    public PipeLogicIron(Pipe pipe) {
        this.pipe = pipe;
    }

    public void switchOnRedstone() {
        boolean currentPower = this.pipe.container.field_70331_k.func_72864_z(this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n);
        if (currentPower != this.lastPower) {
            this.switchPosition();
            this.lastPower = currentPower;
        }
    }

    private void switchPosition() {
        int meta = this.pipe.container.func_70322_n();
        for (int i = meta + 1; i <= meta + 6; ++i) {
            ForgeDirection facing = ForgeDirection.getOrientation((int)(i % 6));
            if (!this.setFacing(facing)) continue;
            return;
        }
    }

    private boolean isValidFacing(ForgeDirection side) {
        TileBuffer[] tileBuffer = this.pipe.container.getTileCache();
        if (tileBuffer == null) {
            return true;
        }
        if (!tileBuffer[side.ordinal()].exists()) {
            return true;
        }
        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return this.isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity var1);

    public void initialize() {
        this.lastPower = this.pipe.container.field_70331_k.func_72864_z(this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n);
    }

    public void onBlockPlaced() {
        this.pipe.container.field_70331_k.func_72921_c(this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, 1, 3);
        this.switchPosition();
    }

    public boolean setFacing(ForgeDirection facing) {
        if (this.isValidFacing(facing) && facing.ordinal() != this.pipe.container.func_70322_n()) {
            this.pipe.container.field_70331_k.func_72921_c(this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, facing.ordinal(), 3);
            this.pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n)) {
            this.switchPosition();
            this.pipe.container.field_70331_k.func_72845_h(this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n);
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n);
            return true;
        }
        return false;
    }

    public boolean outputOpen(ForgeDirection to) {
        return to.ordinal() == this.pipe.container.func_70322_n();
    }
}

