/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.gates.ActionManager;
import buildcraft.builders.BlockArchitect;
import buildcraft.builders.BlockBlueprintLibrary;
import buildcraft.builders.BlockBuilder;
import buildcraft.builders.BlockFiller;
import buildcraft.builders.BlockMarker;
import buildcraft.builders.BlockPathMarker;
import buildcraft.builders.EventHandlerBuilders;
import buildcraft.builders.GuiHandler;
import buildcraft.builders.IBuilderHook;
import buildcraft.builders.ItemBptBluePrint;
import buildcraft.builders.ItemBptTemplate;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.TileFiller;
import buildcraft.builders.TileMarker;
import buildcraft.builders.TilePathMarker;
import buildcraft.builders.filler.FillerRegistry;
import buildcraft.builders.filler.pattern.FillerPattern;
import buildcraft.builders.filler.pattern.PatternBox;
import buildcraft.builders.filler.pattern.PatternClear;
import buildcraft.builders.filler.pattern.PatternCylinder;
import buildcraft.builders.filler.pattern.PatternFill;
import buildcraft.builders.filler.pattern.PatternFlatten;
import buildcraft.builders.filler.pattern.PatternHorizon;
import buildcraft.builders.filler.pattern.PatternPyramid;
import buildcraft.builders.filler.pattern.PatternStairs;
import buildcraft.builders.network.PacketHandlerBuilders;
import buildcraft.builders.triggers.ActionFiller;
import buildcraft.builders.triggers.BuildersActionProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.blueprints.BptPlayerIndex;
import buildcraft.core.blueprints.BptRootIndex;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BCLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import java.io.IOException;
import java.util.LinkedList;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;

@Mod(name="BuildCraft Builders", version="5.0.6", useMetadata=false, modid="BuildCraft|Builders", dependencies="required-after:BuildCraft|Core@5.0.6")
public class BuildCraftBuilders
extends BuildCraftMod {
    public static final int LIBRARY_PAGE_SIZE = 12;
    public static final int MAX_BLUEPRINTS_NAME_SIZE = 14;
    public static BlockMarker markerBlock;
    public static BlockPathMarker pathMarkerBlock;
    public static BlockFiller fillerBlock;
    public static BlockBuilder builderBlock;
    public static BlockArchitect architectBlock;
    public static BlockBlueprintLibrary libraryBlock;
    public static ItemBptTemplate templateItem;
    public static ItemBptBluePrint blueprintItem;
    public static boolean fillerDestroy;
    public static int fillerLifespanTough;
    public static int fillerLifespanNormal;
    public static ActionFiller[] fillerActions;
    private static BptRootIndex rootBptIndex;
    public static TreeMap<String, BptPlayerIndex> playerLibrary;
    private static LinkedList<IBuilderHook> hooks;
    @Mod.Instance(value="BuildCraft|Builders")
    public static BuildCraftBuilders instance;

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-BUILDERS", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandlerBuilders()});
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerBuilders());
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftBuilders.loadRecipes();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Property fillerDestroyProp = BuildCraftCore.mainConfiguration.get("general", "filler.destroy", DefaultProps.FILLER_DESTROY);
        fillerDestroyProp.comment = "If true, Filler will destroy blocks instead of breaking them.";
        fillerDestroy = fillerDestroyProp.getBoolean(DefaultProps.FILLER_DESTROY);
        Property fillerLifespanToughProp = BuildCraftCore.mainConfiguration.get("general", "filler.lifespan.tough", 20);
        fillerLifespanToughProp.comment = "Lifespan in ticks of items dropped by the filler from 'tough' blocks (those that can't be broken by hand)";
        fillerLifespanTough = fillerLifespanToughProp.getInt(20);
        Property fillerLifespanNormalProp = BuildCraftCore.mainConfiguration.get("general", "filler.lifespan.other", 6000);
        fillerLifespanNormalProp.comment = "Lifespan in ticks of items dropped by the filler from non-tough blocks (those that can be broken by hand)";
        fillerLifespanNormal = fillerLifespanNormalProp.getInt(6000);
        templateItem = new ItemBptTemplate();
        templateItem.func_77655_b("templateItem");
        LanguageRegistry.addName((Object)((Object)templateItem), (String)"Template");
        CoreProxy.proxy.registerItem(templateItem);
        blueprintItem = new ItemBptBluePrint();
        blueprintItem.func_77655_b("blueprintItem");
        LanguageRegistry.addName((Object)((Object)blueprintItem), (String)"Blueprint");
        CoreProxy.proxy.registerItem(blueprintItem);
        markerBlock = new BlockMarker();
        CoreProxy.proxy.registerBlock(markerBlock.func_149663_c("markerBlock"));
        pathMarkerBlock = new BlockPathMarker();
        CoreProxy.proxy.registerBlock(pathMarkerBlock.func_149663_c("pathMarkerBlock"));
        fillerBlock = new BlockFiller();
        CoreProxy.proxy.registerBlock(fillerBlock.func_149663_c("fillerBlock"));
        builderBlock = new BlockBuilder();
        CoreProxy.proxy.registerBlock(builderBlock.func_149663_c("builderBlock"));
        architectBlock = new BlockArchitect();
        CoreProxy.proxy.registerBlock(architectBlock.func_149663_c("architectBlock"));
        libraryBlock = new BlockBlueprintLibrary();
        CoreProxy.proxy.registerBlock(libraryBlock.func_149663_c("libraryBlock"));
        GameRegistry.registerTileEntity(TileMarker.class, (String)"Marker");
        GameRegistry.registerTileEntity(TileFiller.class, (String)"Filler");
        GameRegistry.registerTileEntity(TileBuilder.class, (String)"net.minecraft.src.builders.TileBuilder");
        GameRegistry.registerTileEntity(TileArchitect.class, (String)"net.minecraft.src.builders.TileTemplate");
        GameRegistry.registerTileEntity(TilePathMarker.class, (String)"net.minecraft.src.builders.TilePathMarker");
        GameRegistry.registerTileEntity(TileBlueprintLibrary.class, (String)"net.minecraft.src.builders.TileBlueprintLibrary");
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            FillerManager.registry = new FillerRegistry();
            FillerManager.registry.addPattern(PatternFill.INSTANCE);
            FillerManager.registry.addPattern(new PatternFlatten());
            FillerManager.registry.addPattern(new PatternHorizon());
            FillerManager.registry.addPattern(new PatternClear());
            FillerManager.registry.addPattern(new PatternBox());
            FillerManager.registry.addPattern(new PatternPyramid());
            FillerManager.registry.addPattern(new PatternStairs());
            FillerManager.registry.addPattern(new PatternCylinder());
        }
        catch (Error error) {
            BCLog.logErrorAPI("Buildcraft", error, IFillerPattern.class);
            throw error;
        }
        ActionManager.registerActionProvider(new BuildersActionProvider());
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)markerBlock, 1), "l ", "r ", Character.valueOf('l'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('r'), Blocks.field_150429_aA);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)fillerBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ItemStack(Items.field_151100_aR, 1, 11), Character.valueOf('c'), Blocks.field_150462_ai, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('C'), Blocks.field_150486_ae});
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    public static BptPlayerIndex getPlayerIndex(String name) {
        BptRootIndex rootIndex = BuildCraftBuilders.getBptRootIndex();
        if (!playerLibrary.containsKey(name)) {
            try {
                playerLibrary.put(name, new BptPlayerIndex(name + ".list", rootIndex));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return playerLibrary.get(name);
    }

    public static BptRootIndex getBptRootIndex() {
        if (rootBptIndex == null) {
            try {
                rootBptIndex = new BptRootIndex("index.txt");
                rootBptIndex.loadIndex();
                for (IBuilderHook hook : hooks) {
                    hook.rootIndexInitialized(rootBptIndex);
                }
                rootBptIndex.importNewFiles();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rootBptIndex;
    }

    public static ItemStack getBptItemStack(Item item, int damage, String name) {
        ItemStack stack = new ItemStack(item, 1, damage);
        NBTTagCompound nbt = new NBTTagCompound();
        if (name != null && !"".equals(name)) {
            nbt.func_74778_a("BptName", name);
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    public static void addHook(IBuilderHook hook) {
        if (!hooks.contains(hook)) {
            hooks.add(hook);
        }
    }

    @Mod.EventHandler
    public void ServerStop(FMLServerStoppingEvent event) {
        TilePathMarker.clearAvailableMarkersList();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        if (evt.map.func_130086_a() == 0) {
            for (FillerPattern pattern : FillerPattern.patterns) {
                pattern.registerIcon((IIconRegister)evt.map);
            }
        }
    }

    static {
        playerLibrary = new TreeMap();
        hooks = new LinkedList();
    }
}

