/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.core.BlockIndex;
import buildcraft.core.BlockSpring;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.BCLog;
import buildcraft.energy.BlockBuildcraftFluid;
import buildcraft.energy.BlockEngine;
import buildcraft.energy.BucketHandler;
import buildcraft.energy.EnergyProxy;
import buildcraft.energy.GuiHandler;
import buildcraft.energy.ItemBucketBuildcraft;
import buildcraft.energy.ItemEngine;
import buildcraft.energy.TileEngine;
import buildcraft.energy.triggers.TriggerEngineHeat;
import buildcraft.energy.worldgen.BiomeGenOilDesert;
import buildcraft.energy.worldgen.BiomeGenOilOcean;
import buildcraft.energy.worldgen.BiomeInitializer;
import buildcraft.energy.worldgen.OilPopulate;
import buildcraft.transport.network.PacketHandlerTransport;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Mod(name="BuildCraft Energy", version="5.0.6", useMetadata=false, modid="BuildCraft|Energy", dependencies="required-after:BuildCraft|Core@5.0.6")
public class BuildCraftEnergy
extends BuildCraftMod {
    public static final int ENERGY_REMOVE_BLOCK = 25;
    public static final int ENERGY_EXTRACT_ITEM = 2;
    public static boolean spawnOilSprings = true;
    public static BiomeGenOilDesert biomeOilDesert;
    public static BiomeGenOilOcean biomeOilOcean;
    public static BlockEngine engineBlock;
    private static Fluid buildcraftFluidOil;
    private static Fluid buildcraftFluidFuel;
    public static Fluid fluidOil;
    public static Fluid fluidFuel;
    public static Block blockOil;
    public static Block blockFuel;
    public static Item bucketOil;
    public static Item bucketFuel;
    public static Item fuel;
    public static boolean canOilBurn;
    public static double oilWellScalar;
    public static Set<Integer> oilBiomeIDs;
    public static Set<Integer> excessiveOilBiomeIDs;
    public static Set<Integer> excludeOilBiomeIDs;
    public static TreeMap<BlockIndex, Integer> saturationStored;
    public static BCTrigger triggerBlueEngineHeat;
    public static BCTrigger triggerGreenEngineHeat;
    public static BCTrigger triggerYellowEngineHeat;
    public static BCTrigger triggerRedEngineHeat;
    @Mod.Instance(value="BuildCraft|Energy")
    public static BuildCraftEnergy instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        int oilDesertBiomeId = BuildCraftCore.mainConfiguration.get("biomes", "biomeOilDesert", DefaultProps.BIOME_OIL_DESERT).getInt(DefaultProps.BIOME_OIL_DESERT);
        int oilOceanBiomeId = BuildCraftCore.mainConfiguration.get("biomes", "biomeOilOcean", DefaultProps.BIOME_OIL_OCEAN).getInt(DefaultProps.BIOME_OIL_OCEAN);
        canOilBurn = BuildCraftCore.mainConfiguration.get("general", "burnOil", true, "Can oil burn?").getBoolean(true);
        oilWellScalar = BuildCraftCore.mainConfiguration.get("general", "oilWellGenerationRate", 1.0, "Probability of oil well generation").getDouble(1.0);
        for (String id : BuildCraftCore.mainConfiguration.get("general", "oilBiomeIDs", BiomeDictionary.Type.DESERT.toString() + "," + BiomeGenBase.field_76768_g.field_76756_M, "IDs or Biome Types (e.g. DESERT,OCEAN) of biomes that should have increased oil generation rates.").getString().trim().split(",")) {
            if ((id = id.trim()).length() <= 0) continue;
            try {
                oilBiomeIDs.add(Integer.parseInt(id));
            }
            catch (NumberFormatException ex) {
                try {
                    for (BiomeGenBase b : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.valueOf((String)id.toUpperCase()))) {
                        oilBiomeIDs.add(b.field_76756_M);
                    }
                }
                catch (Exception e) {
                    BCLog.logger.log(Level.WARNING, "config.oilBiomeIDs: Could not find biome type: " + id + " ; Skipping!");
                }
            }
        }
        for (String id : BuildCraftCore.mainConfiguration.get("general", "excessiveOilBiomeIDs", "", "IDs or Biome Types (e.g. DESERT,OCEAN) of biomes that should have GREATLY increased oil generation rates.").getString().trim().split(",")) {
            if ((id = id.trim()).length() <= 0) continue;
            try {
                excessiveOilBiomeIDs.add(Integer.parseInt(id));
            }
            catch (NumberFormatException ex) {
                try {
                    for (BiomeGenBase b : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.valueOf((String)id.toUpperCase()))) {
                        excessiveOilBiomeIDs.add(b.field_76756_M);
                    }
                }
                catch (Exception e) {
                    BCLog.logger.log(Level.WARNING, "config.excessiveOilBiomeIDs: Could not find biome type: " + id + " ; Skipping!");
                }
            }
        }
        for (String id : BuildCraftCore.mainConfiguration.get("general", "excludeOilBiomeIDs", BiomeGenBase.field_76779_k.field_76756_M + "," + BiomeGenBase.field_76778_j.field_76756_M, "IDs or Biome Types (e.g. DESERT,OCEAN) of biomes that are excluded from generating oil.").getString().trim().split(",")) {
            if ((id = id.trim()).length() <= 0) continue;
            try {
                excludeOilBiomeIDs.add(Integer.parseInt(id));
            }
            catch (NumberFormatException ex) {
                try {
                    for (BiomeGenBase b : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.valueOf((String)id.toUpperCase()))) {
                        excludeOilBiomeIDs.add(b.field_76756_M);
                    }
                }
                catch (Exception e) {
                    BCLog.logger.log(Level.WARNING, "config.excludeOilBiomeIDs: Could not find biome type: " + id + " ; Skipping!");
                }
            }
        }
        double fuelOilMultiplier = BuildCraftCore.mainConfiguration.get("general", "fuel.oil.combustion", 1.0, "adjust energy value of Oil in Combustion Engines").getDouble(1.0);
        double fuelFuelMultiplier = BuildCraftCore.mainConfiguration.get("general", "fuel.fuel.combustion", 1.0, "adjust energy value of Fuel in Combustion Engines").getDouble(1.0);
        BuildCraftCore.mainConfiguration.save();
        if (oilDesertBiomeId > 0) {
            if (BiomeGenBase.func_150565_n()[oilDesertBiomeId] != null) {
                oilDesertBiomeId = this.findUnusedBiomeID("oilDesert");
                BuildCraftCore.mainConfiguration.get("biomes", "biomeOilDesert", oilDesertBiomeId).set(oilDesertBiomeId);
                BuildCraftCore.mainConfiguration.save();
            }
            biomeOilDesert = BiomeGenOilDesert.makeBiome(oilDesertBiomeId);
        }
        if (oilOceanBiomeId > 0) {
            if (BiomeGenBase.func_150565_n()[oilOceanBiomeId] != null) {
                oilOceanBiomeId = this.findUnusedBiomeID("oilOcean");
                BuildCraftCore.mainConfiguration.get("biomes", "biomeOilOcean", oilOceanBiomeId).set(oilOceanBiomeId);
                BuildCraftCore.mainConfiguration.save();
            }
            biomeOilOcean = BiomeGenOilOcean.makeBiome(oilOceanBiomeId);
        }
        engineBlock = new BlockEngine();
        CoreProxy.proxy.registerBlock((Block)engineBlock, ItemEngine.class);
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 0), (String)"Redstone Engine");
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 1), (String)"Steam Engine");
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 2), (String)"Combustion Engine");
        buildcraftFluidOil = new Fluid("oil").setDensity(800).setViscosity(1500);
        FluidRegistry.registerFluid((Fluid)buildcraftFluidOil);
        fluidOil = FluidRegistry.getFluid((String)"oil");
        buildcraftFluidFuel = new Fluid("fuel");
        FluidRegistry.registerFluid((Fluid)buildcraftFluidFuel);
        fluidFuel = FluidRegistry.getFluid((String)"fuel");
        if (fluidOil.getBlock() == null) {
            blockOil = new BlockBuildcraftFluid(fluidOil, Material.field_151586_h).setFlammable(canOilBurn).setFlammability(0);
            blockOil.func_149663_c("blockOil");
            CoreProxy.proxy.registerBlock(blockOil);
            fluidOil.setBlock(blockOil);
        } else {
            blockOil = fluidOil.getBlock();
        }
        if (blockOil != null) {
            BlockSpring.EnumSpring.OIL.canGen = spawnOilSprings = BuildCraftCore.mainConfiguration.get("worldgen", "oilSprings", true).getBoolean(true);
            BlockSpring.EnumSpring.OIL.liquidBlock = blockOil;
        }
        if (fluidFuel.getBlock() == null) {
            blockFuel = new BlockBuildcraftFluid(fluidFuel, Material.field_151586_h).setFlammable(true).setFlammability(5).setParticleColor(0.7f, 0.7f, 0.0f);
            blockFuel.func_149663_c("blockFuel");
            CoreProxy.proxy.registerBlock(blockFuel);
            fluidFuel.setBlock(blockFuel);
        } else {
            blockFuel = fluidFuel.getBlock();
        }
        if (blockOil != null) {
            bucketOil = new ItemBucketBuildcraft(blockOil);
            bucketOil.func_77655_b("bucketOil").func_77642_a(Items.field_151133_ar);
            LanguageRegistry.addName((Object)bucketOil, (String)"Oil Bucket");
            CoreProxy.proxy.registerItem(bucketOil);
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)"oil", (int)1000), (ItemStack)new ItemStack(bucketOil), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        if (blockFuel != null) {
            bucketFuel = new ItemBucketBuildcraft(blockFuel);
            bucketFuel.func_77655_b("bucketFuel").func_77642_a(Items.field_151133_ar);
            LanguageRegistry.addName((Object)bucketFuel, (String)"Fuel Bucket");
            CoreProxy.proxy.registerItem(bucketFuel);
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)"fuel", (int)1000), (ItemStack)new ItemStack(bucketFuel), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        BucketHandler.INSTANCE.buckets.put(blockOil, bucketOil);
        BucketHandler.INSTANCE.buckets.put(blockFuel, bucketFuel);
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.INSTANCE);
        BuildcraftRecipes.refinery.addRecipe(new FluidStack(fluidOil, 1), new FluidStack(fluidFuel, 1), 12, 1);
        IronEngineFuel.addFuel("oil", 3.0f, (int)(5000.0 * fuelOilMultiplier));
        IronEngineFuel.addFuel("fuel", 6.0f, (int)(25000.0 * fuelFuelMultiplier));
        IronEngineCoolant.addCoolant(FluidRegistry.getFluid((String)"water"), 0.0023f);
        IronEngineCoolant.addCoolant(Blocks.field_150432_aD, 0, FluidRegistry.getFluidStack((String)"water", (int)2000));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-ENERGY", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandlerTransport()});
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftEnergy.loadRecipes();
        }
        EnergyProxy.proxy.registerBlockRenderers();
        EnergyProxy.proxy.registerTileEntities();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        if (BuildCraftCore.modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)OilPopulate.INSTANCE);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BiomeInitializer());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            buildcraftFluidOil.setIcons(blockOil.func_149733_h(1), blockOil.func_149733_h(2));
            buildcraftFluidFuel.setIcons(blockFuel.func_149733_h(1), blockFuel.func_149733_h(2));
        }
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 0), "www", " g ", "GpG", Character.valueOf('w'), "plankWood", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('G'), BuildCraftCore.woodenGearItem, Character.valueOf('p'), Blocks.field_150331_J);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 1), "www", " g ", "GpG", Character.valueOf('w'), "cobblestone", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('G'), BuildCraftCore.stoneGearItem, Character.valueOf('p'), Blocks.field_150331_J);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 2), "www", " g ", "GpG", Character.valueOf('w'), Items.field_151042_j, Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('p'), Blocks.field_150331_J);
    }

    private int findUnusedBiomeID(String biomeName) {
        int freeBiomeID = 0;
        for (int i = 1; i < 256; ++i) {
            if (BiomeGenBase.func_150565_n()[i] != null) continue;
            freeBiomeID = i;
            return freeBiomeID;
        }
        class BiomeIdLimitException
        extends RuntimeException {
            public BiomeIdLimitException(String biome) {
                super(String.format("You have a run out of free Biome Ids for %s", biome));
            }
        }
        throw new BiomeIdLimitException(biomeName);
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    static {
        oilWellScalar = 1.0;
        oilBiomeIDs = new HashSet<Integer>();
        excessiveOilBiomeIDs = new HashSet<Integer>();
        excludeOilBiomeIDs = new HashSet<Integer>();
        saturationStored = new TreeMap();
        triggerBlueEngineHeat = new TriggerEngineHeat(TileEngine.EnergyStage.BLUE);
        triggerGreenEngineHeat = new TriggerEngineHeat(TileEngine.EnergyStage.GREEN);
        triggerYellowEngineHeat = new TriggerEngineHeat(TileEngine.EnergyStage.YELLOW);
        triggerRedEngineHeat = new TriggerEngineHeat(TileEngine.EnergyStage.RED);
    }
}

