/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.builders.BuildersProxy;
import buildcraft.builders.TileMarker;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMarker
extends BlockContainer {
    public BlockMarker() {
        super(Material.field_151594_q);
        this.func_149715_a(0.5f);
        this.func_149647_a(CreativeTabBuildCraft.MACHINES.get());
    }

    private AxisAlignedBB getBoundingBox(int meta) {
        double w = 0.15;
        double h = 0.65;
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        switch (dir) {
            case DOWN: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.5 - w, 1.0 - h, 0.5 - w, 0.5 + w, 1.0, 0.5 + w);
            }
            case UP: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.5 - w, 0.0, 0.5 - w, 0.5 + w, h, 0.5 + w);
            }
            case SOUTH: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.5 - w, 0.5 - w, 0.0, 0.5 + w, 0.5 + w, h);
            }
            case NORTH: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.5 - w, 0.5 - w, 1.0 - h, 0.5 + w, 0.5 + w, 1.0);
            }
            case EAST: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.5 - w, 0.5 - w, h, 0.5 + w, 0.5 + w);
            }
        }
        return AxisAlignedBB.func_72332_a().func_72299_a(1.0 - h, 0.5 - w, 0.5 - w, 1.0, 0.5 + w, 0.5 + w);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        AxisAlignedBB bBox = this.getBoundingBox(meta);
        bBox.func_72317_d((double)x, (double)y, (double)z);
        return bBox;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        AxisAlignedBB bb = this.getBoundingBox(meta);
        this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
    }

    public int func_149645_b() {
        return BuildCraftCore.markerModel;
    }

    public boolean isACube() {
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileMarker();
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMarker) {
            ((TileMarker)tile).tryConnection();
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMarker) {
            ((TileMarker)tile).updateSignals();
        }
        this.dropTorchIfCantStay(world, x, y, z);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return BuildersProxy.canPlaceTorch(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        return side;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.dropTorchIfCantStay(world, x, y, z);
    }

    private void dropTorchIfCantStay(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (!this.func_149707_d(world, x, y, z, meta)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("buildcraft:blockMarker");
    }
}

