/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.filler.pattern;

import buildcraft.api.core.IBox;
import buildcraft.builders.filler.pattern.FillerPattern;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PatternCylinder
extends FillerPattern {
    public PatternCylinder() {
        super("cylinder");
    }

    @Override
    public boolean iteratePattern(TileEntity tile, IBox box, ItemStack stackToPlace) {
        int stoppingZ;
        int xMin = (int)box.pMin().x;
        int yMin = (int)box.pMin().y;
        int zMin = (int)box.pMin().z;
        int xMax = (int)box.pMax().x;
        int yMax = (int)box.pMax().y;
        int zMax = (int)box.pMax().z;
        int xFix = (xMax - xMin) % 2;
        int zFix = (zMax - zMin) % 2;
        int xCenter = (xMax + xMin) / 2 + (xMax + xMin < 0 && xFix == 1 ? -1 : 0);
        int zCenter = (zMax + zMin) / 2 + (zMax + zMin < 0 && zFix == 1 ? -1 : 0);
        int xRadius = (xMax - xMin) / 2;
        int zRadius = (zMax - zMin) / 2;
        if (xRadius == 0 || zRadius == 0) {
            return !PatternCylinder.fill(xMin, yMin, zMin, xMax, yMax, zMax, stackToPlace, tile.func_145831_w());
        }
        int dx = xRadius;
        int dz = 0;
        int xChange = zRadius * zRadius * (1 - 2 * xRadius);
        int zChange = xRadius * xRadius;
        int ellipseError = 0;
        int twoASquare = 2 * xRadius * xRadius;
        int twoBSquare = 2 * zRadius * zRadius;
        int stoppingX = twoBSquare * xRadius;
        for (stoppingZ = 0; stoppingX >= stoppingZ; stoppingZ += twoASquare) {
            if (!this.fillFourColumns(xCenter, zCenter, dx, dz, xFix, zFix, yMin, yMax, stackToPlace, tile.func_145831_w())) {
                return false;
            }
            ++dz;
            if (2 * (ellipseError += (zChange += twoASquare)) + xChange <= 0) continue;
            --dx;
            stoppingX -= twoBSquare;
            ellipseError += xChange;
            xChange += twoBSquare;
        }
        dx = 0;
        dz = zRadius;
        xChange = zRadius * zRadius;
        zChange = xRadius * xRadius * (1 - 2 * zRadius);
        ellipseError = 0;
        stoppingZ = twoASquare * zRadius;
        for (stoppingX = 0; stoppingX <= stoppingZ; stoppingX += twoBSquare) {
            if (!this.fillFourColumns(xCenter, zCenter, dx, dz, xFix, zFix, yMin, yMax, stackToPlace, tile.func_145831_w())) {
                return false;
            }
            ++dx;
            if (2 * (ellipseError += (xChange += twoBSquare)) + zChange <= 0) continue;
            --dz;
            stoppingZ -= twoASquare;
            ellipseError += zChange;
            zChange += twoASquare;
        }
        return true;
    }

    private boolean fillFourColumns(int xCenter, int zCenter, int dx, int dz, int xFix, int zFix, int yMin, int yMax, ItemStack stackToPlace, World world) {
        int x = xCenter + dx + xFix;
        int z = zCenter + dz + zFix;
        if (PatternCylinder.fill(x, yMin, z, x, yMax, z, stackToPlace, world)) {
            return false;
        }
        x = xCenter - dx;
        z = zCenter + dz + zFix;
        if (PatternCylinder.fill(x, yMin, z, x, yMax, z, stackToPlace, world)) {
            return false;
        }
        x = xCenter - dx;
        z = zCenter - dz;
        if (PatternCylinder.fill(x, yMin, z, x, yMax, z, stackToPlace, world)) {
            return false;
        }
        x = xCenter + dx + xFix;
        z = zCenter - dz;
        return !PatternCylinder.fill(x, yMin, z, x, yMax, z, stackToPlace, world);
    }
}

