/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.energy.worldgen.OilPopulate;
import buildcraft.transport.ItemFacade;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;

public class InterModComms {
    public static void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (m.key.equals("add-facade")) {
                InterModComms.processAddFacadeIMC(event, m);
                continue;
            }
            if (m.key.equals("blacklist-facade")) {
                InterModComms.processBlacklistFacadeIMC(event, m);
                continue;
            }
            if (m.key.equals("oil-lake-biome")) {
                InterModComms.processOilLakeBiomeIMC(event, m);
                continue;
            }
            if (!m.key.equals("oil-gen-exclude")) continue;
            InterModComms.processOilGenExcludeIMC(event, m);
        }
    }

    public static void processAddFacadeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Splitter splitter = Splitter.on((String)"@").trimResults();
                String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
                if (array.length != 2) {
                    Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    String blockName = array[0];
                    Integer metaId = Ints.tryParse((String)array[1]);
                    if (Strings.isNullOrEmpty((String)blockName) || metaId == null) {
                        Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                    } else {
                        Block block = (Block)Block.field_149771_c.func_82594_a(blockName);
                        if (block.func_149645_b() != 0 && block.func_149645_b() != 31) {
                            ItemFacade.addFacade(new ItemStack(block, 1, metaId.intValue()));
                        } else {
                            InterModComms.logRedundantAddFacadeMessage(m, block.toString());
                        }
                    }
                }
            } else if (m.isItemStackMessage()) {
                ItemStack modItemStack = m.getItemStackValue();
                Block block = Block.func_149634_a((Item)modItemStack.func_77973_b());
                if (block != null && block.func_149645_b() != 0 && block.func_149645_b() != 31) {
                    ItemFacade.addFacade(modItemStack);
                } else {
                    InterModComms.logRedundantAddFacadeMessage(m, block.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processBlacklistFacadeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage message) {
        try {
            if (message.isItemStackMessage()) {
                ItemStack modItemStack = message.getItemStackValue();
                Block block = Block.func_149634_a((Item)modItemStack.func_77973_b());
                if (block != null) {
                    String blockName = Block.field_149771_c.func_148750_c((Object)block);
                    ItemFacade.blacklistFacade(blockName);
                }
            } else {
                Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Invalid blacklist-facade message from mod %s. Send an ItemStackMessage instead.", message.getSender()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void logRedundantAddFacadeMessage(FMLInterModComms.IMCMessage m, String blockName) {
        Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("%s is trying to add %s a facade that Buildcraft will add later. Facade not added.", m.getSender(), blockName));
    }

    public static void processOilLakeBiomeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            String biomeID = m.getStringValue().trim();
            int id = Integer.valueOf(biomeID);
            if (id >= BiomeGenBase.func_150565_n().length) {
                throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.func_150565_n().length);
            }
            OilPopulate.INSTANCE.surfaceDepositBiomes.add(id);
        }
        catch (Exception ex) {
            Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("Received an invalid oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
        }
        Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an successfull oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
    }

    public static void processOilGenExcludeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            String biomeID = m.getStringValue().trim();
            int id = Integer.valueOf(biomeID);
            if (id >= BiomeGenBase.func_150565_n().length) {
                throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.func_150565_n().length);
            }
            OilPopulate.INSTANCE.excludedBiomes.add(id);
        }
        catch (Exception ex) {
            Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("Received an invalid oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
        }
        Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an successfull oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
    }
}

