/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.core.DefaultProps;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadArrays;
import buildcraft.core.network.PacketTileUpdate;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TilePacketWrapper;
import buildcraft.core.utils.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileBuildCraft
extends TileEntity
implements ISynchronizedTile {
    private static Map<Class, TilePacketWrapper> updateWrappers = new HashMap<Class, TilePacketWrapper>();
    private static Map<Class, TilePacketWrapper> descriptionWrappers = new HashMap<Class, TilePacketWrapper>();
    private final TilePacketWrapper descriptionPacket;
    private final TilePacketWrapper updatePacket;
    private boolean init = false;
    private String owner = "[BuildCraft]";

    public TileBuildCraft() {
        if (!updateWrappers.containsKey(this.getClass())) {
            updateWrappers.put(this.getClass(), new TilePacketWrapper(this.getClass()));
        }
        if (!descriptionWrappers.containsKey(this.getClass())) {
            descriptionWrappers.put(this.getClass(), new TilePacketWrapper(this.getClass()));
        }
        this.updatePacket = updateWrappers.get(this.getClass());
        this.descriptionPacket = descriptionWrappers.get(this.getClass());
    }

    public String getOwner() {
        return this.owner;
    }

    public void func_145845_h() {
        if (!this.init && !this.func_145837_r()) {
            this.initialize();
            this.init = true;
        }
        if (this instanceof IPowerReceptor) {
            IPowerReceptor receptor = (IPowerReceptor)((Object)this);
            receptor.getPowerReceiver(null).update();
        }
    }

    public void func_145843_s() {
        this.init = false;
        super.func_145843_s();
    }

    public void initialize() {
        Utils.handleBufferedDescription(this);
    }

    public void onBlockPlacedBy(EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entity).getDisplayName();
        }
    }

    public void destroy() {
    }

    public void sendNetworkUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            BuildCraftCore.instance.sendToPlayers(this.getUpdatePacket(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, DefaultProps.NETWORK_UPDATE_RANGE);
        }
    }

    public Packet func_145844_m() {
        return Utils.toPacket(this.getUpdatePacket(), 0);
    }

    @Override
    public PacketPayload getPacketPayload() {
        return this.updatePacket.toPayload(this);
    }

    @Override
    public BuildCraftPacket getUpdatePacket() {
        return new PacketTileUpdate(this);
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) throws IOException {
        if (packet.payload instanceof PacketPayloadArrays) {
            this.descriptionPacket.fromPayload(this, (PacketPayloadArrays)packet.payload);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        if (packet.payload instanceof PacketPayloadArrays) {
            this.updatePacket.fromPayload(this, (PacketPayloadArrays)packet.payload);
        }
    }

    @Override
    public void postPacketHandling(PacketUpdate packet) {
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("owner", this.owner);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("owner")) {
            this.owner = nbt.func_74779_i("owner");
        }
    }

    public World getWorld() {
        return this.field_145850_b;
    }
}

