/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.core.IBuilderInventory;
import buildcraft.core.blueprints.BptBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptSlot;
import java.util.LinkedList;
import net.minecraft.world.World;

public class BptBuilderTemplate
extends BptBuilderBase {
    LinkedList<BptSlot> clearList = new LinkedList();
    LinkedList<BptSlot> buildList = new LinkedList();

    public BptBuilderTemplate(BptBase bluePrint, World world, int x, int y, int z) {
        super(bluePrint, world, x, y, z);
        BptSlot slot;
        int zCoord;
        int yCoord;
        int xCoord;
        int k;
        int i;
        int j;
        for (j = bluePrint.sizeY - 1; j >= 0; --j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k = 0; k < bluePrint.sizeZ; ++k) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y - bluePrint.anchorY;
                    zCoord = k + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k];
                    if (slot != null && slot.block != null) continue;
                    slot = new BptSlot();
                    slot.meta = 0;
                    slot.block = null;
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.ClearIfInvalid;
                    this.clearList.add(slot);
                }
            }
        }
        for (j = 0; j < bluePrint.sizeY; ++j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k = 0; k < bluePrint.sizeZ; ++k) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y - bluePrint.anchorY;
                    zCoord = k + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k];
                    if (slot != null) {
                        slot = slot.clone();
                    } else {
                        slot = new BptSlot();
                        slot.meta = 0;
                        slot.block = null;
                    }
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.Build;
                    if (slot.block == null) continue;
                    this.buildList.add(slot);
                }
            }
        }
    }

    private void checkDone() {
        this.done = this.clearList.size() == 0 && this.buildList.size() == 0;
    }

    @Override
    public BptSlot getNextBlock(World world, IBuilderInventory inv) {
        if (this.clearList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.clearList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.buildList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.buildList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        this.checkDone();
        return null;
    }

    public BptSlot internalGetNextBlock(World world, IBuilderInventory inv, LinkedList<BptSlot> list) {
        BptSlot result = null;
        while (list.size() > 0) {
            BptSlot slot = list.getFirst();
        }
        return result;
    }
}

