/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.gui.slots.IPhantomSlot;
import buildcraft.core.gui.slots.SlotBase;
import buildcraft.core.gui.widgets.Widget;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.network.PacketGuiWidget;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class BuildCraftContainer
extends Container {
    private List<Widget> widgets = new ArrayList<Widget>();
    private int inventorySize;

    public BuildCraftContainer(int inventorySize) {
        this.inventorySize = inventorySize;
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void addSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    public void addWidget(Widget widget) {
        widget.addToContainer(this);
        this.widgets.add(widget);
    }

    public void sendWidgetDataToClient(Widget widget, ICrafting player, byte[] data) {
        PacketGuiWidget pkt = new PacketGuiWidget(this.field_75152_c, this.widgets.indexOf(widget), data);
        BuildCraftCore.instance.sendToPlayer((EntityPlayer)player, pkt);
    }

    public void handleWidgetClientData(int widgetId, ByteBuf data) {
        ByteBufInputStream input = new ByteBufInputStream(data);
        DataInputStream stream = new DataInputStream((InputStream)input);
        try {
            this.widgets.get(widgetId).handleClientPacketData(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        for (Widget widget : this.widgets) {
            widget.initWidget(player);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (Widget widget : this.widgets) {
            for (ICrafting player : this.field_75149_d) {
                widget.updateWidget(player);
            }
        }
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotNum < 0 ? null : (Slot)this.field_75151_b.get(slotNum);
        if (slot instanceof IPhantomSlot) {
            return this.slotClickPhantom(slot, mouseButton, modifier, player);
        }
        return super.func_75144_a(slotNum, mouseButton, modifier, player);
    }

    private ItemStack slotClickPhantom(Slot slot, int mouseButton, int modifier, EntityPlayer player) {
        ItemStack stack = null;
        if (mouseButton == 2) {
            if (((IPhantomSlot)slot).canAdjust()) {
                slot.func_75215_d(null);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.field_71071_by;
            slot.func_75218_e();
            ItemStack stackSlot = slot.func_75211_c();
            ItemStack stackHeld = playerInv.func_70445_o();
            if (stackSlot != null) {
                stack = stackSlot.func_77946_l();
            }
            if (stackSlot == null) {
                if (stackHeld != null && slot.func_75214_a(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            } else if (stackHeld == null) {
                this.adjustPhantomSlot(slot, mouseButton, modifier);
                slot.func_82870_a(player, playerInv.func_70445_o());
            } else if (slot.func_75214_a(stackHeld)) {
                if (StackHelper.instance().canStacksMerge(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, modifier);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(Slot slot, int mouseButton, int modifier) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        if (modifier == 1) {
            stackSize = mouseButton == 0 ? (stackSlot.field_77994_a + 1) / 2 : stackSlot.field_77994_a * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.field_77994_a - 1 : stackSlot.field_77994_a + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.field_77994_a = stackSize;
        if (stackSlot.field_77994_a <= 0) {
            slot.func_75215_d((ItemStack)null);
        }
    }

    protected void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton, int modifier) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.field_77994_a : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.field_77994_a = stackSize;
        slot.func_75215_d(phantomStack);
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || !StackHelper.instance().canStacksMerge(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                if (resultingStackSize <= max) {
                    stackToShift.field_77994_a = 0;
                    stackInSlot.field_77994_a = resultingStackSize;
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.field_77994_a >= max) continue;
                stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
                stackInSlot.field_77994_a = max;
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.field_77994_a > 0) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
                stackToShift.field_77994_a -= stackInSlot.field_77994_a;
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (slot instanceof SlotBase && !((SlotBase)slot).canShift() || slot instanceof IPhantomSlot || !slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int numSlots = this.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.field_77994_a <= 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return originalStack;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }
}

