/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.IStackFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TransactorSimple
extends Transactor {
    protected IInventory inventory;

    public TransactorSimple(IInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public int inject(ItemStack stack, ForgeDirection orientation, boolean doAdd) {
        ArrayList<InventoryIterator.IInvSlot> filledSlots = new ArrayList<InventoryIterator.IInvSlot>(this.inventory.func_70302_i_());
        ArrayList<InventoryIterator.IInvSlot> emptySlots = new ArrayList<InventoryIterator.IInvSlot>(this.inventory.func_70302_i_());
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot() == null) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(stack, filledSlots, injected, doAdd);
        injected = this.tryPut(stack, emptySlots, injected, doAdd);
        this.inventory.func_70296_d();
        return injected;
    }

    private int tryPut(ItemStack stack, List<InventoryIterator.IInvSlot> slots, int injected, boolean doAdd) {
        if (injected >= stack.field_77994_a) {
            return injected;
        }
        for (InventoryIterator.IInvSlot slot : slots) {
            int used;
            ItemStack stackInSlot = slot.getStackInSlot();
            if (stackInSlot != null && !StackHelper.instance().canStacksMerge(stackInSlot, stack) || (used = this.addToSlot(slot, stack, injected, doAdd)) <= 0 || (injected += used) < stack.field_77994_a) continue;
            return injected;
        }
        return injected;
    }

    protected int addToSlot(InventoryIterator.IInvSlot slot, ItemStack stack, int injected, boolean doAdd) {
        int available = stack.field_77994_a - injected;
        int max = Math.min(stack.func_77976_d(), this.inventory.func_70297_j_());
        ItemStack stackInSlot = slot.getStackInSlot();
        if (stackInSlot == null) {
            int wanted = Math.min(available, max);
            if (doAdd) {
                stackInSlot = stack.func_77946_l();
                stackInSlot.field_77994_a = wanted;
                slot.setStackInSlot(stackInSlot);
            }
            return wanted;
        }
        if (!StackHelper.instance().canStacksMerge(stack, stackInSlot)) {
            return 0;
        }
        int wanted = max - stackInSlot.field_77994_a;
        if (wanted <= 0) {
            return 0;
        }
        if (wanted > available) {
            wanted = available;
        }
        if (doAdd) {
            stackInSlot.field_77994_a += wanted;
            slot.setStackInSlot(stackInSlot);
        }
        return wanted;
    }

    @Override
    public ItemStack remove(IStackFilter filter, ForgeDirection orientation, boolean doRemove) {
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            if (doRemove) {
                return slot.decreaseStackInSlot();
            }
            ItemStack output = stack.func_77946_l();
            output.field_77994_a = 1;
            return output;
        }
        return null;
    }
}

