/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.core.robots.EntityRobot;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AIBase {
    protected float destX;
    protected float destY;
    protected float destZ;
    protected double dirX;
    protected double dirY;
    protected double dirZ;

    public abstract void update(EntityRobot var1);

    public void setDestination(EntityRobot robot, float x, float y, float z) {
        this.destX = x;
        this.destY = y;
        this.destZ = z;
        this.dirX = (double)this.destX - robot.posX;
        this.dirY = (double)this.destY - robot.posY;
        this.dirZ = (double)this.destZ - robot.posZ;
        double magnitude = Math.sqrt(this.dirX * this.dirX + this.dirY * this.dirY + this.dirZ * this.dirZ);
        this.dirX /= magnitude;
        this.dirY /= magnitude;
        this.dirZ /= magnitude;
        robot.motionX = this.dirX / 10.0;
        robot.motionY = this.dirY / 10.0;
        robot.motionZ = this.dirZ / 10.0;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("destX", this.destX);
        nbt.func_74776_a("destY", this.destY);
        nbt.func_74776_a("destZ", this.destZ);
        nbt.func_74780_a("dirX", this.dirX);
        nbt.func_74780_a("dirY", this.dirY);
        nbt.func_74780_a("dirZ", this.dirZ);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.destX = nbt.func_74760_g("destX");
        this.destY = nbt.func_74760_g("destY");
        this.destZ = nbt.func_74760_g("destZ");
        this.dirX = nbt.func_74769_h("dirX");
        this.dirY = nbt.func_74769_h("dirY");
        this.dirZ = nbt.func_74769_h("dirZ");
    }
}

