/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.core.robots.AIBase;
import buildcraft.core.robots.AIDocked;
import buildcraft.core.robots.EntityRobot;
import net.minecraft.nbt.NBTTagCompound;

public class AIReturnToDock
extends AIBase {
    double prevDistance = Double.MAX_VALUE;
    int phase = 0;

    @Override
    public void update(EntityRobot robot) {
        if (robot.worldObj.field_72995_K) {
            return;
        }
        if (this.phase == 0) {
            float x = (float)robot.dockingStation.x + 0.5f + (float)robot.dockingStation.side.offsetX * 1.5f;
            float y = (float)robot.dockingStation.y + 0.5f + (float)robot.dockingStation.side.offsetY * 1.5f;
            float z = (float)robot.dockingStation.z + 0.5f + (float)robot.dockingStation.side.offsetZ * 1.5f;
            this.setDestination(robot, x, y, z);
            this.phase = 1;
        } else if (this.phase == 1) {
            double distance = robot.getDistance((double)this.destX, (double)this.destY, (double)this.destZ);
            if (distance >= this.prevDistance) {
                this.prevDistance = Double.MAX_VALUE;
                float x = (float)robot.dockingStation.x + 0.5f + (float)robot.dockingStation.side.offsetX * 0.5f;
                float y = (float)robot.dockingStation.y + 0.5f + (float)robot.dockingStation.side.offsetY * 0.5f;
                float z = (float)robot.dockingStation.z + 0.5f + (float)robot.dockingStation.side.offsetZ * 0.5f;
                this.setDestination(robot, x, y, z);
                this.phase = 2;
            } else {
                this.prevDistance = distance;
            }
        } else if (this.phase == 2) {
            double distance = robot.getDistance((double)this.destX, (double)this.destY, (double)this.destZ);
            if (distance >= this.prevDistance) {
                float x = (float)robot.dockingStation.x + 0.5f + (float)robot.dockingStation.side.offsetX * 0.5f;
                float y = (float)robot.dockingStation.y + 0.5f + (float)robot.dockingStation.side.offsetY * 0.5f;
                float z = (float)robot.dockingStation.z + 0.5f + (float)robot.dockingStation.side.offsetZ * 0.5f;
                robot.motionX = 0.0;
                robot.motionY = 0.0;
                robot.motionZ = 0.0;
                robot.setPosition((double)x, (double)y, (double)z);
                robot.currentAI = new AIDocked();
            } else {
                this.prevDistance = distance;
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("phase", this.phase);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.phase = nbt.func_74762_e("phase");
    }
}

