/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockUtil {
    public static List<ItemStack> getItemStackFromBlock(World world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        if (block == null) {
            return null;
        }
        if (block.isAir((IBlockAccess)world, i, j, k)) {
            return null;
        }
        int meta = world.func_72805_g(i, j, k);
        ArrayList dropsList = block.getDrops(world, i, j, k, meta, 0);
        float dropChance = ForgeEventFactory.fireBlockHarvesting((ArrayList)dropsList, (World)world, (Block)block, (int)i, (int)j, (int)k, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world));
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        for (ItemStack s : dropsList) {
            if (!(world.field_73012_v.nextFloat() <= dropChance)) continue;
            returnList.add(s);
        }
        return returnList;
    }

    public static void breakBlock(World world, int x, int y, int z) {
        BlockUtil.breakBlock(world, x, y, z, BuildCraftCore.itemLifespan);
    }

    public static void breakBlock(World world, int x, int y, int z, int forcedLifespan) {
        if (!world.func_147437_c(x, y, z) && BuildCraftCore.dropBrokenBlocks && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            List<ItemStack> items = BlockUtil.getItemStackFromBlock(world, x, y, z);
            for (ItemStack item : items) {
                float var = 0.7f;
                double dx = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                double dy = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                double dz = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, item);
                entityitem.lifespan = forcedLifespan;
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_147468_f(x, y, z);
    }

    public static boolean isAnObstructingBlock(Block block, World world, int x, int y, int z) {
        return block != null && !block.isAir((IBlockAccess)world, x, y, z);
    }

    public static boolean canChangeBlock(World world, int x, int y, int z) {
        return BlockUtil.canChangeBlock(world.func_147439_a(x, y, z), world, x, y, z);
    }

    public static boolean canChangeBlock(Block block, World world, int x, int y, int z) {
        if (block == null || block.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (block.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        if (block == BuildCraftEnergy.blockOil) {
            return false;
        }
        return block != Blocks.field_150353_l && block != Blocks.field_150356_k;
    }

    public static boolean isSoftBlock(World world, int x, int y, int z) {
        return BlockUtil.isSoftBlock(world.func_147439_a(x, y, z), world, x, y, z);
    }

    public static boolean isSoftBlock(Block block, World world, int x, int y, int z) {
        return block == null || BuildCraftAPI.softBlocks.contains(block) || block.isAir((IBlockAccess)world, x, y, z);
    }

    public static boolean isToughBlock(World world, int x, int y, int z) {
        return !world.func_147439_a(x, y, z).func_149688_o().func_76229_l();
    }

    public static boolean isFullFluidBlock(World world, int x, int y, int z) {
        return BlockUtil.isFullFluidBlock(world.func_147439_a(x, y, z), world, x, y, z);
    }

    public static boolean isFullFluidBlock(Block block, World world, int x, int y, int z) {
        if (block instanceof BlockFluidBase || block instanceof IFluidBlock) {
            return world.func_72805_g(x, y, z) == 0;
        }
        return false;
    }

    public static Fluid getFluid(Block block) {
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static FluidStack drainBlock(World world, int x, int y, int z, boolean doDrain) {
        return BlockUtil.drainBlock(world.func_147439_a(x, y, z), world, x, y, z, doDrain);
    }

    public static FluidStack drainBlock(Block block, World world, int x, int y, int z, boolean doDrain) {
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null) {
            int meta = world.func_72805_g(x, y, z);
            if (meta != 0) {
                return null;
            }
            if (doDrain) {
                world.func_147468_f(x, y, z);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public static void explodeBlock(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        Explosion explosion = new Explosion(world, null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f);
        explosion.field_77281_g.add(new ChunkPosition(x, y, z));
        explosion.func_77279_a(true);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP) || !(player.func_70092_e((double)x, (double)y, (double)z) < 4096.0)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S27PacketExplosion((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, explosion.field_77281_g, null));
        }
    }
}

