/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.render.RenderUtils;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngineIron;
import buildcraft.energy.TileEngineWithInventory;
import buildcraft.energy.gui.ContainerEngine;
import buildcraft.energy.gui.GuiEngine;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GuiCombustionEngine
extends GuiEngine {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/combustion_engine_gui.png");
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;

    public GuiCombustionEngine(InventoryPlayer inventoryplayer, TileEngineWithInventory tileEngine) {
        super(new ContainerEngine(inventoryplayer, tileEngine), tileEngine, TEXTURE);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = StringUtils.localize("tile.engineIron.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        TileEngineIron engine = (TileEngineIron)this.tile;
        this.drawFluid(engine.getFuel(), engine.getScaledBurnTime(58), j + 104, k + 19, 16, 58);
        this.drawFluid(engine.getCoolant(), engine.getScaledCoolant(58), j + 122, k + 19, 16, 58);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(j + 104, k + 19, 176, 0, 16, 60);
        this.func_73729_b(j + 122, k + 19, 176, 0, 16, 60);
    }

    private void drawFluid(FluidStack fluid, int level, int x, int y, int width, int height) {
        int i;
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        IIcon icon = fluid.getFluid().getIcon(fluid);
        this.field_146297_k.field_71446_o.func_110577_a(BLOCK_TEXTURE);
        RenderUtils.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int fullX = width / 16;
        int fullY = height / 16;
        int lastX = width - fullX * 16;
        int lastY = height - fullY * 16;
        int fullLvl = (height - level) / 16;
        int lastLvl = height - level - fullLvl * 16;
        for (i = 0; i < fullX; ++i) {
            for (int j = 0; j < fullY; ++j) {
                if (j < fullLvl) continue;
                this.drawCutIcon(icon, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? lastLvl : 0);
            }
        }
        for (i = 0; i < fullX; ++i) {
            this.drawCutIcon(icon, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? lastLvl : 0);
        }
        for (i = 0; i < fullY; ++i) {
            if (i < fullLvl) continue;
            this.drawCutIcon(icon, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? lastLvl : 0);
        }
        this.drawCutIcon(icon, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? lastLvl : 0);
    }

    private void drawCutIcon(IIcon icon, int x, int y, int width, int height, int cut) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)cut));
        tess.func_78374_a((double)x, (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)cut));
        tess.func_78381_a();
    }
}

