/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.utils.Utils;
import buildcraft.factory.TileMiningWell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMiningWell
extends BlockBuildCraft {
    IIcon textureFront;
    IIcon textureSides;
    IIcon textureBack;
    IIcon textureTop;

    public BlockMiningWell() {
        super(Material.field_151578_c);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public IIcon func_149691_a(int i, int j) {
        if (j == 0 && i == 3) {
            return this.textureFront;
        }
        if (i == 1) {
            return this.textureTop;
        }
        if (i == 0) {
            return this.textureBack;
        }
        if (i == j) {
            return this.textureFront;
        }
        if (j >= 0 && j < 6 && ForgeDirection.values()[j].getOpposite().ordinal() == i) {
            return this.textureBack;
        }
        return this.textureSides;
    }

    @Override
    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.func_72921_c(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        this.removePipes(world, x, y, z);
    }

    public void removePipes(World world, int x, int y, int z) {
        Block pipe;
        for (int depth = y - 1; depth > 0 && (pipe = world.func_147439_a(x, depth, z)) == BuildCraftFactory.plainPipeBlock; --depth) {
            world.func_147468_f(x, depth, z);
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileMiningWell();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.textureFront = par1IconRegister.func_94245_a("buildcraft:miningwell_front");
        this.textureSides = par1IconRegister.func_94245_a("buildcraft:miningwell_side");
        this.textureBack = par1IconRegister.func_94245_a("buildcraft:miningwell_back");
        this.textureTop = par1IconRegister.func_94245_a("buildcraft:miningwell_top");
    }
}

