/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.fluids.SingleUseTank;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.recipes.RefineryRecipeManager;
import buildcraft.core.utils.StringUtils;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.gui.ContainerRefinery;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiRefinery
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/refinery_filter.png");
    ContainerRefinery container;

    public GuiRefinery(InventoryPlayer inventory, TileRefinery refinery) {
        super(new ContainerRefinery(inventory, refinery), refinery, TEXTURE);
        this.field_146999_f = 175;
        this.field_147000_g = 207;
        this.container = (ContainerRefinery)this.field_147002_h;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[3];
        this.slots[0] = new GuiAdvancedInterface.FluidSlot(38, 54);
        this.slots[1] = new GuiAdvancedInterface.FluidSlot(126, 54);
        this.slots[2] = new GuiAdvancedInterface.FluidSlot(82, 54);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = StringUtils.localize("tile.refineryBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_146289_q.func_78276_b("->", 63, 59, 0x404040);
        this.field_146289_q.func_78276_b("<-", 106, 59, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.drawForegroundSelection(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(j, k, 0, 0, this.field_146999_f, this.field_147000_g);
        this.updateSlots();
        this.drawBackgroundSlots();
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        if (position >= 0 && position < 2) {
            if (k == 0) {
                if (!GuiRefinery.func_146272_n()) {
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.field_146297_k.field_71439_g.field_71071_by.func_70445_o());
                    if (liquid == null) {
                        return;
                    }
                    this.container.setFilter(position, liquid.getFluid());
                    ((SingleUseTank)((Object)this.container.refinery.tankManager.get((int)position))).colorRenderCache = liquid.getFluid().getColor(liquid);
                } else {
                    this.container.setFilter(position, null);
                    ((SingleUseTank)((Object)this.container.refinery.tankManager.get((int)position))).colorRenderCache = 0xFFFFFF;
                }
            } else {
                TileRefinery ref = (TileRefinery)this.tile;
                if (position == 0) {
                    this.container.setFilter(position, ref.tank1.getFluidType());
                } else if (position == 1) {
                    this.container.setFilter(position, ref.tank2.getFluidType());
                }
            }
        }
    }

    private void updateSlots() {
        RefineryRecipeManager.RefineryRecipe recipe;
        Fluid filter0 = this.container.getFilter(0);
        Fluid filter1 = this.container.getFilter(1);
        ((GuiAdvancedInterface.FluidSlot)this.slots[0]).fluid = filter0;
        ((GuiAdvancedInterface.FluidSlot)this.slots[0]).colorRenderCache = this.container.refinery.tank1.colorRenderCache;
        ((GuiAdvancedInterface.FluidSlot)this.slots[1]).fluid = filter1;
        ((GuiAdvancedInterface.FluidSlot)this.slots[1]).colorRenderCache = this.container.refinery.tank2.colorRenderCache;
        FluidStack liquid0 = null;
        FluidStack liquid1 = null;
        if (filter0 != null) {
            liquid0 = new FluidStack(filter0, 1000);
        }
        if (filter1 != null) {
            liquid1 = new FluidStack(filter1, 1000);
        }
        if ((recipe = RefineryRecipeManager.INSTANCE.findRefineryRecipe(liquid0, liquid1)) != null) {
            ((GuiAdvancedInterface.FluidSlot)this.slots[2]).fluid = recipe.result.getFluid();
            ((GuiAdvancedInterface.FluidSlot)this.slots[2]).colorRenderCache = recipe.result.getFluid().getColor(recipe.result);
        } else {
            ((GuiAdvancedInterface.FluidSlot)this.slots[2]).fluid = null;
        }
    }
}

