/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.PacketPayloadStream;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.factory.TileRefinery;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;

@ChannelHandler.Sharable
public class PacketHandlerFactory
extends SimpleChannelInboundHandler<BuildCraftPacket> {
    protected void channelRead0(ChannelHandlerContext ctx, BuildCraftPacket packet) {
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
            int packetID = packet.getID();
            switch (packetID) {
                case 50: {
                    this.onRefinerySelect(player, (PacketUpdate)packet);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private TileRefinery getRefinery(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileRefinery)) {
            return null;
        }
        return (TileRefinery)tile;
    }

    private void onRefinerySelect(EntityPlayer playerEntity, PacketUpdate packet) throws IOException {
        TileRefinery tile = this.getRefinery(playerEntity.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (tile == null || packet.payload == null) {
            return;
        }
        ByteBuf stream = ((PacketPayloadStream)packet.payload).stream;
        tile.setFilter(stream.readByte(), FluidRegistry.getFluid((int)stream.readShort()));
    }
}

