/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.api.recipes.IIntegrationRecipeManager;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryMapper;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.TileLaserTableBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileIntegrationTable
extends TileLaserTableBase
implements ISidedInventory {
    public static final int SLOT_INPUT_A = 0;
    public static final int SLOT_INPUT_B = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int CYCLE_LENGTH = 32;
    private static final int[] SLOTS = Utils.createSlotArray(0, 3);
    private int tick = 0;
    private SimpleInventory invRecipeOutput = new SimpleInventory(1, "integrationOutput", 64);
    private InventoryMapper invOutput = new InventoryMapper(this.inv, 2, 1, false);
    private IIntegrationRecipeManager.IIntegrationRecipe currentRecipe;
    private boolean canCraft = false;

    public IInventory getRecipeOutput() {
        return this.invRecipeOutput;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tick;
        if (this.tick % 32 != 0) {
            return;
        }
        this.canCraft = false;
        this.currentRecipe = this.findMatchingRecipe();
        if (this.currentRecipe == null) {
            this.setEnergy(0.0);
            return;
        }
        ItemStack inputA = this.inv.func_70301_a(0);
        ItemStack inputB = this.inv.func_70301_a(1);
        ItemStack output = this.currentRecipe.getOutputForInputs(inputA, inputB);
        this.invRecipeOutput.func_70299_a(0, output);
        if (!this.isRoomForOutput(output)) {
            this.setEnergy(0.0);
            return;
        }
        this.canCraft = true;
        if (this.getEnergy() >= this.currentRecipe.getEnergyCost()) {
            this.setEnergy(0.0);
            this.inv.func_70298_a(0, 1);
            this.inv.func_70298_a(1, 1);
            ITransactor trans = Transactor.getTransactorFor(this.invOutput);
            trans.add(output, ForgeDirection.UP, true);
        }
    }

    private IIntegrationRecipeManager.IIntegrationRecipe findMatchingRecipe() {
        ItemStack inputA = this.inv.func_70301_a(0);
        ItemStack inputB = this.inv.func_70301_a(1);
        for (IIntegrationRecipeManager.IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipes.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputA(inputA) || !iIntegrationRecipe.isValidInputB(inputB)) continue;
            return iIntegrationRecipe;
        }
        return null;
    }

    private boolean isRoomForOutput(ItemStack output) {
        ItemStack existingOutput = this.inv.func_70301_a(2);
        if (existingOutput == null) {
            return true;
        }
        return StackHelper.instance().canStacksMerge(output, existingOutput) && output.field_77994_a + existingOutput.field_77994_a <= output.func_77976_d();
    }

    @Override
    public double getRequiredEnergy() {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getEnergyCost();
        }
        return 0.0;
    }

    @Override
    public boolean canCraft() {
        return this.canCraft;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return this.isValidInputA(stack);
            }
            case 1: {
                return this.isValidInputB(stack);
            }
        }
        return false;
    }

    private boolean isValidInputA(ItemStack stack) {
        ItemStack inputB = this.inv.func_70301_a(1);
        for (IIntegrationRecipeManager.IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipes.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputA(stack) || inputB != null && !iIntegrationRecipe.isValidInputB(inputB)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidInputB(ItemStack stack) {
        ItemStack inputA = this.inv.func_70301_a(0);
        for (IIntegrationRecipeManager.IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipes.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputB(stack) || inputA != null && !iIntegrationRecipe.isValidInputA(inputA)) continue;
            return true;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    public int func_70302_i_() {
        return 3;
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.integrationTableBlock.name");
    }

    public boolean func_145818_k_() {
        return false;
    }
}

