/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.recipes;

import buildcraft.api.recipes.IIntegrationRecipeManager;
import buildcraft.core.inventory.StackHelper;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import net.minecraft.item.ItemStack;

public class GateLogicSwapRecipe
implements IIntegrationRecipeManager.IIntegrationRecipe {
    private final GateDefinition.GateMaterial material;
    private final GateDefinition.GateLogic logicIn;
    private final GateDefinition.GateLogic logicOut;
    private final ItemStack chipset;
    private final ItemStack[] exampleA;
    private final ItemStack[] exampleB;

    public GateLogicSwapRecipe(GateDefinition.GateMaterial material, GateDefinition.GateLogic logicIn, GateDefinition.GateLogic logicOut) {
        this.material = material;
        this.logicIn = logicIn;
        this.logicOut = logicOut;
        this.chipset = ItemRedstoneChipset.Chipset.RED.getStack();
        this.exampleA = new ItemStack[]{ItemGate.makeGateItem(material, logicIn)};
        this.exampleB = new ItemStack[]{this.chipset};
    }

    @Override
    public double getEnergyCost() {
        return 2000.0;
    }

    @Override
    public boolean isValidInputA(ItemStack inputA) {
        if (inputA == null) {
            return false;
        }
        if (!(inputA.func_77973_b() instanceof ItemGate)) {
            return false;
        }
        if (ItemGate.getMaterial(inputA) != this.material) {
            return false;
        }
        return ItemGate.getLogic(inputA) == this.logicIn;
    }

    @Override
    public boolean isValidInputB(ItemStack inputB) {
        return StackHelper.instance().isMatchingItem(inputB, this.chipset);
    }

    @Override
    public ItemStack getOutputForInputs(ItemStack inputA, ItemStack inputB) {
        if (!this.isValidInputA(inputA)) {
            return null;
        }
        if (!this.isValidInputB(inputB)) {
            return null;
        }
        ItemStack output = inputA.func_77946_l();
        output.field_77994_a = 1;
        ItemGate.setLogic(output, this.logicOut);
        return output;
    }

    @Override
    public ItemStack[] getExampleInputsA() {
        return this.exampleA;
    }

    @Override
    public ItemStack[] getExampleInputsB() {
        return this.exampleB;
    }
}

