/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Position;
import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.core.BlockSpring;
import buildcraft.core.BuildCraftConfiguration;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.TileGenericPipe;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemFacade
extends ItemBuildCraft {
    public static final LinkedList<ItemStack> allFacades = new LinkedList();
    public static final LinkedList<String> blacklistedFacades = new LinkedList();
    private static final Block NULL_BLOCK = null;
    private static final ItemStack NO_MATCH = new ItemStack(NULL_BLOCK, 0, 0);

    public ItemFacade() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(CreativeTabBuildCraft.FACADES.get());
    }

    public String func_77653_i(ItemStack itemstack) {
        String name = super.func_77653_i(itemstack);
        Block decodedBlock = ItemFacade.getBlock(itemstack);
        int decodedMeta = ItemFacade.getMetaData(itemstack);
        if (decodedBlock != null && decodedBlock.func_149645_b() == 31) {
            decodedMeta &= 3;
        }
        ItemStack newStack = new ItemStack(decodedBlock, 1, decodedMeta);
        if (Item.func_150898_a((Block)decodedBlock) != null) {
            name = name + ": " + CoreProxy.proxy.getItemDisplayName(newStack);
        } else {
            String localizedName;
            try {
                localizedName = decodedBlock.func_149732_F();
            }
            catch (NullPointerException npe) {
                localizedName = "Null";
            }
            name = name + " < BROKEN (" + localizedName + ":" + decodedMeta + " )>";
        }
        return name;
    }

    public String func_77667_c(ItemStack itemstack) {
        return "item.Facade";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (ItemStack stack : allFacades) {
            itemList.add(stack.func_77946_l());
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (worldObj.field_72995_K) {
            return false;
        }
        Position pos = new Position(x, y, z, ForgeDirection.getOrientation((int)side));
        pos.moveForwards(1.0);
        TileEntity tile = worldObj.func_147438_o((int)pos.x, (int)pos.y, (int)pos.z);
        if (!(tile instanceof TileGenericPipe)) {
            return false;
        }
        TileGenericPipe pipeTile = (TileGenericPipe)tile;
        if (pipeTile.addFacade(ForgeDirection.getOrientation((int)side).getOpposite(), ItemFacade.getBlock(stack), ItemFacade.getMetaData(stack))) {
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    public static void initialize() {
        for (Object o : Block.field_149771_c) {
            Item item;
            Block b = (Block)o;
            if (!ItemFacade.isBlockValidForFacade(b) || (item = Item.func_150898_a((Block)b)) == null || ItemFacade.isBlockBlacklisted(b)) continue;
            ItemFacade.registerValidFacades(b, item);
        }
    }

    private static void registerValidFacades(Block block, Item item) {
        HashSet names = Sets.newHashSet();
        for (int i = 0; i <= 15; ++i) {
            try {
                ItemStack stack = new ItemStack(item, 1, i);
                if (Strings.isNullOrEmpty((String)stack.func_77977_a()) || !names.add(stack.func_77977_a())) continue;
                ItemFacade.addFacade(stack);
                if (block.func_149645_b() != 31) continue;
                break;
            }
            catch (IndexOutOfBoundsException _) {
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static boolean isBlockBlacklisted(Block block) {
        String blockName = Block.field_149771_c.func_148750_c((Object)block);
        if (blockName == null) {
            return true;
        }
        for (String blacklistedBlock : BuildCraftTransport.facadeBlacklist) {
            if (!blockName.equals(BuildCraftConfiguration.stripSurroundingQuotes(blacklistedBlock))) continue;
            return true;
        }
        for (String blacklistedBlock : blacklistedFacades) {
            if (!blockName.equals(blacklistedBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlockValidForFacade(Block block) {
        if (block.func_149645_b() != 0 && block.func_149645_b() != 31) {
            return false;
        }
        if (block.func_149753_y() != 1.0 || block.func_149669_A() != 1.0 || block.func_149693_C() != 1.0) {
            return false;
        }
        return !(block instanceof BlockSpring) && !(block instanceof BlockGenericPipe);
    }

    public static int getMetaData(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("meta")) {
            return stack.func_77978_p().func_74762_e("meta");
        }
        return stack.func_77960_j() & 0xF;
    }

    public static Block getBlock(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        Block facadeBlock = null;
        NBTTagCompound stackTagCompound = stack.func_77978_p();
        if (stackTagCompound.func_74764_b("id")) {
            facadeBlock = (Block)Block.field_149771_c.func_148754_a(stackTagCompound.func_74762_e("id"));
            stackTagCompound.func_82580_o("id");
            stackTagCompound.func_74778_a("name", Block.field_149771_c.func_148750_c((Object)facadeBlock));
        } else if (stackTagCompound.func_74764_b("name")) {
            facadeBlock = (Block)Block.field_149771_c.func_82594_a(stackTagCompound.func_74779_i("name"));
        }
        return facadeBlock;
    }

    @Override
    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public static void addFacade(ItemStack itemStack) {
        ItemStack facade;
        if (itemStack.field_77994_a == 0) {
            itemStack.field_77994_a = 1;
        }
        if (!allFacades.contains(facade = ItemFacade.getStack(Block.func_149634_a((Item)itemStack.func_77973_b()), itemStack.func_77960_j()))) {
            allFacades.add(facade);
            ItemStack facade6 = facade.func_77946_l();
            facade6.field_77994_a = 6;
            BuildcraftRecipes.assemblyTable.addRecipe(8000.0, facade6, new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack);
        }
    }

    public static void blacklistFacade(String blockName) {
        if (!blacklistedFacades.contains(blockName)) {
            blacklistedFacades.add(blockName);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public static ItemStack getStack(Block block, int metadata) {
        ItemStack stack = new ItemStack((Item)BuildCraftTransport.facadeItem, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("meta", metadata);
        nbt.func_74778_a("name", Block.field_149771_c.func_148750_c((Object)block));
        stack.func_77982_d(nbt);
        return stack;
    }

    public class FacadeRecipe
    implements IRecipe {
        public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            return facade != null && facade[0] != null;
        }

        public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            if (facade == null) {
                return null;
            }
            Block block = (Block)facade[0];
            ItemStack originalFacade = (ItemStack)facade[1];
            if (block == null) {
                return null;
            }
            return this.getNextFacadeItemStack(block, originalFacade);
        }

        private Object[] getFacadeBlockFromCraftingGrid(InventoryCrafting inventorycrafting) {
            ItemStack slotmatch = null;
            int countOfItems = 0;
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                ItemStack slot = inventorycrafting.func_70301_a(i);
                if (slot != null && slot.func_77973_b() == ItemFacade.this && slotmatch == null) {
                    slotmatch = slot;
                    ++countOfItems;
                } else if (slot != null) {
                    slotmatch = NO_MATCH;
                }
                if (countOfItems <= true) continue;
                return null;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                return new Object[]{ItemFacade.getBlock(slotmatch), slotmatch};
            }
            return null;
        }

        private ItemStack getNextFacadeItemStack(Block block, ItemStack originalFacade) {
            int blockMeta = ItemFacade.getMetaData(originalFacade);
            int stackMeta = 0;
            switch (block.func_149645_b()) {
                case 1: {
                    if (blockMeta >= 15) {
                        stackMeta = 0;
                        break;
                    }
                    stackMeta = blockMeta + 1;
                    break;
                }
                case 31: {
                    if ((blockMeta & 0xC) == 0) {
                        stackMeta = blockMeta & 3 | 4;
                        break;
                    }
                    if ((blockMeta & 8) == 0) {
                        stackMeta = blockMeta & 3 | 8;
                        break;
                    }
                    if ((blockMeta & 4) != 0) break;
                    stackMeta = blockMeta & 3;
                    break;
                }
                default: {
                    stackMeta = blockMeta;
                }
            }
            return ItemFacade.getStack(block, stackMeta);
        }

        public int func_77570_a() {
            return 1;
        }

        public ItemStack func_77571_b() {
            return null;
        }
    }
}

