/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class FacadeMatrix {
    private final Block[] _blocks = new Block[ForgeDirection.VALID_DIRECTIONS.length];
    private final int[] _blockMetas = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private boolean dirty = false;

    public void setFacade(ForgeDirection direction, Block block, int blockMeta) {
        if (this._blocks[direction.ordinal()] != block || this._blockMetas[direction.ordinal()] != blockMeta) {
            this._blocks[direction.ordinal()] = block;
            this._blockMetas[direction.ordinal()] = blockMeta;
            this.dirty = true;
        }
    }

    public Block getFacadeBlock(ForgeDirection direction) {
        return this._blocks[direction.ordinal()];
    }

    public int getFacadeMetaId(ForgeDirection direction) {
        return this._blockMetas[direction.ordinal()];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (this._blocks[i] == null) {
                data.writeShort(0);
            } else {
                data.writeShort(Block.field_149771_c.func_148757_b((Object)this._blocks[i]));
            }
            data.writeByte(this._blockMetas[i]);
        }
    }

    public void readData(ByteBuf data) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            byte meta;
            short id = data.readShort();
            Block block = id == 0 ? null : (Block)Block.field_149771_c.func_148754_a((int)id);
            if (this._blocks[i] != block) {
                this._blocks[i] = block;
                this.dirty = true;
            }
            if (this._blockMetas[i] == (meta = data.readByte())) continue;
            this._blockMetas[i] = meta;
            this.dirty = true;
        }
    }
}

