/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.api.transport.PipeWire;
import buildcraft.transport.utils.BitSetCodec;
import buildcraft.transport.utils.ConnectionMatrix;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraftforge.common.util.ForgeDirection;

public class WireMatrix {
    private final BitSet _hasWire = new BitSet(PipeWire.values().length);
    private final BitSetCodec _bitSetCodec = new BitSetCodec();
    private final ConnectionMatrix[] _wires = new ConnectionMatrix[PipeWire.values().length];
    private final int[] _wireIconIndex = new int[PipeWire.values().length];
    private boolean dirty = false;

    public WireMatrix() {
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this._wires[i] = new ConnectionMatrix();
        }
    }

    public boolean hasWire(PipeWire color) {
        return this._hasWire.get(color.ordinal());
    }

    public void setWire(PipeWire color, boolean value) {
        if (this._hasWire.get(color.ordinal()) != value) {
            this._hasWire.set(color.ordinal(), value);
            this.dirty = true;
        }
    }

    public boolean isWireConnected(PipeWire color, ForgeDirection direction) {
        return this._wires[color.ordinal()].isConnected(direction);
    }

    public void setWireConnected(PipeWire color, ForgeDirection direction, boolean value) {
        this._wires[color.ordinal()].setConnected(direction, value);
    }

    public int getWireIconIndex(PipeWire color) {
        return this._wireIconIndex[color.ordinal()];
    }

    public void setWireIndex(PipeWire color, int value) {
        if (this._wireIconIndex[color.ordinal()] != value) {
            this._wireIconIndex[color.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < PipeWire.values().length; ++i) {
            if (!this._wires[i].isDirty()) continue;
            return true;
        }
        return this.dirty;
    }

    public void clean() {
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this._wires[i].clean();
        }
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        data.writeByte((int)this._bitSetCodec.encode(this._hasWire));
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this._wires[i].writeData(data);
            data.writeByte(this._wireIconIndex[i]);
        }
    }

    public void readData(ByteBuf data) {
        this._bitSetCodec.decode(data.readByte(), this._hasWire);
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this._wires[i].readData(data);
            this._wireIconIndex[i] = data.readByte();
        }
    }
}

