/*
 * Decompiled with CFR 0.152.
 */
package codechicken.obfuscator;

import codechicken.lib.asm.ObfMapping;
import codechicken.obfuscator.ObfRemapper;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ConstantObfuscator
implements Opcodes {
    public ObfRemapper obf;
    public List<ObfMapping> descCalls = new LinkedList<ObfMapping>();
    public List<ObfMapping> classCalls = new LinkedList<ObfMapping>();

    public ConstantObfuscator(ObfRemapper obf, String[] a_classCalls, String[] a_descCalls) {
        this.obf = obf;
        for (String callDesc : a_classCalls) {
            this.classCalls.add(ObfMapping.fromDesc((String)callDesc));
        }
        for (String callDesc : a_descCalls) {
            this.descCalls.add(ObfMapping.fromDesc((String)callDesc));
        }
    }

    public void transform(ClassNode cnode) {
        for (MethodNode method : cnode.methods) {
            for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                this.obfuscateInsnSeq(insn);
            }
        }
    }

    private void obfuscateInsnSeq(AbstractInsnNode insn) {
        LdcInsnNode node1;
        if (this.matchesClass(insn)) {
            node1 = (LdcInsnNode)insn;
            node1.cst = this.obf.map((String)node1.cst);
        }
        if (this.matchesDesc(insn)) {
            node1 = (LdcInsnNode)insn;
            LdcInsnNode node2 = (LdcInsnNode)node1.getNext();
            LdcInsnNode node3 = (LdcInsnNode)node2.getNext();
            ObfMapping mapping = new ObfMapping((String)node1.cst, (String)node2.cst, (String)node3.cst).map((Remapper)this.obf);
            node1.cst = mapping.s_owner;
            node2.cst = mapping.s_name;
            node3.cst = mapping.s_desc;
        }
    }

    private boolean matchesClass(AbstractInsnNode insn) {
        if (insn.getType() != 9) {
            return false;
        }
        if ((insn = insn.getNext()) == null || insn.getType() != 5) {
            return false;
        }
        for (ObfMapping m : this.classCalls) {
            if (!m.matches((MethodInsnNode)insn)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesDesc(AbstractInsnNode insn) {
        if (insn.getType() != 9) {
            return false;
        }
        if ((insn = insn.getNext()) == null || insn.getType() != 9) {
            return false;
        }
        if ((insn = insn.getNext()) == null || insn.getType() != 9) {
            return false;
        }
        if ((insn = insn.getNext()) == null || insn.getType() != 5) {
            return false;
        }
        for (ObfMapping m : this.descCalls) {
            if (!m.matches((MethodInsnNode)insn)) continue;
            return true;
        }
        return false;
    }
}

