package mods.immibis.autofood;

import java.util.List;

import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import mods.immibis.core.BlockCombined;

public class AutoFoodMachineBlock extends BlockCombined {

	public AutoFoodMachineBlock() {
		super(Material.iron);
		
		setHardness(2.0f);
		setCreativeTab(CreativeTabs.tabMisc);
	}
	
	private IIcon iAF1;
	
	@Override
	public void registerBlockIcons(IIconRegister par1IconRegister) {
		iAF1 = par1IconRegister.registerIcon("autofood:autofeeder");
	}
	
	@Override
	public IIcon getIcon(int par1, int par2) {
		if(par1 == 0)
			return iAF1;
		
		return iAF1;
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		switch(data) {
		case 0: return new AutoFeederTile();
		}
		return null;
	}

	@Override
	public void getCreativeItems(List<ItemStack> is) {
		is.add(new ItemStack(this, 1, 0));
	}

}
