/*
 * Decompiled with CFR 0.152.
 */
package wildycraft;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import wildycraft.ExtendedPlayerRS;
import wildycraft.InventoryExtendedRS;
import wildycraft.Wildycraft;

public class PlayerInventoryEvent {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && ExtendedPlayerRS.get((EntityPlayer)event.entity) == null) {
            ExtendedPlayerRS.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayerMP) {
            NBTTagCompound playerData = Wildycraft.proxy.getEntityData(((EntityPlayer)event.entity).func_70005_c_());
            if (playerData != null) {
                ((ExtendedPlayerRS)event.entity.getExtendedProperties("ExtendedRSPlayer")).loadNBTData(playerData);
            }
            ExtendedPlayerRS props = ExtendedPlayerRS.get((EntityPlayer)event.entity);
            PlayerInventoryEvent.syncOwnInventory((EntityPlayerMP)event.entity, props);
        }
    }

    public static void syncOwnInventory(EntityPlayerMP player, ExtendedPlayerRS epRS) {
        InventoryExtendedRS inv = epRS.inventory;
        try {
            ByteBuf buf = Unpooled.buffer();
            ByteBufOutputStream out = new ByteBufOutputStream(buf);
            out.writeUTF(player.func_70005_c_());
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)inv.func_70301_a(i));
            }
            if (!player.field_70170_p.field_72995_K) {
                Wildycraft.channel.sendTo(new FMLProxyPacket(buf, "WildycraftInv"), player);
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void syncOthersInventory(EntityPlayer player, ExtendedPlayerRS epRS) {
        InventoryExtendedRS inv = epRS.inventory;
        try {
            ByteBuf buf = Unpooled.buffer();
            ByteBufOutputStream out = new ByteBufOutputStream(buf);
            out.writeUTF(player.func_70005_c_());
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)inv.func_70301_a(i));
            }
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 60.0);
            if (!player.field_70170_p.field_72995_K) {
                Wildycraft.channel.sendToAllAround(new FMLProxyPacket(buf, "WildycraftInv"), point);
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

