/*
 * Decompiled with CFR 0.152.
 */
package wildycraft.item;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import wildycraft.Wildycraft;
import wildycraft.item.TreasureTrailInfo;

public class ItemTreasureTrail
extends Item {
    public static Item[] TreasureTrailRewards = new Item[]{Wildycraft.RuneChestPlateTrim, Wildycraft.RuneLegsTrim, Wildycraft.RuneHelmetTrim, Wildycraft.RuneBootsTrim, Wildycraft.RuneChestPlateGold, Wildycraft.RuneLegsGold, Wildycraft.RuneHelmetGold, Wildycraft.RuneBootsGold, Wildycraft.topHat, Wildycraft.onyx};
    public static Item[] RareTreasureTrailRewards = new Item[]{Wildycraft.purplePartyHat};
    public static Block[] targetBlocks = new Block[]{Blocks.field_150342_X, Blocks.field_150366_p, Wildycraft.oreblock, Blocks.field_150433_aE, Blocks.field_150351_n, Blocks.field_150462_ai};
    public static String[] entities = new String[]{"Pig", "Cow", "Sheep", "Chicken", "PigZombie", "Spider", "SnowMan"};
    public static String[] hardEntities = new String[]{"Creeper", "Zombie", "Black Knight", "Camel", "White Knight", "Ocelot", "Villager", "Turtle"};
    public static String[] eliteEntities = new String[]{"Fremennik Villager", "Enderman", "MushroomCow"};
    public static Item[] targetHelmets = new Item[]{Items.field_151024_Q, Items.field_151028_Y, Item.func_150898_a((Block)Blocks.field_150423_aK)};
    public static Item[] targetChestPlates = new Item[]{Items.field_151027_R, Items.field_151030_Z};
    public static Item[] targetLeggings = new Item[]{Items.field_151026_S, Items.field_151165_aa};
    public static Item[] targetBoots = new Item[]{Items.field_151021_T, Items.field_151167_ab};

    public ItemTreasureTrail() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("nolpfij_wildycraft:" + this.func_77658_a().substring(5));
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer player) {
        if (!par2World.field_72995_K) {
            boolean used = false;
            TreasureTrailInfo ti = new TreasureTrailInfo(par1ItemStack);
            if (ti.type == 0) {
                ti.length = (int)(Math.random() * 2.0) + 1;
                this.generateClue(player, ti);
                player.func_145747_a((IChatComponent)new ChatComponentText("Generated New Treasure Trail!"));
                used = true;
            } else if (ti.type == 1) {
                if (Math.abs(player.field_70165_t - (double)ti.xCoord) < 5.0 && Math.abs(player.field_70161_v - (double)ti.zCoord) < 5.0) {
                    this.processClue(par1ItemStack, player, par2World, ti);
                    used = true;
                }
            } else if (ti.type == 2) {
                Block b = par2World.func_147439_a((int)player.field_70165_t, (int)(player.field_70163_u - 1.0), (int)player.field_70161_v);
                Block b2 = par2World.func_147439_a((int)player.field_70165_t, (int)(player.field_70163_u - 1.0), (int)(player.field_70161_v + 1.0));
                Block b3 = par2World.func_147439_a((int)player.field_70165_t, (int)(player.field_70163_u - 1.0), (int)(player.field_70161_v - 1.0));
                Block b4 = par2World.func_147439_a((int)(player.field_70165_t + 1.0), (int)(player.field_70163_u - 1.0), (int)(player.field_70161_v + 1.0));
                Block b5 = par2World.func_147439_a((int)(player.field_70165_t + 1.0), (int)(player.field_70163_u - 1.0), (int)(player.field_70161_v - 1.0));
                Block b6 = par2World.func_147439_a((int)(player.field_70165_t + 1.0), (int)(player.field_70163_u - 1.0), (int)player.field_70161_v);
                Block b7 = par2World.func_147439_a((int)(player.field_70165_t - 1.0), (int)(player.field_70163_u - 1.0), (int)(player.field_70161_v + 1.0));
                Block b8 = par2World.func_147439_a((int)(player.field_70165_t - 1.0), (int)(player.field_70163_u - 1.0), (int)(player.field_70161_v - 1.0));
                Block b9 = par2World.func_147439_a((int)(player.field_70165_t - 1.0), (int)(player.field_70163_u - 1.0), (int)player.field_70161_v);
                if (b == targetBlocks[ti.targetBlock] || b2 == targetBlocks[ti.targetBlock] || b3 == targetBlocks[ti.targetBlock] || b4 == targetBlocks[ti.targetBlock] || b5 == targetBlocks[ti.targetBlock] || b6 == targetBlocks[ti.targetBlock] || b7 == targetBlocks[ti.targetBlock] || b8 == targetBlocks[ti.targetBlock] || b9 == targetBlocks[ti.targetBlock]) {
                    this.processClue(par1ItemStack, player, par2World, ti);
                    used = true;
                }
            } else if (ti.type == 3) {
                List entities = par2World.func_72872_a(EntityList.func_75620_a((String)ti.entity, (World)par2World).getClass(), player.field_70121_D.func_72314_b(5.0, 2.0, 5.0));
                if (entities.size() != 0) {
                    this.processClue(par1ItemStack, player, par2World, ti);
                    used = true;
                }
            } else if (ti.type == 4) {
                boolean flag = true;
                for (int i = 0; i < 3; ++i) {
                    int index = 3 - ti.slot[i];
                    if (player.func_82169_q(index) == null) continue;
                    if (ti.slot[i] == 0 && player.func_82169_q(index).func_77973_b() != targetHelmets[ti.armor[i]]) {
                        flag = false;
                    }
                    if (ti.slot[i] == 1 && player.func_82169_q(index).func_77973_b() != targetChestPlates[ti.armor[i]]) {
                        flag = false;
                    }
                    if (ti.slot[i] == 2 && player.func_82169_q(index).func_77973_b() != targetLeggings[ti.armor[i]]) {
                        flag = false;
                    }
                    if (ti.slot[i] != 3 || player.func_82169_q(index).func_77973_b() == targetBoots[ti.armor[i]]) continue;
                    flag = false;
                }
                if (flag) {
                    this.processClue(par1ItemStack, player, par2World, ti);
                    used = true;
                }
            }
            if (!used) {
                player.openGui((Object)Wildycraft.instance, 1, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
        return par1ItemStack;
    }

    public void generateReward(EntityPlayer player, World world) {
        int xLoc = (int)player.field_70165_t;
        int yLoc = (int)(player.field_70163_u - 1.0);
        int zLoc = (int)player.field_70161_v;
        if (yLoc <= 0) {
            yLoc = 5;
        }
        world.func_147449_b(xLoc, yLoc, zLoc, (Block)Blocks.field_150486_ae);
        TileEntityChest tc = (TileEntityChest)world.func_147438_o(xLoc, yLoc, zLoc);
        Random rand = new Random();
        if (tc != null) {
            ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)tc, (int)info.getCount(rand));
            ItemStack reward = rand.nextInt(50) == 0 ? new ItemStack(RareTreasureTrailRewards[rand.nextInt(RareTreasureTrailRewards.length)]) : new ItemStack(TreasureTrailRewards[rand.nextInt(TreasureTrailRewards.length)]);
            tc.func_70299_a(0, reward);
        }
    }

    public void processClue(ItemStack par1ItemStack, EntityPlayer player, World par2World, TreasureTrailInfo ti) {
        if (ti.length == 0) {
            --par1ItemStack.field_77994_a;
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Congratulations! You completed a Treasure Trail."));
                this.generateReward(player, par2World);
            }
        } else {
            --ti.length;
            this.generateClue(player, ti);
            player.func_145747_a((IChatComponent)new ChatComponentText("You got a new Clue Scroll!"));
        }
    }

    public void generateClue(EntityPlayer player, TreasureTrailInfo ti) {
        Random rand = new Random();
        int a = rand.nextInt(10);
        if (a < 5) {
            this.generateCoordClue(player, ti);
        } else if (a < 7) {
            this.generateBlockClue(ti);
        } else if (a < 9) {
            this.generateEntityClue(ti);
        } else {
            this.generateArmorClue(ti);
        }
    }

    private void generateBlockClue(TreasureTrailInfo ti) {
        Random rand = new Random();
        ti.type = 2;
        ti.targetBlock = rand.nextInt(targetBlocks.length);
        ti.writeToNBT();
    }

    private void generateEntityClue(TreasureTrailInfo ti) {
        Random rand = new Random();
        ti.type = 3;
        ti.entity = entities[rand.nextInt(entities.length)];
        ti.writeToNBT();
    }

    private void generateArmorClue(TreasureTrailInfo ti) {
        Random rand = new Random();
        ti.type = 4;
        int counter = 0;
        int skipped = rand.nextInt(4);
        for (int i = 0; i < 4; ++i) {
            if (i == skipped) continue;
            if (i == 0) {
                ti.slot[counter] = i;
                ti.armor[counter] = rand.nextInt(targetHelmets.length);
            }
            if (i == 1) {
                ti.slot[counter] = i;
                ti.armor[counter] = rand.nextInt(targetChestPlates.length);
            }
            if (i == 2) {
                ti.slot[counter] = i;
                ti.armor[counter] = rand.nextInt(targetLeggings.length);
            }
            if (i == 3) {
                ti.slot[counter] = i;
                ti.armor[counter] = rand.nextInt(targetBoots.length);
            }
            ++counter;
        }
        ti.writeToNBT();
    }

    public void generateCoordClue(EntityPlayer player, TreasureTrailInfo ti) {
        ti.type = 1;
        double distance = 70.0;
        double angle = Math.random() * Math.PI * 2.0;
        ti.xCoord = (int)(player.field_70165_t + Math.cos(angle) * distance);
        ti.zCoord = (int)(player.field_70161_v + Math.sin(angle) * distance);
        ti.writeToNBT();
    }
}

