/*
 * Decompiled with CFR 0.152.
 */
package wildycraft.item;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import wildycraft.item.ItemTreasureTrail;

public class TreasureTrailInfo {
    private String name = "Treasure Trail";
    public String text = "";
    public int type = 0;
    public int xCoord = 0;
    public int zCoord = 0;
    public int length = 0;
    public int[] slot = new int[]{0, 0, 0};
    public int[] armor = new int[]{0, 0, 0};
    public int targetBlock = 0;
    public String entity = "";
    private final ItemStack invItem;

    public TreasureTrailInfo(ItemStack stack) {
        this.invItem = stack;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.readFromNBT(stack.func_77978_p());
    }

    public void readFromNBT() {
        this.readFromNBT(this.invItem.func_77978_p());
    }

    public void readFromNBT(NBTTagCompound tagcompound) {
        this.type = tagcompound.func_74762_e("ClueScrollType");
        if (this.type == 1) {
            this.xCoord = tagcompound.func_74762_e("xCoord");
            this.zCoord = tagcompound.func_74762_e("zCoord");
        }
        if (this.type == 2) {
            this.targetBlock = tagcompound.func_74762_e("TargetBlock");
        }
        if (this.type == 3) {
            this.entity = tagcompound.func_74779_i("EntityName");
        }
        if (this.type == 4) {
            for (int i = 0; i < 3; ++i) {
                this.slot[i] = tagcompound.func_74762_e("Slot" + i);
                this.armor[i] = tagcompound.func_74762_e("Armor" + i);
            }
        }
        this.length = tagcompound.func_74762_e("ClueScrollLength");
    }

    public void writeToNBT() {
        this.writeToNBT(this.invItem.func_77978_p());
    }

    public void writeToNBT(NBTTagCompound tagcompound) {
        tagcompound.func_74768_a("ClueScrollType", this.type);
        if (this.type == 1) {
            tagcompound.func_74768_a("xCoord", this.xCoord);
            tagcompound.func_74768_a("zCoord", this.zCoord);
        }
        if (this.type == 2) {
            tagcompound.func_74768_a("TargetBlock", this.targetBlock);
        }
        if (this.type == 3) {
            tagcompound.func_74778_a("EntityName", this.entity);
        }
        if (this.type == 4) {
            for (int i = 0; i < 3; ++i) {
                tagcompound.func_74768_a("Slot" + i, this.slot[i]);
                tagcompound.func_74768_a("Armor" + i, this.armor[i]);
            }
        }
        tagcompound.func_74768_a("ClueScrollLength", this.length);
    }

    public String getInvName() {
        return this.name;
    }

    public String getClue() {
        String s = "";
        if (this.type == 0) {
            s = "Open again to generate this clue";
        } else if (this.type == 1) {
            if (this.xCoord >= 0) {
                s = s + this.xCoord;
                s = s + " East";
            } else {
                s = s + this.xCoord * -1;
                s = s + " West";
            }
            s = s + " , ";
            if (this.zCoord >= 0) {
                s = s + this.zCoord;
                s = s + " South";
            } else {
                s = s + this.zCoord * -1;
                s = s + " North";
            }
        } else if (this.type == 2) {
            s = "Stand on top: " + ItemTreasureTrail.targetBlocks[this.targetBlock].func_149732_F();
        } else if (this.type == 3) {
            s = "A " + this.entity + " has it";
            if (this.entity.equals("PigZombie")) {
                s = "A Zombie Pigman has it";
            }
            if (this.entity.equals("SnowMan")) {
                s = "A Snow Golem has it";
            }
            if (this.entity.equals("MushroomCow")) {
                s = "A Mooshroom has it";
            }
        } else if (this.type == 4) {
            s = "Wear:";
        }
        return s;
    }

    public String[] getArmors() {
        String[] armors = new String[3];
        for (int i = 0; i < 3; ++i) {
            if (this.slot[i] == 0) {
                armors[i] = ItemTreasureTrail.targetHelmets[this.armor[i]].func_77658_a().substring(5);
            }
            if (this.slot[i] == 1) {
                armors[i] = ItemTreasureTrail.targetChestPlates[this.armor[i]].func_77658_a().substring(5);
            }
            if (this.slot[i] == 2) {
                armors[i] = ItemTreasureTrail.targetLeggings[this.armor[i]].func_77658_a().substring(5);
            }
            if (this.slot[i] != 3) continue;
            armors[i] = ItemTreasureTrail.targetBoots[this.armor[i]].func_77658_a().substring(5);
        }
        return armors;
    }
}

