/*
 * Decompiled with CFR 0.152.
 */
package wildycraft.world;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import wildycraft.world.MapGenCavesRS;
import wildycraft.world.MapGenRavineRS;

public class ChunkProviderRS
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private double[] noiseArray;
    private double[] stoneNoise = new double[256];
    private MapGenCavesRS caveGenerator = new MapGenCavesRS();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenRavineRS ravineGenerator = new MapGenRavineRS();
    private BiomeGenBase[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] parabolicField;
    int[][] field_73219_j = new int[32][32];

    public ChunkProviderRS(World par1World, long par2, boolean par4) {
        this.worldObj = par1World;
        this.mapFeaturesEnabled = par4;
        this.rand = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void generateTerrain(int par1, int par2, Block[] par3ArrayOfByte) {
        int var4 = 4;
        int var5 = 16;
        int var6 = 63;
        int var7 = var4 + 1;
        int var8 = 17;
        int var9 = var4 + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, par1 * 4 - 2, par2 * 4 - 2, var7 + 5, var9 + 5);
        this.noiseArray = this.initializeNoiseField(this.noiseArray, par1 * var4, 0, par2 * var4, var7, var8, var9);
        for (int var10 = 0; var10 < var4; ++var10) {
            for (int var11 = 0; var11 < var4; ++var11) {
                for (int var12 = 0; var12 < var5; ++var12) {
                    double var13 = 0.125;
                    double var15 = this.noiseArray[((var10 + 0) * var9 + var11 + 0) * var8 + var12 + 0];
                    double var17 = this.noiseArray[((var10 + 0) * var9 + var11 + 1) * var8 + var12 + 0];
                    double var19 = this.noiseArray[((var10 + 1) * var9 + var11 + 0) * var8 + var12 + 0];
                    double var21 = this.noiseArray[((var10 + 1) * var9 + var11 + 1) * var8 + var12 + 0];
                    double var23 = (this.noiseArray[((var10 + 0) * var9 + var11 + 0) * var8 + var12 + 1] - var15) * var13;
                    double var25 = (this.noiseArray[((var10 + 0) * var9 + var11 + 1) * var8 + var12 + 1] - var17) * var13;
                    double var27 = (this.noiseArray[((var10 + 1) * var9 + var11 + 0) * var8 + var12 + 1] - var19) * var13;
                    double var29 = (this.noiseArray[((var10 + 1) * var9 + var11 + 1) * var8 + var12 + 1] - var21) * var13;
                    for (int var31 = 0; var31 < 8; ++var31) {
                        double var32 = 0.25;
                        double var34 = var15;
                        double var36 = var17;
                        double var38 = (var19 - var15) * var32;
                        double var40 = (var21 - var17) * var32;
                        for (int var42 = 0; var42 < 4; ++var42) {
                            int var43 = var42 + var10 * 4 << 11 | 0 + var11 * 4 << 7 | var12 * 8 + var31;
                            int var44 = 128;
                            var43 -= var44;
                            double var45 = 0.25;
                            double var49 = (var36 - var34) * var45;
                            double var47 = var34 - var49;
                            for (int var51 = 0; var51 < 4; ++var51) {
                                double d;
                                var47 += var49;
                                par3ArrayOfByte[var43 += var44] = d > 0.0 ? Blocks.field_150348_b : (var12 * 8 + var31 < var6 ? Blocks.field_150355_j : Blocks.field_150350_a);
                            }
                            var34 += var38;
                            var36 += var40;
                        }
                        var15 += var23;
                        var17 += var25;
                        var19 += var27;
                        var21 += var29;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, Block[] blockStorage, byte[] metaStorage, BiomeGenBase[] biomes) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, par1, par2, blockStorage, biomes);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen1.func_76305_a(this.stoneNoise, par1 * 16, par2 * 16, 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                BiomeGenBase biomegenbase = biomes[x + z * 16];
                biomegenbase.func_150573_a(this.worldObj, this.rand, blockStorage, metaStorage, par1 * 16 + z, par2 * 16 + x, this.stoneNoise[x + z * 16]);
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        byte[] var3 = new byte[65536];
        Block[] extra = new Block[65536];
        this.generateTerrain(par1, par2, extra);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.replaceBlocksForBiome(par1, par2, extra, var3, this.biomesForGeneration);
        this.caveGenerator.generate(this, this.worldObj, par1, par2, extra);
        this.ravineGenerator.generate(this, this.worldObj, par1, par2, extra);
        Chunk var4 = new Chunk(this.worldObj, extra, var3, par1, par2);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)this.biomesForGeneration[var6].field_76756_M;
        }
        var4.func_76603_b();
        return var4;
    }

    private double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        if (this.parabolicField == null) {
            this.parabolicField = new float[25];
            for (int var8 = -2; var8 <= 2; ++var8) {
                for (int var9 = -2; var9 <= 2; ++var9) {
                    float var10;
                    this.parabolicField[var8 + 2 + (var9 + 2) * 5] = var10 = 10.0f / MathHelper.func_76129_c((float)((float)(var8 * var8 + var9 * var9) + 0.2f));
                }
            }
        }
        double var44 = 684.412;
        double var45 = 684.412;
        this.noise5 = this.noiseGen5.func_76305_a(this.noise5, par2, par4, par5, par7, 1.121, 1.121, 0.5);
        this.noise6 = this.noiseGen6.func_76305_a(this.noise6, par2, par4, par5, par7, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.func_76304_a(this.noise3, par2, par3, par4, par5, par6, par7, var44 / 80.0, var45 / 160.0, var44 / 80.0);
        this.noise1 = this.noiseGen1.func_76304_a(this.noise1, par2, par3, par4, par5, par6, par7, var44, var45, var44);
        this.noise2 = this.noiseGen2.func_76304_a(this.noise2, par2, par3, par4, par5, par6, par7, var44, var45, var44);
        boolean var43 = false;
        boolean var42 = false;
        int var12 = 0;
        int var13 = 0;
        for (int var14 = 0; var14 < par5; ++var14) {
            for (int var15 = 0; var15 < par7; ++var15) {
                float var16 = 0.0f;
                float var17 = 0.0f;
                float var18 = 0.0f;
                int var19 = 2;
                BiomeGenBase var20 = this.biomesForGeneration[var14 + 2 + (var15 + 2) * (par5 + 5)];
                for (int var21 = -var19; var21 <= var19; ++var21) {
                    for (int var22 = -var19; var22 <= var19; ++var22) {
                        BiomeGenBase var23 = this.biomesForGeneration[var14 + var21 + 2 + (var15 + var22 + 2) * (par5 + 5)];
                        float var24 = this.parabolicField[var21 + 2 + (var22 + 2) * 5] / (var23.field_76748_D + 2.0f);
                        if (var23.field_76748_D > var20.field_76748_D) {
                            var24 /= 2.0f;
                        }
                        var16 += var23.field_76748_D * var24;
                        var17 += var23.field_76749_E * var24;
                        var18 += var24;
                    }
                }
                var16 /= var18;
                var17 /= var18;
                var16 = var16 * 0.9f + 0.1f;
                var17 = (var17 * 4.0f - 1.0f) / 8.0f;
                double var47 = this.noise6[var13] / 8000.0;
                if (var47 < 0.0) {
                    var47 = -var47 * 0.3;
                }
                if ((var47 = var47 * 3.0 - 2.0) < 0.0) {
                    if ((var47 /= 2.0) < -1.0) {
                        var47 = -1.0;
                    }
                    var47 /= 1.4;
                    var47 /= 2.0;
                } else {
                    if (var47 > 1.0) {
                        var47 = 1.0;
                    }
                    var47 /= 8.0;
                }
                ++var13;
                for (int var46 = 0; var46 < par6; ++var46) {
                    double var48 = var17;
                    double var26 = var16;
                    var48 += var47 * 0.2;
                    var48 = var48 * (double)par6 / 16.0;
                    double var28 = (double)par6 / 2.0 + var48 * 4.0;
                    double var30 = 0.0;
                    double var32 = ((double)var46 - var28) * 12.0 * 128.0 / 128.0 / var26;
                    if (var32 < 0.0) {
                        var32 *= 4.0;
                    }
                    double var34 = this.noise1[var12] / 512.0;
                    double var36 = this.noise2[var12] / 512.0;
                    double var38 = (this.noise3[var12] / 10.0 + 1.0) / 2.0;
                    var30 = var38 < 0.0 ? var34 : (var38 > 1.0 ? var36 : var34 + (var36 - var34) * var38);
                    var30 -= var32;
                    if (var46 > par6 - 4) {
                        double var40 = (float)(var46 - (par6 - 4)) / 3.0f;
                        var30 = var30 * (1.0 - var40) + -10.0 * var40;
                    }
                    par1ArrayOfDouble[var12] = var30;
                    ++var12;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int var14;
        int var13;
        int var12;
        BlockSand.field_149832_M = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        BiomeGenBase var6 = this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * var7 + (long)par3 * var9 ^ this.worldObj.func_72905_C());
        boolean var11 = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.rand, par2, par3, var11));
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
            var11 = this.villageGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
            this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
            this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
        }
        if (TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)var11, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE) && !var11 && this.rand.nextInt(4) == 0) {
            var12 = var4 + this.rand.nextInt(16) + 8;
            var13 = this.rand.nextInt(128);
            var14 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.rand, var12, var13, var14);
        }
        if (TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)var11, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !var11 && this.rand.nextInt(8) == 0) {
            var12 = var4 + this.rand.nextInt(16) + 8;
            var13 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            var14 = var5 + this.rand.nextInt(16) + 8;
            if (var13 < 63 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, var12, var13, var14);
            }
        }
        boolean doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)var11, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (var12 = 0; doGen && var12 < 8; ++var12) {
            int var15;
            var13 = var4 + this.rand.nextInt(16) + 8;
            if (!new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, var13, var14 = this.rand.nextInt(128), var15 = var5 + this.rand.nextInt(16) + 8)) continue;
        }
        var6.func_76728_a(this.worldObj, this.rand, var4, var5);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)var6, (int)(var4 + 8), (int)(var5 + 8), (int)16, (int)16, (Random)this.rand);
        var4 += 8;
        var5 += 8;
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)var11, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (var12 = 0; doGen && var12 < 16; ++var12) {
            for (var13 = 0; var13 < 16; ++var13) {
                var14 = this.worldObj.func_72874_g(var4 + var12, var5 + var13);
                if (this.worldObj.func_72884_u(var12 + var4, var14 - 1, var13 + var5)) {
                    this.worldObj.func_147449_b(var12 + var4, var14 - 1, var13 + var5, Blocks.field_150432_aD);
                }
                if (!this.worldObj.func_147478_e(var12 + var4, var14, var13 + var5, true)) continue;
                this.worldObj.func_147449_b(var12 + var4, var14, var13 + var5, Blocks.field_150431_aC);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.rand, par2, par3, var11));
        BlockSand.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return "Stronghold".equals(par2Str) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(par1World, par3, par4, par5) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int var1, int var2) {
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }
}

