/*
 * Decompiled with CFR 0.152.
 */
package wildycraft.world;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import wildycraft.world.GenLayerAddIslandRS;
import wildycraft.world.GenLayerAddSnowRS;
import wildycraft.world.GenLayerFuzzyZoomRS;
import wildycraft.world.GenLayerHillsRS;
import wildycraft.world.GenLayerRSBiome;
import wildycraft.world.GenLayerRiverInitRS;
import wildycraft.world.GenLayerRiverMixRS;
import wildycraft.world.GenLayerRiverRS;
import wildycraft.world.GenLayerShoreRS;
import wildycraft.world.GenLayerSwampRivers;
import wildycraft.world.GenLayerVoronoiZoomRS;
import wildycraft.world.GenLayerZoomRS;

public abstract class GenLayerRS {
    private long worldGenSeed;
    protected GenLayer parent;
    private long chunkSeed;
    private long baseSeed;

    public static GenLayer[] initializeAllBiomeGenerators(long par0, WorldType par2WorldType) {
        GenLayerIsland var3 = new GenLayerIsland(1L);
        GenLayerFuzzyZoomRS var9 = new GenLayerFuzzyZoomRS(2000L, (GenLayer)var3);
        GenLayerAddIslandRS var10 = new GenLayerAddIslandRS(1L, var9);
        GenLayerZoomRS var11 = new GenLayerZoomRS(2001L, var10);
        var10 = new GenLayerAddIslandRS(2L, var11);
        GenLayerAddSnowRS var12 = new GenLayerAddSnowRS(2L, var10);
        var11 = new GenLayerZoomRS(2002L, var12);
        var10 = new GenLayerAddIslandRS(3L, var11);
        var11 = new GenLayerZoomRS(2003L, var10);
        var10 = new GenLayerAddIslandRS(4L, var11);
        GenLayerAddMushroomIsland var16 = new GenLayerAddMushroomIsland(5L, (GenLayer)var10);
        int var4 = 4;
        if (par2WorldType == WorldType.field_77135_d) {
            var4 = 6;
        }
        GenLayer var5 = GenLayerZoomRS.magnify(1000L, (GenLayer)var16, 0);
        GenLayerRiverInitRS var13 = new GenLayerRiverInitRS(100L, var5);
        var5 = GenLayerZoomRS.magnify(1000L, var13, var4 + 2);
        GenLayerRiverRS var14 = new GenLayerRiverRS(1L, var5);
        GenLayerSmooth var15 = new GenLayerSmooth(1000L, (GenLayer)var14);
        GenLayer var6 = GenLayerZoomRS.magnify(1000L, (GenLayer)var16, 0);
        GenLayerRSBiome var17 = new GenLayerRSBiome(200L, var6, par2WorldType);
        var6 = GenLayerZoomRS.magnify(1000L, var17, 2);
        GenLayer var18 = new GenLayerHillsRS(1000L, var6);
        for (int var7 = 0; var7 < var4; ++var7) {
            var18 = new GenLayerZoomRS(1000 + var7, var18);
            if (var7 == 0) {
                var18 = new GenLayerAddIslandRS(3L, var18);
            }
            if (var7 == 1) {
                var18 = new GenLayerShoreRS(1000L, var18);
            }
            if (var7 != 1) continue;
            var18 = new GenLayerSwampRivers(1000L, var18);
        }
        GenLayerSmooth var20 = new GenLayerSmooth(1000L, var18);
        GenLayerRiverMixRS var21 = new GenLayerRiverMixRS(100L, (GenLayer)var20, (GenLayer)var15);
        GenLayerVoronoiZoomRS var8 = new GenLayerVoronoiZoomRS(10L, var21);
        var20.func_75905_a(par0);
        var8.func_75905_a(par0);
        return new GenLayer[]{var21, var8, var21};
    }

    public GenLayerRS(long par1) {
        this.baseSeed = par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
    }

    public void initWorldGenSeed(long par1) {
        this.worldGenSeed = par1;
        if (this.parent != null) {
            this.parent.func_75905_a(par1);
        }
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
    }

    public void initChunkSeed(long par1, long par3) {
        this.chunkSeed = this.worldGenSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par1;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par3;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par1;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par3;
    }

    protected int nextInt(int par1) {
        int var2 = (int)((this.chunkSeed >> 24) % (long)par1);
        if (var2 < 0) {
            var2 += par1;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return var2;
    }

    public abstract int[] getInts(int var1, int var2, int var3, int var4);

    public static byte getModdedBiomeSize(WorldType worldType, byte original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.newSize;
    }
}

