/*
 * Decompiled with CFR 0.152.
 */
package wildycraft.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class MapGenRavineRS {
    private float[] field_75046_d = new float[1024];
    protected int range = 8;
    protected Random rand = new Random();
    protected World worldObj;

    public void generate(IChunkProvider par1IChunkProvider, World par2World, int par3, int par4, Block[] par5ArrayOfByte) {
        int k = this.range;
        this.worldObj = par2World;
        this.rand.setSeed(par2World.func_72905_C());
        long l = this.rand.nextLong();
        long i1 = this.rand.nextLong();
        for (int j1 = par3 - k; j1 <= par3 + k; ++j1) {
            for (int k1 = par4 - k; k1 <= par4 + k; ++k1) {
                long l1 = (long)j1 * l;
                long i2 = (long)k1 * i1;
                this.rand.setSeed(l1 ^ i2 ^ par2World.func_72905_C());
                this.recursiveGenerate(par2World, j1, k1, par3, par4, par5ArrayOfByte);
            }
        }
    }

    protected void generateRavine(long par1, int par3, int par4, Block[] par5ArrayOfByte, double par6, double par8, double par10, float par12, float par13, float par14, int par15, int par16, double par17) {
        Random random = new Random(par1);
        double d4 = par3 * 16 + 8;
        double d5 = par4 * 16 + 8;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (par16 <= 0) {
            int j1 = this.range * 16 - 16;
            par16 = j1 - random.nextInt(j1 / 4);
        }
        boolean flag = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            flag = true;
        }
        float f5 = 1.0f;
        for (int k1 = 0; k1 < 128; ++k1) {
            if (k1 == 0 || random.nextInt(3) == 0) {
                f5 = 1.0f + random.nextFloat() * random.nextFloat() * 1.0f;
            }
            this.field_75046_d[k1] = f5 * f5;
        }
        while (par15 < par16) {
            double d6 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)par15 * (float)Math.PI / (float)par16)) * par12 * 1.0f);
            double d7 = d6 * par17;
            d6 *= (double)random.nextFloat() * 0.25 + 0.75;
            d7 *= (double)random.nextFloat() * 0.25 + 0.75;
            float f6 = MathHelper.func_76134_b((float)par14);
            float f7 = MathHelper.func_76126_a((float)par14);
            par6 += (double)(MathHelper.func_76134_b((float)par13) * f6);
            par8 += (double)f7;
            par10 += (double)(MathHelper.func_76126_a((float)par13) * f6);
            par14 *= 0.7f;
            par14 += f4 * 0.05f;
            par13 += f3 * 0.05f;
            f4 *= 0.8f;
            f3 *= 0.5f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f3 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (flag || random.nextInt(4) != 0) {
                double d8 = par6 - d4;
                double d9 = par10 - d5;
                double d10 = par16 - par15;
                double d11 = par12 + 2.0f + 16.0f;
                if (d8 * d8 + d9 * d9 - d10 * d10 > d11 * d11) {
                    return;
                }
                if (par6 >= d4 - 16.0 - d6 * 2.0 && par10 >= d5 - 16.0 - d6 * 2.0 && par6 <= d4 + 16.0 + d6 * 2.0 && par10 <= d5 + 16.0 + d6 * 2.0) {
                    int k3;
                    int j3;
                    int l1 = MathHelper.func_76128_c((double)(par6 - d6)) - par3 * 16 - 1;
                    int i2 = MathHelper.func_76128_c((double)(par6 + d6)) - par3 * 16 + 1;
                    int j2 = MathHelper.func_76128_c((double)(par8 - d7)) - 1;
                    int k2 = MathHelper.func_76128_c((double)(par8 + d7)) + 1;
                    int l2 = MathHelper.func_76128_c((double)(par10 - d6)) - par4 * 16 - 1;
                    int i3 = MathHelper.func_76128_c((double)(par10 + d6)) - par4 * 16 + 1;
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    if (i2 > 16) {
                        i2 = 16;
                    }
                    if (j2 < 1) {
                        j2 = 1;
                    }
                    if (k2 > 120) {
                        k2 = 120;
                    }
                    if (l2 < 0) {
                        l2 = 0;
                    }
                    if (i3 > 16) {
                        i3 = 16;
                    }
                    boolean flag1 = false;
                    for (j3 = l1; !flag1 && j3 < i2; ++j3) {
                        for (int l3 = l2; !flag1 && l3 < i3; ++l3) {
                            for (int i4 = k2 + 1; !flag1 && i4 >= j2 - 1; --i4) {
                                k3 = (j3 * 16 + l3) * 128 + i4;
                                if (i4 < 0 || i4 >= 128) continue;
                                if (this.isOceanBlock(par5ArrayOfByte, k3, j3, i4, l3, par3, par4)) {
                                    flag1 = true;
                                }
                                if (i4 == j2 - 1 || j3 == l1 || j3 == i2 - 1 || l3 == l2 || l3 == i3 - 1) continue;
                                i4 = j2;
                            }
                        }
                    }
                    if (!flag1) {
                        for (j3 = l1; j3 < i2; ++j3) {
                            double d12 = ((double)(j3 + par3 * 16) + 0.5 - par6) / d6;
                            for (k3 = l2; k3 < i3; ++k3) {
                                double d13 = ((double)(k3 + par4 * 16) + 0.5 - par10) / d6;
                                int j4 = (j3 * 16 + k3) * 128 + k2;
                                boolean flag2 = false;
                                if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                                for (int k4 = k2 - 1; k4 >= j2; --k4) {
                                    double d14 = ((double)k4 + 0.5 - par8) / d7;
                                    if ((d12 * d12 + d13 * d13) * (double)this.field_75046_d[k4] + d14 * d14 / 6.0 < 1.0) {
                                        if (this.isTopBlock(par5ArrayOfByte, j4, j3, k4, k3, par3, par4)) {
                                            flag2 = true;
                                        }
                                        this.digBlock(par5ArrayOfByte, j4, j3, k4, k3, par3, par4, flag2);
                                    }
                                    --j4;
                                }
                            }
                        }
                        if (flag) break;
                    }
                }
            }
            ++par15;
        }
    }

    protected void recursiveGenerate(World par1World, int par2, int par3, int par4, int par5, Block[] par6ArrayOfByte) {
        if (this.rand.nextInt(50) == 0) {
            double d0 = par2 * 16 + this.rand.nextInt(16);
            double d1 = this.rand.nextInt(this.rand.nextInt(40) + 8) + 20;
            double d2 = par3 * 16 + this.rand.nextInt(16);
            int b0 = 1;
            for (int i1 = 0; i1 < b0; ++i1) {
                float f = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = (this.rand.nextFloat() * 2.0f + this.rand.nextFloat()) * 2.0f;
                this.generateRavine(this.rand.nextLong(), par4, par5, par6ArrayOfByte, d0, d1, d2, f2, f, f1, 0, 0, 3.0);
            }
        }
    }

    protected boolean isOceanBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ) {
        return data[index] == Blocks.field_150358_i || data[index] == Blocks.field_150355_j;
    }

    private boolean isExceptionBiome(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76789_p) {
            return true;
        }
        if (biome == BiomeGenBase.field_76787_r) {
            return true;
        }
        return biome == BiomeGenBase.field_76769_d;
    }

    private boolean isTopBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ) {
        BiomeGenBase biome = this.worldObj.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
        return this.isExceptionBiome(biome) ? data[index] == Blocks.field_150349_c : data[index] == biome.field_76752_A;
    }

    protected void digBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        BiomeGenBase biome = this.worldObj.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
        BlockGrass top = this.isExceptionBiome(biome) ? Blocks.field_150349_c : biome.field_76752_A;
        Block filler = this.isExceptionBiome(biome) ? Blocks.field_150346_d : biome.field_76753_B;
        Block block = data[index];
        if (block == Blocks.field_150348_b || block == filler || block == top) {
            if (y < 10) {
                data[index] = Blocks.field_150356_k;
            } else {
                data[index] = Blocks.field_150350_a;
                if (foundTop && data[index - 1] == filler) {
                    data[index - 1] = top;
                }
            }
        }
    }
}

