/*
 * Decompiled with CFR 0.152.
 */
package com.rafamv.bygoneage.entity;

import com.rafamv.bygoneage.BygoneAge;
import com.rafamv.bygoneage.enums.BygoneAgeGuiInformation;
import com.rafamv.bygoneage.enums.BygoneAgeMobsInformation;
import com.rafamv.bygoneage.handler.BygoneAgeDNAHandler;
import com.rafamv.bygoneage.items.Analyzer;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class EntityBygoneAgeCreature
extends EntityCreature
implements IEntityAdditionalSpawnData {
    public byte creatureID;
    protected float consideredAdult;
    protected final HashSet<Integer> growthStageList = new HashSet();
    public float healthGeneticQuality;
    public float attackGeneticQuality;
    public float speedGeneticQuality;
    public float sizeGeneticQuality;
    public boolean gender;
    public String geneticCode;
    public float field_70131_O;
    public float length;
    public float bBoxXZ;
    public float bBoxY;
    private static final int KEY_SCALE = 14;
    private static final int KEY_GROWTH_STAGE = 17;
    private static final int KEY_COLOR = 18;

    public EntityBygoneAgeCreature(World world, byte id, float maxChildAge) {
        super(world);
        this.creatureID = id >= 0 ? id : (byte)0;
        if (this.getSizeGeneticQuality() <= 0.0f) {
            this.setSizeGeneticQuality(1.0f);
        }
        if (this.getHealthGeneticQuality() <= 0.0f) {
            this.setHealthGeneticQuality(1.0f);
        }
        if (this.getAttackGeneticQuality() <= 0.0f) {
            this.setAttackGeneticQuality(1.0f);
        }
        if (this.getSpeedGeneticQuality() <= 0.0f) {
            this.setSpeedGeneticQuality(1.0f);
        }
        this.consideredAdult = maxChildAge * (float)BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime();
        this.resetGrowthStageList();
        this.setInitCreatureData();
        if (this.field_70170_p.field_72995_K) {
            this.setCreatureColor();
            this.setCreatureSize();
            this.setCreatureScale();
        } else {
            this.setHalfOfTheCreatureSize();
        }
    }

    public float func_70603_bj() {
        return 1.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(14, (Object)Float.valueOf(this.length / BygoneAgeMobsInformation.values()[this.creatureID].getMaxLength() * (this.field_70131_O / BygoneAgeMobsInformation.values()[this.creatureID].getMaxHeight()) / 2.0f));
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)Float.valueOf(0.0f));
    }

    public void func_70636_d() {
        if (this.getTotalTicksLived() < BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime() + 1 && this.growthStageList.contains(this.getTotalTicksLived())) {
            if (this.getGrowthStage() < BygoneAgeMobsInformation.values()[this.getCreatureID()].getTimesOfGrowth()) {
                this.setGrowthStage((byte)(this.getGrowthStage() + 1));
            }
            this.setBouningBox();
            if (!this.field_70170_p.field_72995_K) {
                this.updateCreatureData(this.getTotalTicksLived());
            } else {
                this.setCreatureSize();
            }
        }
        super.func_70636_d();
    }

    public void forceCreatureGrowth(EntityPlayer player, ItemStack itemStack, byte growthIncrease) {
        if (this.getGrowthStage() + growthIncrease < BygoneAgeMobsInformation.values()[this.getCreatureID()].getTimesOfGrowth()) {
            if (!player.field_71075_bZ.field_75098_d) {
                --itemStack.field_77994_a;
                if (itemStack.field_77994_a <= 0) {
                    itemStack = null;
                }
            }
            this.setGrowthStage((byte)(this.getGrowthStage() + growthIncrease));
            this.setTicksExisted(BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime() * this.getGrowthStage() / BygoneAgeMobsInformation.values()[this.getCreatureID()].getTimesOfGrowth());
            if (!this.field_70170_p.field_72995_K) {
                this.updateCreatureData(this.getTotalTicksLived());
            } else {
                this.setCreatureSize();
            }
        } else if (!this.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText("This creature cannot grow anymore."));
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70694_bm() != (ItemStack)null) {
            if (player.func_70694_bm().func_77973_b() instanceof Analyzer) {
                this.showStatus();
            } else if (player.func_70694_bm().func_77973_b().equals(Items.field_151150_bK)) {
                this.forceCreatureGrowth(player, player.func_70694_bm(), (byte)5);
            }
        }
        return super.func_70085_c(player);
    }

    @SideOnly(value=Side.CLIENT)
    private void showStatus() {
        BygoneAge.creatureToAnalyze = this;
        FMLClientHandler.instance().getClient().field_71439_g.openGui((Object)BygoneAge.instance, BygoneAgeGuiInformation.ANALYZER.getGuiId(), this.field_70170_p, 0, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    private void updateCreatureData(int ticks) {
        double oldHealth = this.getCreatureHealth();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((int)((double)(this.getHealthGeneticQuality() * (float)ticks) * (BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxHealth() - BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinHealth()) / (double)BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinHealth())));
        double newHealth = this.getCreatureHealth();
        this.func_70691_i((float)(newHealth - oldHealth));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(this.getAttackGeneticQuality() * (float)ticks) * (BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxStrength() - BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinStrength()) / (double)BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinStrength());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Double.valueOf((double)(this.getSpeedGeneticQuality() * (float)ticks) * (BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxSpeed() - BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinSpeed()) / (double)BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinSpeed()).doubleValue());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(Double.valueOf((double)ticks * (BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxKnockback() - BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinKnockback()) / (double)BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinKnockback()).doubleValue());
        this.setCreatureLength();
        this.setCreatureHeight();
        this.setCreatureScale();
        this.setHalfOfTheCreatureSize();
        this.setCreatureColor();
    }

    public void setGenetics(float healthGene, float attackGene, float speedGene, float sizeGene) {
        this.setHealthGeneticQuality(healthGene);
        this.setAttackGeneticQuality(attackGene);
        this.setSpeedGeneticQuality(speedGene);
        this.setSizeGeneticQuality(sizeGene);
        this.setCreatureColor();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    private void setInitCreatureData() {
        double oldHealth = this.getCreatureHealth();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getHealthGeneticQuality() * BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinHealth());
        double newHealth = this.getCreatureHealth();
        this.func_70691_i((float)(newHealth - oldHealth));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackGeneticQuality() * BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinStrength());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getSpeedGeneticQuality() * BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinKnockback());
        this.length = BygoneAgeMobsInformation.values()[this.creatureID].getMinLength();
        this.field_70131_O = BygoneAgeMobsInformation.values()[this.creatureID].getMinHeight();
        this.setCreatureGender(this.field_70146_Z.nextInt(2) > 0);
    }

    public byte getCreatureID() {
        return this.creatureID;
    }

    public String getCreatureName() {
        return BygoneAgeMobsInformation.values()[this.creatureID].getCreatureName();
    }

    private void setHealthGeneticQuality(float healthGQ) {
        this.healthGeneticQuality = healthGQ;
    }

    public float getHealthGeneticQuality() {
        return this.healthGeneticQuality;
    }

    private void setAttackGeneticQuality(float attackGQ) {
        this.attackGeneticQuality = attackGQ;
    }

    public float getAttackGeneticQuality() {
        return this.attackGeneticQuality;
    }

    private void setSpeedGeneticQuality(float speedGQ) {
        this.speedGeneticQuality = speedGQ;
    }

    public float getSpeedGeneticQuality() {
        return this.speedGeneticQuality;
    }

    public void setSizeGeneticQuality(float gene) {
        this.sizeGeneticQuality = gene;
    }

    public float getSizeGeneticQuality() {
        return this.sizeGeneticQuality;
    }

    public boolean hasGeneticCode() {
        return this.getGeneticCode() != null && this.getGeneticCode() != "";
    }

    public String getGeneticCode() {
        return this.geneticCode;
    }

    public void setGeneticCode(String code) {
        this.geneticCode = code;
    }

    public void createGeneticCode(String dna1, String dna2, String dna3, String dna4) {
        if (!this.hasGeneticCode()) {
            String code = "";
            if (dna1.length() > 18) {
                dna1 = dna1.substring(0, 19);
                code = code + dna1.substring(0, 5);
            } else {
                code = code + dna1.substring(0, 5);
            }
            if (dna2.length() > 18) {
                dna2 = dna2.substring(0, 19);
                code = code + dna2.substring(5, 10);
            } else {
                code = code + dna2.substring(5, 10);
            }
            if (dna3.length() > 18) {
                dna3 = dna3.substring(0, 19);
                code = code + dna3.substring(10, 14);
            } else {
                code = code + dna3.substring(10, 14);
            }
            if (dna4.length() > 18) {
                dna4 = dna4.substring(0, 19);
                code = code + dna4.substring(14, 18);
            } else {
                code = code + dna4.substring(14, 18);
            }
            if (code.length() != 18) {
                code = BygoneAgeDNAHandler.generateNewRNA(18);
                System.out.println("Error: DNA created was not in the corrent length. New DNA code was generated: " + code);
                this.geneticCode = code;
            } else {
                this.geneticCode = code;
            }
        }
    }

    public float getAdultPercentage() {
        return this.consideredAdult;
    }

    public boolean isCreatureAdult() {
        return (float)this.getTotalTicksLived() >= this.getAdultPercentage();
    }

    public boolean isCreatureHalfAdult() {
        return (float)this.getTotalTicksLived() >= 0.5f * this.getAdultPercentage() && (float)this.getTotalTicksLived() < this.getAdultPercentage();
    }

    public void setAdultPercentage(float adultAge) {
        this.consideredAdult = adultAge;
    }

    public byte getGrowthStage() {
        return this.field_70180_af.func_75683_a(17);
    }

    private void setGrowthStage(byte stage) {
        this.field_70180_af.func_75692_b(17, (Object)stage);
    }

    public void resetGrowthStageList() {
        int maximumGrowthTime = BygoneAgeMobsInformation.values()[this.creatureID].getFullGrowthTime();
        byte timesOfGrowth = BygoneAgeMobsInformation.values()[this.creatureID].getTimesOfGrowth();
        this.growthStageList.add(1);
        for (byte i = 1; i < timesOfGrowth; i = (byte)(i + 1)) {
            this.growthStageList.add(maximumGrowthTime * i / timesOfGrowth);
        }
        this.growthStageList.add(maximumGrowthTime);
    }

    public void setCreatureScale() {
        if (this.getTotalTicksLived() < BygoneAgeMobsInformation.values()[this.creatureID].getFullGrowthTime()) {
            this.field_70180_af.func_75692_b(14, (Object)Float.valueOf(this.getSizeGeneticQuality() * ((BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinHeight() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinLength()) / 2.0f + ((BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxHeight() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxLength()) / 2.0f - (BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinHeight() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getMinLength()) / 2.0f) * ((float)this.getTotalTicksLived() / (float)BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime())) / ((BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxHeight() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxLength()) / 2.0f)));
        } else {
            this.field_70180_af.func_75692_b(14, (Object)Float.valueOf(this.getSizeGeneticQuality()));
        }
    }

    public float getCreatureScale() {
        return this.field_70180_af.func_111145_d(14);
    }

    public void setCreatureColor() {
        float color = (this.getSizeGeneticQuality() + this.getAttackGeneticQuality() + this.getHealthGeneticQuality() + this.getSpeedGeneticQuality()) / 10.0f;
        if (color > 1.0f) {
            color = 1.0f;
        } else if (color < 0.0f) {
            color = 0.0f;
        }
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(color));
    }

    public float getCreatureColor() {
        return this.field_70180_af.func_111145_d(18);
    }

    public float getXZBouningBox() {
        return this.bBoxXZ;
    }

    public float getYBouningBox() {
        return this.bBoxY;
    }

    public void setBouningBox() {
        this.bBoxXZ = this.getSizeGeneticQuality() * (BygoneAgeMobsInformation.values()[this.getCreatureID()].getXZcollisionBoxMin() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getXZcollisionBoxVariation() * ((float)this.getGrowthStage() / (float)BygoneAgeMobsInformation.values()[this.getCreatureID()].getTimesOfGrowth()));
        this.bBoxY = this.getSizeGeneticQuality() * (BygoneAgeMobsInformation.values()[this.getCreatureID()].getYcollisionBoxMin() + BygoneAgeMobsInformation.values()[this.getCreatureID()].getYcollisionBoxVariation() * ((float)this.getGrowthStage() / (float)BygoneAgeMobsInformation.values()[this.getCreatureID()].getTimesOfGrowth()));
    }

    public float func_70047_e() {
        return this.getCreatureHeight() * 0.85f;
    }

    public double getCreatureCurrentHealth() {
        return (double)((int)(100.0f * this.func_110143_aJ())) / 100.0;
    }

    public double getCreatureHealth() {
        return (double)((int)(100.0 * this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e())) / 100.0;
    }

    public int getCreatureHealthScaled(int i) {
        return (int)(this.getCreatureHealth() * (double)i / ((double)1.8f * BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxHealth()));
    }

    public double getCreatureAttack() {
        return (double)((int)(100.0 * this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) / 100.0;
    }

    public int getCreatureAttackScaled(int i) {
        return (int)(this.getCreatureAttack() * (double)i / ((double)1.8f * BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxStrength()));
    }

    public double getCreatureSpeed() {
        return (double)((int)(100.0 * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e())) / 100.0;
    }

    public double getCreatureKnockback() {
        return (double)((int)(100.0 * this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e())) / 100.0;
    }

    public int getCreatureSpeedScaled(int i) {
        return (int)(this.getCreatureSpeed() * (double)i / ((double)1.8f * BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxSpeed()));
    }

    public int getCreatureHeightScaled(int i) {
        return (int)(this.getCreatureHeight() * (float)i / (1.8f * BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxHeight()));
    }

    public int getCreatureLengthScaled(int i) {
        return (int)(this.getCreatureLength() * (float)i / (1.8f * BygoneAgeMobsInformation.values()[this.getCreatureID()].getMaxLength()));
    }

    public int getTotalTicksLived() {
        return this.field_70173_aa;
    }

    private void setTicksExisted(int ticks) {
        this.field_70173_aa = ticks;
    }

    public boolean isMale() {
        return this.getCreatureGender();
    }

    public String getCreatureGenderString() {
        if (this.getCreatureGender()) {
            return "Male";
        }
        return "Female";
    }

    public boolean getCreatureGender() {
        return this.gender;
    }

    public void setCreatureGender(boolean sex) {
        this.gender = sex;
    }

    protected final void setCreatureSize() {
        this.setBouningBox();
        super.func_70105_a(this.getXZBouningBox(), this.getYBouningBox());
    }

    protected final void setHalfOfTheCreatureSize() {
        this.setBouningBox();
        super.func_70105_a(this.getXZBouningBox() / 2.0f, this.getYBouningBox() / 2.0f);
    }

    public void setCreatureLength() {
        this.length = this.getTotalTicksLived() <= BygoneAgeMobsInformation.values()[this.creatureID].getFullGrowthTime() ? this.getSizeGeneticQuality() * (BygoneAgeMobsInformation.values()[this.creatureID].getMinLength() + (float)this.getTotalTicksLived() * (BygoneAgeMobsInformation.values()[this.creatureID].getMaxLength() - BygoneAgeMobsInformation.values()[this.creatureID].getMinLength()) / (float)BygoneAgeMobsInformation.values()[this.creatureID].getFullGrowthTime()) : this.getSizeGeneticQuality() * BygoneAgeMobsInformation.values()[this.creatureID].getMaxLength();
    }

    public float getCreatureLength() {
        return (float)((int)(100.0f * this.length)) / 100.0f;
    }

    public void setCreatureHeight() {
        this.field_70131_O = this.getTotalTicksLived() <= BygoneAgeMobsInformation.values()[this.creatureID].getFullGrowthTime() ? this.getSizeGeneticQuality() * (BygoneAgeMobsInformation.values()[this.creatureID].getMinHeight() + (float)this.getTotalTicksLived() * (BygoneAgeMobsInformation.values()[this.creatureID].getMaxHeight() - BygoneAgeMobsInformation.values()[this.creatureID].getMinHeight()) / (float)BygoneAgeMobsInformation.values()[this.creatureID].getFullGrowthTime()) : this.getSizeGeneticQuality() * BygoneAgeMobsInformation.values()[this.creatureID].getMaxHeight();
    }

    public float getCreatureHeight() {
        return (float)((int)(100.0f * this.field_70131_O)) / 100.0f;
    }

    protected ItemStack createDNACodeForItemStack(ItemStack itemStack) {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.hasGeneticCode()) {
            compound.func_74778_a("RNAHelix1", this.getGeneticCode());
            compound.func_74778_a("RNAHelix2", BygoneAgeDNAHandler.createNewRNAFrom(compound.func_74779_i("RNAHelix1")));
        } else {
            compound.func_74778_a("RNAHelix1", BygoneAgeDNAHandler.generateNewRNA(18));
            compound.func_74778_a("RNAHelix2", BygoneAgeDNAHandler.createNewRNAFrom(compound.func_74779_i("RNAHelix1")));
        }
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    protected EntityItem dropItemStackWithDNA(ItemStack itemStackWithDNACode) {
        return this.func_70099_a(itemStackWithDNACode, 0.0f);
    }

    public int getCreatureAgeInDays() {
        return this.getTotalTicksLived() / 24000;
    }

    public int getCreatureAgeInMonths() {
        return this.getTotalTicksLived() / 720000;
    }

    public int getCreatureAgeInYears() {
        return this.getTotalTicksLived() / 8640000;
    }

    public String getCreatureAgeString() {
        byte years = (byte)this.getCreatureAgeInYears();
        byte months = (byte)(this.getCreatureAgeInMonths() - 12 * this.getCreatureAgeInYears());
        byte days = (byte)(this.getCreatureAgeInDays() - 30 * this.getCreatureAgeInMonths());
        String yearString = " years, ";
        String monthString = " months, ";
        String dayString = " days";
        if (years <= 1) {
            yearString = " year, ";
        }
        if (months <= 1) {
            monthString = " month, ";
        }
        if (days <= 1) {
            dayString = " day";
        }
        if (years <= 0) {
            if (months <= 0) {
                return String.valueOf(days) + dayString;
            }
            return String.valueOf(months) + monthString + String.valueOf(days) + dayString;
        }
        if (months <= 0) {
            return String.valueOf(years) + yearString + String.valueOf(days) + dayString;
        }
        return String.valueOf(years) + yearString + String.valueOf(months) + monthString + String.valueOf(days) + dayString;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70627_aG() {
        return 200;
    }

    protected float func_70647_i() {
        return Float.valueOf(0.7f + 0.3f * this.getSizeGeneticQuality() + 0.3f * (float)(BygoneAgeMobsInformation.values()[this.getCreatureID()].getTimesOfGrowth() - this.getGrowthStage()) / (float)BygoneAgeMobsInformation.values()[this.getCreatureID()].getTimesOfGrowth()).floatValue();
    }

    protected float func_70599_aP() {
        return Float.valueOf(0.7f + 0.3f * (float)this.getGrowthStage() / (float)BygoneAgeMobsInformation.values()[this.getCreatureID()].getTimesOfGrowth()).floatValue();
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.getTotalTicksLived() > BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime()) {
            return (int)(1.0 + this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() / 4.0);
        }
        return (int)(1.0 + this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() * (double)this.getTotalTicksLived() / (double)(4 * BygoneAgeMobsInformation.values()[this.getCreatureID()].getFullGrowthTime()));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("TicksExisted", this.getTotalTicksLived());
        compound.func_74778_a("GeneticCode", this.getGeneticCode());
        compound.func_74776_a("HealthGeneticQuality", this.getHealthGeneticQuality());
        compound.func_74776_a("AttackGeneticQuality", this.getAttackGeneticQuality());
        compound.func_74776_a("SpeedGeneticQuality", this.getSpeedGeneticQuality());
        compound.func_74776_a("SizeGeneticQuality", this.getSizeGeneticQuality());
        compound.func_74757_a("Gender", this.getCreatureGender());
        compound.func_74774_a("Stage", this.getGrowthStage());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setTicksExisted(compound.func_74762_e("TicksExisted"));
        this.setGeneticCode(compound.func_74779_i("GeneticCode"));
        this.setHealthGeneticQuality(compound.func_74760_g("HealthGeneticQuality"));
        this.setAttackGeneticQuality(compound.func_74760_g("AttackGeneticQuality"));
        this.setSpeedGeneticQuality(compound.func_74760_g("SpeedGeneticQuality"));
        this.setSizeGeneticQuality(compound.func_74760_g("SizeGeneticQuality"));
        this.setCreatureGender(compound.func_74767_n("Gender"));
        this.setCreatureColor();
        this.resetGrowthStageList();
        this.setGrowthStage(compound.func_74771_c("Stage"));
        this.setCreatureScale();
        this.setCreatureLength();
        this.setCreatureHeight();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.field_70173_aa);
        buffer.writeFloat(this.healthGeneticQuality);
        buffer.writeFloat(this.attackGeneticQuality);
        buffer.writeFloat(this.speedGeneticQuality);
        buffer.writeFloat(this.sizeGeneticQuality);
        buffer.writeFloat(this.consideredAdult);
        buffer.writeFloat(this.bBoxXZ);
        buffer.writeFloat(this.bBoxY);
        buffer.writeBoolean(this.gender);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.field_70173_aa = additionalData.readInt();
        this.healthGeneticQuality = additionalData.readFloat();
        this.attackGeneticQuality = additionalData.readFloat();
        this.speedGeneticQuality = additionalData.readFloat();
        this.sizeGeneticQuality = additionalData.readFloat();
        this.consideredAdult = additionalData.readFloat();
        this.bBoxXZ = additionalData.readFloat();
        this.bBoxY = additionalData.readFloat();
        this.gender = additionalData.readBoolean();
        this.setCreatureSize();
    }
}

