/*
 * Decompiled with CFR 0.152.
 */
package com.rafamv.bygoneage.entity;

import com.rafamv.bygoneage.entity.EntityBygoneAgeTameable;
import com.rafamv.bygoneage.enums.BygoneAgeRidingInformation;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBygoneAgeRidable
extends EntityBygoneAgeTameable {
    private float prevRearingAmount;
    float mountingSpeed;

    public EntityBygoneAgeRidable(World world, byte id, float maxChildAge) {
        super(world, id, maxChildAge);
        this.setMountingSpeed(BygoneAgeRidingInformation.values()[this.getCreatureID()].getRidingSpeed());
    }

    public boolean isCreatureRidable() {
        return BygoneAgeRidingInformation.values()[this.getCreatureID()].isRidable();
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack playerItemStack = player.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K && playerItemStack != (ItemStack)null && BygoneAgeRidingInformation.isRidingItem(this.getCreatureID(), playerItemStack.func_77973_b())) {
            if (this.isCreatureRidable() && this.isTamed() && this.isCreatureAdult() && this.field_70153_n == null && player.func_70005_c_().equals(this.getOwnerName())) {
                this.setSitting(false);
                this.setRidingPlayer(player);
            } else if (!this.isCreatureRidable()) {
                player.func_145747_a((IChatComponent)new ChatComponentText("This creature is not ridable."));
            } else if (!this.isTamed()) {
                player.func_145747_a((IChatComponent)new ChatComponentText("This creature is not tamed yet."));
            } else if (!this.isCreatureAdult()) {
                player.func_145747_a((IChatComponent)new ChatComponentText("This creature is not an adult yet."));
            } else if (this.field_70153_n != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("There is someone already riding this creature."));
            }
        }
        return super.func_70085_c(player);
    }

    public float getMountingSpeed() {
        return this.mountingSpeed;
    }

    public void setMountingSpeed(float speed) {
        this.mountingSpeed = speed;
    }

    @Override
    public boolean func_110164_bC() {
        return !this.func_110167_bD() && !(this instanceof IMob) && this.isTamed();
    }

    public void setRidingPlayer(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_70078_a((Entity)this);
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.prevRearingAmount > 0.0f) {
            float f = MathHelper.func_76126_a((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f2 = 0.7f * this.prevRearingAmount;
            float f3 = 0.15f * this.prevRearingAmount;
            this.field_70153_n.func_70107_b(this.field_70165_t + (double)(f2 * f), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + (double)f3, this.field_70161_v - (double)(f2 * f1));
            if (this.field_70153_n instanceof EntityLivingBase) {
                ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    public void func_70612_e(float movementStrafing, float movementForward) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.field_70153_n).func_70694_bm() != (ItemStack)null && BygoneAgeRidingInformation.isRidingItem(this.getCreatureID(), ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77973_b())) {
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            float adjust = MathHelper.func_76142_g((float)(((EntityLivingBase)this.field_70153_n).field_70177_z - this.field_70177_z)) * 0.5f;
            if (adjust > 3.0f) {
                adjust = 3.0f;
            } else if (adjust < -3.0f) {
                adjust = -3.0f;
            }
            this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + adjust));
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            movementStrafing = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.4f * this.getMountingSpeed();
            movementForward = Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d() ? ((EntityLivingBase)this.field_70153_n).field_70701_bs * 0.5f * this.getMountingSpeed() : ((EntityLivingBase)this.field_70153_n).field_70701_bs * this.getMountingSpeed();
            if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && this.field_70122_E && !this.field_70703_bu && ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77960_j() < ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77958_k() - 20) {
                ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77964_b(((EntityPlayer)this.field_70153_n).func_70694_bm().func_77960_j() + 20);
                this.func_70664_aZ();
            }
            this.decreaseHeldItemDurability();
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(movementStrafing, movementForward);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(movementStrafing, movementForward);
        }
    }

    private void decreaseHeldItemDurability() {
        if (((EntityPlayer)this.field_70153_n).func_70694_bm().func_77960_j() > ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77958_k()) {
            --((EntityPlayer)this.field_70153_n).func_70694_bm().field_77994_a;
            if (((EntityPlayer)this.field_70153_n).func_70694_bm().field_77994_a <= 0) {
                ((EntityPlayer)this.field_70153_n).field_71071_by.func_70299_a(((EntityPlayer)this.field_70153_n).field_71071_by.field_70461_c, (ItemStack)null);
            }
        } else {
            ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77964_b(((EntityPlayer)this.field_70153_n).func_70694_bm().func_77960_j() + 1);
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean isInvulnerable(DamageSource damageSource) {
        Entity entity = damageSource.func_76346_g();
        return entity != null && (entity == this.field_70153_n || entity == this || entity == this.getOwner());
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("MountingSpeed", this.getMountingSpeed());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setMountingSpeed(compound.func_74760_g("MountingSpeed"));
    }
}

