/*
 * Decompiled with CFR 0.152.
 */
package com.rafamv.bygoneage.entity;

import com.rafamv.bygoneage.ai.BygoneAgeEntityAISit;
import com.rafamv.bygoneage.entity.EntityBygoneAgeAnimated;
import com.rafamv.bygoneage.enums.BygoneAgeMobsInformation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class EntityBygoneAgeTameable
extends EntityBygoneAgeAnimated
implements IEntityOwnable {
    protected BygoneAgeEntityAISit aiSit = new BygoneAgeEntityAISit(this);
    private static final int KEY_OWNER = 20;
    private static final int KEY_TAMED_BEHAVIOR = 21;

    public EntityBygoneAgeTameable(World world, byte id, float maxChildAge) {
        super(world, id, maxChildAge);
        this.setTamed(false);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)"");
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack heldItemStack = player.field_71071_by.func_70448_g();
        if (heldItemStack != null) {
            if (BygoneAgeMobsInformation.isFavoriteFood(this.getCreatureID(), heldItemStack.func_77973_b())) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --heldItemStack.field_77994_a;
                }
                if (heldItemStack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                this.func_70691_i(2.0f);
                if (!this.isTamed() && !this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        this.setTamed(true);
                        this.func_70778_a(null);
                        this.func_70624_b(null);
                        this.aiSit.setSitting(true);
                        this.setOwner(player.func_70005_c_());
                        this.playTameEffect(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        player.func_145747_a((IChatComponent)new ChatComponentText("You tamed this creature!"));
                        player.func_145747_a((IChatComponent)new ChatComponentText(BygoneAgeMobsInformation.values()[this.getCreatureID()].getCreatureName() + " is sitting."));
                    } else {
                        this.playTameEffect(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
            }
            return super.func_70085_c(player);
        }
        if (this.isTamed() && this.isOwner((Entity)player) && !this.field_70170_p.field_72995_K) {
            if (!this.isSitting()) {
                this.field_70703_bu = false;
                this.func_70778_a(null);
                this.func_70784_b(null);
                this.func_70624_b(null);
                this.aiSit.setSitting(true);
                this.setSitting(true);
                player.func_145747_a((IChatComponent)new ChatComponentText(BygoneAgeMobsInformation.values()[this.getCreatureID()].getCreatureName() + " is sitting."));
            } else {
                this.aiSit.setSitting(false);
                this.setSitting(false);
                player.func_145747_a((IChatComponent)new ChatComponentText(BygoneAgeMobsInformation.values()[this.getCreatureID()].getCreatureName() + " is not sitting anymore."));
            }
        }
        return super.func_70085_c(player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte flag) {
        if (flag == 7) {
            this.playTameEffect(true);
        } else if (flag == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(flag);
        }
    }

    protected void playTameEffect(boolean flag) {
        String s = "heart";
        if (!flag) {
            s = "smoke";
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(s, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    public boolean isTamed() {
        return (this.field_70180_af.func_75683_a(21) & 4) != 0;
    }

    public void setTamed(boolean shouldTame) {
        byte b0 = this.field_70180_af.func_75683_a(21);
        if (shouldTame) {
            this.field_70180_af.func_75692_b(21, (Object)((byte)(b0 | 4)));
        } else {
            this.field_70180_af.func_75692_b(21, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public BygoneAgeEntityAISit getAiSit() {
        return this.aiSit;
    }

    public boolean isSitting() {
        return (this.field_70180_af.func_75683_a(21) & 1) != 0;
    }

    public void setSitting(boolean shouldSit) {
        byte b0 = this.field_70180_af.func_75683_a(21);
        if (shouldSit) {
            this.field_70180_af.func_75692_b(21, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(21, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(20);
    }

    public void setOwner(String owner) {
        this.field_70180_af.func_75692_b(20, (Object)owner);
    }

    public boolean isOwner(Entity possibleOwner) {
        return possibleOwner == this.getOwner();
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.isTamed();
    }

    public boolean checkTarget(Entity target) {
        if (target != (Entity)null && target != this.getOwner()) {
            if (target instanceof EntityBygoneAgeTameable) {
                return ((EntityBygoneAgeTameable)target).getOwner() != this.getOwner();
            }
            return true;
        }
        return false;
    }

    public EntityLivingBase getOwner() {
        return this.field_70170_p.func_72924_a(this.getOwnerName());
    }

    public Team func_96124_cp() {
        EntityLivingBase owner;
        if (this.isTamed() && (owner = this.getOwner()) != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_142014_c(EntityLivingBase creature) {
        if (this.isTamed()) {
            EntityLivingBase owner = this.getOwner();
            if (creature == owner) {
                return true;
            }
            if (owner != null) {
                return owner.func_142014_c(creature);
            }
        }
        return super.func_142014_c(creature);
    }

    public String func_152113_b() {
        return null;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getOwnerName() == null) {
            compound.func_74778_a("Owner", "");
        } else {
            compound.func_74778_a("Owner", this.getOwnerName());
        }
        compound.func_74757_a("Sitting", this.isSitting());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        String s = compound.func_74779_i("Owner");
        if (s.length() > 0) {
            this.setOwner(s);
            this.setTamed(true);
        }
        this.aiSit.setSitting(compound.func_74767_n("Sitting"));
        this.setSitting(compound.func_74767_n("Sitting"));
    }
}

