/*
 * Decompiled with CFR 0.152.
 */
package com.rafamv.bygoneage.entity.test;

import com.rafamv.bygoneage.entity.EntityBygoneAgeTameable;
import com.rafamv.bygoneage.enums.BygoneAgeRidingInformation;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BACKUP_EntityBygoneAgeFlyingCreatureBestResultSoFar
extends EntityBygoneAgeTameable {
    private float prevRearingAmount;
    protected float flyingSpeed;
    private static final int MAX_TAKEOFF_TIME = 150;
    private static final int KEY_TAKEOFF_TIME = 22;

    public BACKUP_EntityBygoneAgeFlyingCreatureBestResultSoFar(World world, byte id, float maxChildAge) {
        super(world, id, maxChildAge);
        this.setFlyingSpeed();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)150);
    }

    protected void func_70069_a(float par1) {
    }

    public int getTakeoffTime() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void addValueToTakeoffTime(int time) {
        if (this.getTakeoffTime() + time < 150) {
            this.field_70180_af.func_75692_b(22, (Object)(this.getTakeoffTime() + time));
        } else {
            this.field_70180_af.func_75692_b(22, (Object)150);
        }
    }

    private void increseTakeoffTime() {
        if (this.getTakeoffTime() + 1 < 150) {
            this.field_70180_af.func_75692_b(22, (Object)(this.getTakeoffTime() + 1));
        } else {
            this.field_70180_af.func_75692_b(22, (Object)150);
        }
    }

    private void decreseTakeoffTime() {
        this.field_70180_af.func_75692_b(22, (Object)(this.getTakeoffTime() - 1));
    }

    private void setTakeoffTime(int time) {
        if (this.getTakeoffTime() < 150) {
            this.field_70180_af.func_75692_b(22, (Object)time);
        } else {
            this.field_70180_af.func_75692_b(22, (Object)150);
        }
    }

    private void resetTakeoffTime() {
        this.field_70180_af.func_75692_b(22, (Object)150);
    }

    public double getTakeoffProcess() {
        return (double)(150 - this.getTakeoffTime()) / 150.0;
    }

    public boolean isCreatureFlyable() {
        return BygoneAgeRidingInformation.values()[this.getCreatureID()].isRidable();
    }

    public float getFlyingSpeed() {
        return this.flyingSpeed;
    }

    private void setFlyingSpeed() {
        this.flyingSpeed = 1.0f;
    }

    public boolean isFlying() {
        return this.getTakeoffTime() < 0 && !this.field_70124_G && !this.field_70123_F && !this.field_70171_ac;
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack playerItemStack = player.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K && playerItemStack != (ItemStack)null && BygoneAgeRidingInformation.isRidingItem(this.getCreatureID(), playerItemStack.func_77973_b())) {
            if (this.isCreatureFlyable() && this.isTamed() && this.isCreatureAdult() && this.field_70153_n == null && player.func_70005_c_().equals(this.getOwnerName())) {
                this.setSitting(false);
                this.setRidingPlayer(player);
            } else if (!this.isCreatureFlyable()) {
                player.func_145747_a((IChatComponent)new ChatComponentText("This creature is not flyable."));
            } else if (!this.isTamed()) {
                player.func_145747_a((IChatComponent)new ChatComponentText("This creature is not tamed yet."));
            } else if (!this.isCreatureAdult()) {
                player.func_145747_a((IChatComponent)new ChatComponentText("This creature is not an adult yet."));
            } else if (this.field_70153_n != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("There is someone already riding this creature."));
            }
        }
        return super.func_70085_c(player);
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.prevRearingAmount > 0.0f) {
            float f = MathHelper.func_76126_a((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f2 = 0.7f * this.prevRearingAmount;
            float f3 = 0.15f * this.prevRearingAmount;
            this.field_70153_n.func_70107_b(this.field_70165_t + (double)(f2 * f), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + (double)f3, this.field_70161_v - (double)(f2 * f1));
            if (this.field_70153_n instanceof EntityLivingBase) {
                ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    @Override
    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.isTamed() && !this.isFlying();
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void setRidingPlayer(EntityPlayer player) {
        player.func_70078_a((Entity)this);
    }

    private boolean checkPlayerRidingItem(EntityPlayer player) {
        return player.func_70694_bm() != (ItemStack)null && BygoneAgeRidingInformation.isRidingItem(this.getCreatureID(), player.func_70694_bm().func_77973_b());
    }

    private void consumeHeldItem() {
    }

    private void handleRotationsOnFlight() {
        this.field_70138_W = 0.5f;
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        float adjustY = 0.0f;
        float adjustXZ = 0.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
            adjustXZ += 1.0f;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
            adjustXZ -= 1.0f;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
            adjustY -= 1.0f;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
            adjustY += 1.0f;
        }
        this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + adjustXZ));
        this.field_70125_A = MathHelper.func_76142_g((float)(this.field_70125_A + adjustY));
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    private void handleRotationsOnGround(boolean tryingToFly) {
        if (tryingToFly) {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            this.field_70177_z = this.field_70126_B;
            this.field_70125_A = this.field_70127_C;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            float adjust = MathHelper.func_76142_g((float)(((EntityLivingBase)this.field_70153_n).field_70177_z - this.field_70177_z)) * 0.5f;
            if (adjust > 3.0f) {
                adjust = 3.0f;
            } else if (adjust < -3.0f) {
                adjust = -3.0f;
            }
            this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + adjust));
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private void handleMovementOnFlight(float movementForward, float movementStrafing) {
        this.field_70181_x = -0.005;
    }

    private void handleMovementOnGround(float movementForward, float movementStrafing, boolean tryingToFly) {
        if (tryingToFly) {
            if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
                this.decreseTakeoffTime();
                if ((double)this.getTakeoffTime() < 0.5 * 150.0) {
                    this.field_70181_x = 0.1 * Math.pow(2.0 * this.getTakeoffProcess(), 3.0) / (Math.pow(2.0 * this.getTakeoffProcess(), 5.0) + 0.18);
                }
            }
        } else {
            this.addValueToTakeoffTime(2);
            this.field_70181_x = -0.08;
        }
    }

    private void handleLimbMovement() {
        this.field_70722_aY = this.field_70721_aZ;
        double point1 = this.field_70165_t - this.field_70169_q;
        double point2 = this.field_70161_v - this.field_70166_s;
        float distance = MathHelper.func_76133_a((double)(point1 * point1 + point2 * point2)) * 4.0f;
        if (distance > 1.0f) {
            distance = 1.0f;
        }
        this.field_70721_aZ += (distance - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public void func_70612_e(float movementStrafing, float movementForward) {
        System.out.println("=========================================================================================================================================================");
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            EntityPlayer playerFlying = (EntityPlayer)this.field_70153_n;
            if (playerFlying.func_70694_bm() != (ItemStack)null && BygoneAgeRidingInformation.isRidingItem(this.getCreatureID(), playerFlying.func_70694_bm().func_77973_b())) {
                if (this.isFlying()) {
                    if (this.field_70170_p.field_72995_K) {
                        System.out.println("Client: Flying " + this.getTakeoffTime() + " this.isFlying(): " + this.isFlying() + " this.isCollidedVertically: " + this.field_70124_G + " this.onGround: " + this.field_70122_E + " this.inWater: " + this.field_70171_ac);
                    } else {
                        System.out.println("Server: Flying " + this.getTakeoffTime() + " this.isFlying(): " + this.isFlying() + " this.isCollidedVertically: " + this.field_70124_G + " this.onGround: " + this.field_70122_E + " this.inWater: " + this.field_70171_ac);
                    }
                    this.decreseTakeoffTime();
                    this.handleRotationsOnFlight();
                    this.handleMovementOnFlight(movementForward, movementStrafing);
                    movementForward = 1.0f + this.getFlyingSpeed();
                    movementStrafing = 0.0f;
                    if (!this.checkPlayerRidingItem(playerFlying)) {
                        this.field_70181_x = -0.08;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                        super.func_70612_e(movementStrafing, movementForward);
                    }
                    this.handleLimbMovement();
                } else if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && !this.isFlying()) {
                    if (this.field_70170_p.field_72995_K) {
                        System.out.println("Client: Trying Flying " + this.getTakeoffTime() + " this.isFlying(): " + this.isFlying() + " this.isCollidedVertically: " + this.field_70124_G + " this.onGround: " + this.field_70122_E + " this.inWater: " + this.field_70171_ac);
                    } else {
                        System.out.println("Server: Trying Flying " + this.getTakeoffTime() + " this.isFlying(): " + this.isFlying() + " this.isCollidedVertically: " + this.field_70124_G + " this.onGround: " + this.field_70122_E + " this.inWater: " + this.field_70171_ac);
                    }
                    this.field_70703_bu = false;
                    this.handleRotationsOnGround(true);
                    this.handleMovementOnGround(movementForward, movementStrafing, true);
                    movementForward = (float)(((double)(playerFlying.field_70701_bs * 0.5f * this.getFlyingSpeed()) + 1.0 * this.getTakeoffProcess()) * (double)this.getFlyingSpeed());
                    movementStrafing = 0.0f;
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_70612_e(movementStrafing, movementForward);
                    this.handleLimbMovement();
                } else {
                    if (this.field_70170_p.field_72995_K) {
                        System.out.println("Client: Walking " + this.getTakeoffTime() + " this.isFlying(): " + this.isFlying() + " this.isCollidedVertically: " + this.field_70124_G + " this.onGround: " + this.field_70122_E + " this.inWater: " + this.field_70171_ac);
                    } else {
                        System.out.println("Server: Walking " + this.getTakeoffTime() + " this.isFlying(): " + this.isFlying() + " this.isCollidedVertically: " + this.field_70124_G + " this.onGround: " + this.field_70122_E + " this.inWater: " + this.field_70171_ac);
                    }
                    this.resetTakeoffTime();
                    this.handleRotationsOnGround(false);
                    this.handleMovementOnGround(movementForward, movementStrafing, false);
                    movementForward = playerFlying.field_70701_bs * 0.5f * this.getFlyingSpeed();
                    movementStrafing = playerFlying.field_70702_br * 0.125f * this.getFlyingSpeed();
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                        super.func_70612_e(movementStrafing, movementForward);
                    }
                    this.handleLimbMovement();
                }
            }
        } else if (this.isFlying()) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
                EntityPlayer playerFlying = (EntityPlayer)this.field_70153_n;
                if (this.field_70170_p.field_72995_K) {
                    System.out.println("Client: Falling smoothly " + this.getTakeoffTime() + " this.isFlying(): " + this.isFlying() + " this.isCollidedVertically: " + this.field_70124_G + " this.onGround: " + this.field_70122_E + " this.inWater: " + this.field_70171_ac);
                } else {
                    System.out.println("Server: Falling smoothly " + this.getTakeoffTime() + " this.isFlying(): " + this.isFlying() + " this.isCollidedVertically: " + this.field_70124_G + " this.onGround: " + this.field_70122_E + " this.inWater: " + this.field_70171_ac);
                }
                this.resetTakeoffTime();
                this.handleRotationsOnGround(false);
                this.handleMovementOnGround(movementForward, movementStrafing, false);
                movementForward = playerFlying.field_70701_bs * 0.5f * this.getFlyingSpeed();
                movementStrafing = playerFlying.field_70702_br * 0.125f * this.getFlyingSpeed();
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_70612_e(movementStrafing, movementForward);
                }
                this.handleLimbMovement();
            } else {
                System.out.println("Normal behavior - this.riddenByEntity: " + this.field_70153_n + " this.ridingEntity: " + this.field_70154_o);
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                this.resetTakeoffTime();
                super.func_70612_e(movementStrafing, movementForward);
            }
        } else {
            System.out.println("Normal behavior - this.riddenByEntity: " + this.field_70153_n + " this.ridingEntity: " + this.field_70154_o);
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            this.resetTakeoffTime();
            super.func_70612_e(movementStrafing, movementForward);
        }
    }

    public boolean isInvulnerable(DamageSource damageSource) {
        Entity entity = damageSource.func_76346_g();
        return entity != null && (entity == this.field_70153_n || entity == this || entity == this.getOwner());
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("TakeoffTime", this.getTakeoffTime());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setTakeoffTime(compound.func_74762_e("TakeoffTime"));
        this.setFlyingSpeed();
    }
}

