/*
 * Decompiled with CFR 0.152.
 */
package com.rafamv.bygoneage.handler;

import com.rafamv.bygoneage.entity.EntityBygoneAgeCreature;
import com.rafamv.bygoneage.enums.BygoneAgeGeneticsInformation;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;

public class BygoneAgeDNAHandler {
    private static Random random = new Random();

    public static String createNewRNAFrom(String oldRNA) {
        String newRNA = "";
        block6: for (int i = 0; i < oldRNA.length(); ++i) {
            switch (oldRNA.charAt(i)) {
                case 'A': {
                    newRNA = newRNA + "T";
                    continue block6;
                }
                case 'C': {
                    newRNA = newRNA + "G";
                    continue block6;
                }
                case 'G': {
                    newRNA = newRNA + "C";
                    continue block6;
                }
                case 'T': {
                    newRNA = newRNA + "A";
                    continue block6;
                }
                default: {
                    newRNA = newRNA + "(WRONGSEQUENCE)";
                }
            }
        }
        if (newRNA.length() != oldRNA.length()) {
            newRNA = "AAAAAAAAAAAAAAAAAA";
        }
        return newRNA;
    }

    public static String generateNewRNA(int size) {
        String newRNA = "";
        block6: for (int i = 0; i < size; ++i) {
            int rand = random.nextInt(4);
            switch (rand) {
                case 0: {
                    newRNA = newRNA + "A";
                    continue block6;
                }
                case 1: {
                    newRNA = newRNA + "C";
                    continue block6;
                }
                case 2: {
                    newRNA = newRNA + "G";
                    continue block6;
                }
                case 3: {
                    newRNA = newRNA + "T";
                    continue block6;
                }
                default: {
                    newRNA = newRNA + "(WRONGSEQUENCE)";
                }
            }
        }
        if (newRNA.length() != size) {
            newRNA = "AAAAAAAAAAAAAAAAAA";
        }
        return newRNA;
    }

    public static float calculateDNAQuality(String rna1, String rna2) {
        int i;
        float valueRNA1 = 0.0f;
        float valueRNA2 = 0.0f;
        float finalValue = 0.0f;
        block12: for (i = 0; i < rna1.length(); ++i) {
            switch (rna1.charAt(i)) {
                case 'A': {
                    valueRNA1 += 0.45f;
                    continue block12;
                }
                case 'C': {
                    valueRNA1 += 0.7f;
                    continue block12;
                }
                case 'G': {
                    valueRNA1 += 1.2f;
                    continue block12;
                }
                case 'T': {
                    valueRNA1 += 1.5f;
                }
            }
        }
        block13: for (i = 0; i < rna2.length(); ++i) {
            switch (rna2.charAt(i)) {
                case 'A': {
                    valueRNA2 += 0.6f;
                    continue block13;
                }
                case 'C': {
                    valueRNA2 += 0.45f;
                    continue block13;
                }
                case 'G': {
                    valueRNA2 += 1.3f;
                    continue block13;
                }
                case 'T': {
                    valueRNA1 = valueRNA2 + 1.4f;
                }
            }
        }
        finalValue = Float.valueOf(valueRNA1 / (float)rna1.length() + valueRNA2 / (float)rna2.length()).floatValue();
        return Float.valueOf(finalValue *= 0.7f + 0.2f * (valueRNA1 / valueRNA2) + 0.1f * random.nextFloat()).floatValue();
    }

    public static String getAnimalName(EntityLivingBase entity) {
        if (entity instanceof EntityBygoneAgeCreature) {
            return ((EntityBygoneAgeCreature)entity).getCreatureName();
        }
        if (entity instanceof EntityChicken) {
            return BygoneAgeGeneticsInformation.CHICKEN.getCreatureName();
        }
        if (entity instanceof EntitySheep) {
            return BygoneAgeGeneticsInformation.SHEEP.getCreatureName();
        }
        if (entity instanceof EntityPig) {
            return BygoneAgeGeneticsInformation.PIG.getCreatureName();
        }
        if (entity instanceof EntityCow) {
            return BygoneAgeGeneticsInformation.COW.getCreatureName();
        }
        return "THIS IS A BUG, PLEASE REPORT TO THE MOD DEVELOPER!";
    }

    public static String getRandomAnimalNameForDNA() {
        String name = BygoneAgeGeneticsInformation.CREATURELIST.get((byte)(4 + random.nextInt(BygoneAgeGeneticsInformation.CREATURELIST.size())));
        if (name == null) {
            return "THIS IS A BUG, PLEASE REPORT TO THE MOD DEV!";
        }
        return name;
    }
}

