/*
 * Decompiled with CFR 0.152.
 */
package com.rafamv.bygoneage.tileentity;

import com.rafamv.bygoneage.enums.BygoneAgeFossilDrops;
import com.rafamv.bygoneage.enums.BygoneAgeGeneticsInformation;
import com.rafamv.bygoneage.handler.BygoneAgeDNAHandler;
import com.rafamv.bygoneage.items.dnaitems.AnyDNASource;
import com.rafamv.bygoneage.items.dnaitems.EmptyVial;
import com.rafamv.bygoneage.registry.BygoneAgeItems;
import com.rafamv.bygoneage.tileentity.TileEntityWithRotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityDNAExtractor
extends TileEntityWithRotations
implements ISidedInventory,
IInventory {
    private ItemStack[] slots = new ItemStack[9];
    private static final short analyzeSpeed = 100;
    private short analyzeTime = 0;

    public short getAnalyzeTime() {
        return this.analyzeTime;
    }

    public void setAnalyzeTime(short time) {
        this.analyzeTime = time;
    }

    public int getAnalyzeTimeProgressScaled(int i) {
        return this.analyzeTime * i / 100;
    }

    public boolean isAnalyzing() {
        return this.analyzeTime > 0;
    }

    private boolean canAnalyze() {
        if (this.slots[8] == null || !(this.slots[8].func_77973_b() instanceof EmptyVial)) {
            return false;
        }
        if (this.slots[0] == (ItemStack)null && this.slots[1] == (ItemStack)null && this.slots[2] == (ItemStack)null && this.slots[3] == (ItemStack)null) {
            return false;
        }
        if (this.slots[4] != (ItemStack)null && this.slots[5] != (ItemStack)null && this.slots[6] != (ItemStack)null && this.slots[7] != (ItemStack)null) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.slots[i] == (ItemStack)null) continue;
            if (this.slots[i].func_77973_b() instanceof AnyDNASource) {
                if (!this.slots[i].func_77942_o() || !this.slots[i].func_77978_p().func_74764_b("CreatureName")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void analyzeItem() {
        for (int i = 0; i < 4; ++i) {
            if (this.slots[i] == (ItemStack)null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            Byte[] possibleCreaturesID = BygoneAgeFossilDrops.getDropFromFossil(this.slots[i].func_77973_b());
            String creatureName = BygoneAgeGeneticsInformation.values()[possibleCreaturesID[this.field_145850_b.field_73012_v.nextInt(possibleCreaturesID.length)]].getCreatureName();
            if (creatureName == null) {
                System.out.println("DNA Extractor fail! Null creature name or id.");
                creatureName = BygoneAgeDNAHandler.getRandomAnimalNameForDNA();
            }
            if (!this.slots[i].func_77942_o()) {
                compound.func_74778_a("CreatureName", creatureName);
                compound.func_74778_a("RNAHelix1", BygoneAgeDNAHandler.generateNewRNA(18));
                compound.func_74778_a("RNAHelix2", BygoneAgeDNAHandler.createNewRNAFrom(compound.func_74779_i("RNAHelix1")));
            } else {
                if (!this.slots[i].func_77978_p().func_74764_b("CreatureName")) {
                    compound.func_74778_a("CreatureName", creatureName);
                }
                if (!this.slots[i].func_77978_p().func_74764_b("RNAHelix1") && !this.slots[i].func_77978_p().func_74764_b("RNAHelix2")) {
                    compound.func_74778_a("RNAHelix1", BygoneAgeDNAHandler.generateNewRNA(18));
                    compound.func_74778_a("RNAHelix2", BygoneAgeDNAHandler.createNewRNAFrom(compound.func_74779_i("RNAHelix1")));
                } else if (this.slots[i].func_77978_p().func_74764_b("RNAHelix1") && this.slots[i].func_77978_p().func_74764_b("RNAHelix2")) {
                    compound.func_74778_a("RNAHelix1", this.slots[i].func_77978_p().func_74779_i("RNAHelix1"));
                    compound.func_74778_a("RNAHelix2", this.slots[i].func_77978_p().func_74779_i("RNAHelix2"));
                } else if (this.slots[i].func_77978_p().func_74764_b("RNAHelix1") && !this.slots[i].func_77978_p().func_74764_b("RNAHelix2")) {
                    compound.func_74778_a("RNAHelix1", this.slots[i].func_77978_p().func_74779_i("RNAHelix1"));
                    compound.func_74778_a("RNAHelix2", BygoneAgeDNAHandler.createNewRNAFrom(compound.func_74779_i("RNAHelix1")));
                } else if (!this.slots[i].func_77978_p().func_74764_b("RNAHelix1") && this.slots[i].func_77978_p().func_74764_b("RNAHelix2")) {
                    compound.func_74778_a("RNAHelix2", this.slots[i].func_77978_p().func_74779_i("RNAHelix2"));
                    compound.func_74778_a("RNAHelix1", BygoneAgeDNAHandler.createNewRNAFrom(compound.func_74779_i("RNAHelix2")));
                }
            }
            ItemStack newItem = new ItemStack(BygoneAgeItems.dnaSample);
            newItem.func_77982_d(compound);
            for (int j = 4; j < 8; ++j) {
                if (this.slots[j] != (ItemStack)null) continue;
                --this.slots[i].field_77994_a;
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = null;
                }
                --this.slots[8].field_77994_a;
                if (this.slots[8].field_77994_a <= 0) {
                    this.slots[8] = null;
                }
                this.slots[j] = newItem;
                return;
            }
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canAnalyze()) {
                this.analyzeTime = (short)(this.analyzeTime + 1);
                if (this.analyzeTime >= 100) {
                    this.analyzeTime = 0;
                    this.analyzeItem();
                }
            } else {
                this.analyzeTime = 0;
            }
        }
    }

    public boolean hasItems() {
        return this.slots[0] != null || this.slots[1] != null || this.slots[2] != null || this.slots[3] != null || this.slots[4] != null || this.slots[5] != null || this.slots[6] != null || this.slots[7] != null || this.slots[8] != null;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int stackSize) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= stackSize) {
                ItemStack splitedStack = this.slots[i];
                this.slots[i] = null;
                return splitedStack;
            }
            ItemStack splitedStack = this.slots[i].func_77979_a(stackSize);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return splitedStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "DNA Extractor";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public int[] func_94128_d(int i) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte k = compound.func_74771_c("Slot");
            if (k < 0 || k >= this.slots.length) continue;
            this.slots[k] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.analyzeTime = nbt.func_74765_d("AnalyzeTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("AnalyzeTime", this.analyzeTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }
}

