/*
 * Decompiled with CFR 0.152.
 */
package com.rafamv.bygoneage.tileentity;

import com.rafamv.bygoneage.entity.EntityBygoneAgeCreature;
import com.rafamv.bygoneage.entity.EntityBygoneAgeTameable;
import com.rafamv.bygoneage.entity.creatures.EntityArsinoitherium;
import com.rafamv.bygoneage.entity.creatures.EntityBasilosaurus;
import com.rafamv.bygoneage.entity.creatures.EntityDeinotherium;
import com.rafamv.bygoneage.entity.creatures.EntityLeptictidium;
import com.rafamv.bygoneage.entity.creatures.EntityMammoth;
import com.rafamv.bygoneage.entity.creatures.EntityMoeritherium;
import com.rafamv.bygoneage.entity.creatures.EntityTitanisWalleri;
import com.rafamv.bygoneage.entity.creatures.EntityUintatherium;
import com.rafamv.bygoneage.enums.BygoneAgeFoodInformation;
import com.rafamv.bygoneage.enums.BygoneAgeGeneticsInformation;
import com.rafamv.bygoneage.enums.BygoneAgeMobsInformation;
import com.rafamv.bygoneage.handler.BygoneAgeDNAHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityHatchery
extends TileEntity
implements ISidedInventory,
IInventory {
    private Random random;
    private ItemStack[] slots = new ItemStack[8];
    private short hatcheryTime = 0;
    private short hatcherySpeed;
    private byte embryoStage = 0;
    private byte creatureID;
    private byte waterStored = 0;
    private short proximateValue = 0;
    private short mineralValue = 0;
    private short vitaminValue = 0;
    private short lipidValue = 0;
    private final short maxValue = (short)3000;
    public final Map<Short, Byte> growthRateList = new HashMap<Short, Byte>();
    private float creatureSize = 0.0f;
    private boolean shouldUpdate;

    public TileEntityHatchery() {
        this.random = new Random();
        this.hatcherySpeed = (short)100;
        this.creatureID = (byte)-1;
    }

    public byte getEmbryoID() {
        return this.creatureID;
    }

    public void setHatcheryTime(short time) {
        this.hatcheryTime = time;
    }

    public int getHatcheryTime() {
        return this.hatcheryTime;
    }

    public float getCreatureSize() {
        return this.creatureSize;
    }

    public void setCreatureSize(float time, float speed) {
        this.creatureSize = speed > 0.0f ? time / speed : 0.0f;
    }

    public void setEmbryoStage(short time) {
        this.embryoStage = this.growthRateList.get(time);
    }

    public byte getEmbryoStage() {
        return this.embryoStage;
    }

    public byte getWaterStored() {
        return this.waterStored;
    }

    public boolean hasWater() {
        return this.waterStored > 0;
    }

    public int getProximateValue() {
        return this.proximateValue;
    }

    public boolean hasProximate() {
        return this.proximateValue > 0;
    }

    public int getMineralValue() {
        return this.mineralValue;
    }

    public boolean hasMineral() {
        return this.mineralValue > 0;
    }

    public int getVitaminValue() {
        return this.vitaminValue;
    }

    public boolean hasVitamin() {
        return this.vitaminValue > 0;
    }

    public int getLipidValue() {
        return this.lipidValue;
    }

    public boolean hasLipid() {
        return this.lipidValue > 0;
    }

    public void setWaterStored(byte water) {
        this.waterStored = water;
    }

    public void setProximateValue(short proximate) {
        this.proximateValue = proximate;
    }

    public void setMineralValue(short mineral) {
        this.mineralValue = mineral;
    }

    public void setVitaminValue(short vitamin) {
        this.vitaminValue = vitamin;
    }

    public void setLipidValue(short lipid) {
        this.lipidValue = lipid;
    }

    public int getWaterStoredProgressScaled(int i) {
        return this.waterStored * i / 3;
    }

    public int getHatcheryTimeProgressScaled(int i) {
        if (this.hatcherySpeed <= 0) {
            this.hatcherySpeed = (short)100;
        }
        return this.hatcheryTime * i / this.hatcherySpeed;
    }

    public int getProximateBarScaled(int i) {
        return this.proximateValue * i / this.maxValue;
    }

    public int getMineralBarScaled(int i) {
        return this.mineralValue * i / this.maxValue;
    }

    public int getVitaminBarScaled(int i) {
        return this.vitaminValue * i / this.maxValue;
    }

    public int getLipidBarScaled(int i) {
        return this.lipidValue * i / this.maxValue;
    }

    public boolean isHatching() {
        return this.hatcheryTime > 0;
    }

    private boolean canCansumeWaterBucket() {
        if (this.slots[0] != (ItemStack)null && this.slots[0].func_77973_b() == Items.field_151131_as) {
            if (this.slots[1] == (ItemStack)null) {
                return true;
            }
            if (this.slots[1].func_77973_b() == Items.field_151133_ar) {
                return true;
            }
        }
        return false;
    }

    private void consumeWaterBucket() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getWaterStored() + 1 > 3) {
                return;
            }
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            this.setWaterStored((byte)(this.getWaterStored() + 1));
            if (this.slots[1] == (ItemStack)null) {
                ItemStack waterBucket;
                this.slots[1] = waterBucket = new ItemStack(Items.field_151133_ar);
            } else {
                ++this.slots[1].field_77994_a;
            }
        }
    }

    private boolean canCansumeFood() {
        if (this.slots[7] == (ItemStack)null) {
            return false;
        }
        return (this.proximateValue < 3000 || this.mineralValue < 3000 || this.vitaminValue < 3000 || this.lipidValue < 3000) && BygoneAgeFoodInformation.FOODLIST.containsKey(this.slots[7].func_77973_b());
    }

    private void consumeFood() {
        if (!this.field_145850_b.field_72995_K) {
            int id = BygoneAgeFoodInformation.FOODLIST.get(this.slots[7].func_77973_b());
            if (this.slots[7].func_77973_b() instanceof ItemBucketMilk) {
                this.slots[7] = null;
                this.slots[7] = new ItemStack(Items.field_151133_ar);
            } else {
                --this.slots[7].field_77994_a;
                if (this.slots[7].field_77994_a <= 0) {
                    this.slots[7] = null;
                }
            }
            if (this.proximateValue < 3000) {
                this.proximateValue = (short)((double)this.proximateValue + (double)(800 + this.random.nextInt(201)) * BygoneAgeFoodInformation.values()[id].getProximateValueFrom());
                if (this.proximateValue > 3000) {
                    this.proximateValue = (short)3000;
                }
            }
            if (this.mineralValue < 3000) {
                this.mineralValue = (short)((double)this.mineralValue + (double)(900 + this.random.nextInt(101)) * BygoneAgeFoodInformation.values()[id].getMineralValueFrom());
                if (this.mineralValue > 3000) {
                    this.mineralValue = (short)3000;
                }
            }
            if (this.vitaminValue < 3000) {
                this.vitaminValue = (short)((double)this.vitaminValue + (double)(900 + this.random.nextInt(101)) * BygoneAgeFoodInformation.values()[id].getVitaminValueFrom());
                if (this.vitaminValue > 3000) {
                    this.vitaminValue = (short)3000;
                }
            }
            if (this.lipidValue < 3000) {
                this.lipidValue = (short)((double)this.lipidValue + (double)(980 + this.random.nextInt(101)) * BygoneAgeFoodInformation.values()[id].getLipidValueFrom());
                if (this.lipidValue > 3000) {
                    this.lipidValue = (short)3000;
                }
            }
        }
    }

    private boolean canHatch() {
        if (this.slots[2] != null && this.slots[3] != null && this.slots[4] != null && this.slots[5] != null && this.slots[6] != null && this.slots[3].func_77942_o() && this.slots[4].func_77942_o() && this.slots[5].func_77942_o() && this.slots[6].func_77942_o() && this.slots[2].func_77978_p().func_74764_b("CreatureName") && this.slots[3].func_77978_p().func_74764_b("CreatureName") && this.slots[4].func_77978_p().func_74764_b("CreatureName") && this.slots[5].func_77978_p().func_74764_b("CreatureName") && this.slots[6].func_77978_p().func_74764_b("CreatureName") && this.slots[2].func_77978_p().func_74764_b("Centrifugated") && this.slots[3].func_77978_p().func_74764_b("Centrifugated") && this.slots[4].func_77978_p().func_74764_b("Centrifugated") && this.slots[5].func_77978_p().func_74764_b("Centrifugated") && this.slots[6].func_77978_p().func_74764_b("Centrifugated") && this.slots[2].func_77978_p().func_74764_b("RNAHelix1") && this.slots[3].func_77978_p().func_74764_b("RNAHelix1") && this.slots[4].func_77978_p().func_74764_b("RNAHelix1") && this.slots[5].func_77978_p().func_74764_b("RNAHelix1") && this.slots[6].func_77978_p().func_74764_b("RNAHelix1") && this.slots[2].func_77978_p().func_74764_b("RNAHelix2") && this.slots[3].func_77978_p().func_74764_b("RNAHelix2") && this.slots[4].func_77978_p().func_74764_b("RNAHelix2") && this.slots[5].func_77978_p().func_74764_b("RNAHelix2") && this.slots[6].func_77978_p().func_74764_b("RNAHelix2")) {
            HashSet<String> dnaNames = new HashSet<String>();
            String dnaMotherCreature = "";
            String dnaMother = this.slots[2].func_77978_p().func_74779_i("CreatureName");
            for (int i = 0; i < 4; ++i) {
                dnaNames.add(this.slots[3 + i].func_77978_p().func_74779_i("CreatureName"));
            }
            if (dnaNames.size() != 1) {
                return false;
            }
            dnaMotherCreature = BygoneAgeGeneticsInformation.MOTHERDNALIST.get(dnaNames.toString().substring(1, dnaNames.toString().length() - 1));
            this.creatureID = BygoneAgeGeneticsInformation.CREATUREDNALIST.get(dnaNames.toString().substring(1, dnaNames.toString().length() - 1));
            if (dnaMother.equals(dnaMotherCreature) || dnaMother.equals(dnaNames.toString().substring(1, dnaNames.toString().length() - 1))) {
                if (this.proximateValue < BygoneAgeGeneticsInformation.values()[this.creatureID].getMinimumProximate()) {
                    return false;
                }
                if (this.mineralValue < BygoneAgeGeneticsInformation.values()[this.creatureID].getMinimumMinerals()) {
                    return false;
                }
                if (this.vitaminValue < BygoneAgeGeneticsInformation.values()[this.creatureID].getMinimumvitamins()) {
                    return false;
                }
                return this.lipidValue >= BygoneAgeGeneticsInformation.values()[this.creatureID].getMinimumLipids();
            }
        }
        return false;
    }

    private void hatchCreature() {
        if (!this.canHatch()) {
            return;
        }
        if (this.slots[3].func_77942_o() && this.slots[3].func_77978_p().func_74764_b("CreatureName")) {
            String creatureName = this.slots[3].func_77978_p().func_74779_i("CreatureName");
            if (creatureName.equals(BygoneAgeGeneticsInformation.CHICKEN.getCreatureName()) || creatureName.equals(BygoneAgeGeneticsInformation.SHEEP.getCreatureName()) || creatureName.equals(BygoneAgeGeneticsInformation.PIG.getCreatureName()) || creatureName.equals(BygoneAgeGeneticsInformation.COW.getCreatureName())) {
                EntityLiving creatureVanilla = (EntityLiving)this.selectCreatureVanilla(this.field_145850_b);
                this.selectValidPosition((Entity)creatureVanilla);
                creatureVanilla.field_70759_as = creatureVanilla.field_70177_z;
                creatureVanilla.field_70761_aq = creatureVanilla.field_70177_z;
                this.field_145850_b.func_72838_d((Entity)creatureVanilla);
                creatureVanilla.func_70642_aH();
            } else {
                EntityBygoneAgeCreature creature = this.selectCreatureBygoneAge(this.field_145850_b);
                this.selectValidPosition((Entity)creature);
                creature.field_70759_as = creature.field_70177_z;
                creature.field_70761_aq = creature.field_70177_z;
                this.field_145850_b.func_72838_d((Entity)creature);
                creature.func_70642_aH();
            }
        }
        this.setHatcheryTime((short)0);
        this.setWaterStored((byte)0);
        this.proximateValue = (short)(this.proximateValue - BygoneAgeGeneticsInformation.values()[this.creatureID].getMinimumProximate());
        this.mineralValue = (short)(this.mineralValue - BygoneAgeGeneticsInformation.values()[this.creatureID].getMinimumMinerals());
        this.vitaminValue = (short)(this.vitaminValue - BygoneAgeGeneticsInformation.values()[this.creatureID].getMinimumvitamins());
        this.lipidValue = (short)(this.lipidValue - BygoneAgeGeneticsInformation.values()[this.creatureID].getMinimumLipids());
        for (int i = 2; i < 7; ++i) {
            --this.slots[i].field_77994_a;
            if (this.slots[i].field_77994_a > 0) continue;
            this.slots[i] = null;
        }
    }

    private Entity selectCreatureVanilla(World world) {
        Object creature = null;
        String mobName = this.slots[2].func_77978_p().func_74779_i("CreatureName");
        creature = mobName.equals(BygoneAgeGeneticsInformation.CHICKEN.getCreatureName()) ? new EntityChicken(world) : (mobName.equals(BygoneAgeGeneticsInformation.SHEEP.getCreatureName()) ? new EntitySheep(world) : (mobName.equals(BygoneAgeGeneticsInformation.PIG.getCreatureName()) ? new EntityPig(world) : (mobName.equals(BygoneAgeGeneticsInformation.COW.getCreatureName()) ? new EntityCow(world) : new EntityChicken(world))));
        return creature;
    }

    private EntityBygoneAgeCreature selectCreatureBygoneAge(World world) {
        EntityBygoneAgeTameable creature = null;
        float dnaQualityMother = BygoneAgeDNAHandler.calculateDNAQuality(this.slots[2].func_77978_p().func_74779_i("RNAHelix1"), this.slots[2].func_77978_p().func_74779_i("RNAHelix2"));
        float dnaQualityCreature1 = BygoneAgeDNAHandler.calculateDNAQuality(this.slots[3].func_77978_p().func_74779_i("RNAHelix1"), this.slots[3].func_77978_p().func_74779_i("RNAHelix2"));
        float dnaQualityCreature2 = BygoneAgeDNAHandler.calculateDNAQuality(this.slots[4].func_77978_p().func_74779_i("RNAHelix1"), this.slots[4].func_77978_p().func_74779_i("RNAHelix2"));
        float dnaQualityCreature3 = BygoneAgeDNAHandler.calculateDNAQuality(this.slots[5].func_77978_p().func_74779_i("RNAHelix1"), this.slots[5].func_77978_p().func_74779_i("RNAHelix2"));
        float dnaQualityCreature4 = BygoneAgeDNAHandler.calculateDNAQuality(this.slots[6].func_77978_p().func_74779_i("RNAHelix1"), this.slots[6].func_77978_p().func_74779_i("RNAHelix2"));
        float dnaMother = this.mixDNAQualities(dnaQualityMother, 6, dnaQualityCreature1, 1, dnaQualityCreature2, 1, dnaQualityCreature3, 1, dnaQualityCreature4, 1);
        float dna1 = this.mixDNAQualities(dnaQualityMother, 2, dnaQualityCreature1, 5, dnaQualityCreature2, 2, dnaQualityCreature3, 2, dnaQualityCreature4, 2);
        float dna2 = this.mixDNAQualities(dnaQualityMother, 2, dnaQualityCreature1, 2, dnaQualityCreature2, 5, dnaQualityCreature3, 2, dnaQualityCreature4, 2);
        float dna3 = this.mixDNAQualities(dnaQualityMother, 2, dnaQualityCreature1, 2, dnaQualityCreature2, 2, dnaQualityCreature3, 5, dnaQualityCreature4, 2);
        float dna4 = this.mixDNAQualities(dnaQualityMother, 2, dnaQualityCreature1, 2, dnaQualityCreature2, 2, dnaQualityCreature3, 2, dnaQualityCreature4, 5);
        float rand = 1.0f;
        rand = 0.8f + 0.2f * this.random.nextFloat();
        dna1 *= rand + dnaMother * (1.0f - rand);
        rand = 0.8f + 0.2f * this.random.nextFloat();
        dna2 *= rand + dnaMother * (1.0f - rand);
        rand = 0.8f + 0.2f * this.random.nextFloat();
        dna3 *= rand + dnaMother * (1.0f - rand);
        rand = 0.8f + 0.2f * this.random.nextFloat();
        String mobName = BygoneAgeMobsInformation.values()[this.creatureID].getCreatureName();
        creature = mobName == BygoneAgeMobsInformation.LEPTICTIDIUM.getCreatureName() ? new EntityLeptictidium(world) : (mobName == BygoneAgeMobsInformation.MOERITHERIUM.getCreatureName() ? new EntityMoeritherium(world) : (mobName == BygoneAgeMobsInformation.UINTATHERIUM.getCreatureName() ? new EntityUintatherium(world) : (mobName == BygoneAgeMobsInformation.ARSINOITHERIUM.getCreatureName() ? new EntityArsinoitherium(world) : (mobName == BygoneAgeMobsInformation.TITANISWALLERI.getCreatureName() ? new EntityTitanisWalleri(world) : (mobName == BygoneAgeMobsInformation.BASILOSAURUS.getCreatureName() ? new EntityBasilosaurus(world) : (mobName == BygoneAgeMobsInformation.MAMMOTH.getCreatureName() ? new EntityMammoth(world) : (mobName == BygoneAgeMobsInformation.DEINOTHERIUM.getCreatureName() ? new EntityDeinotherium(world) : new EntityLeptictidium(world))))))));
        String motherCode = this.slots[2].func_77978_p().func_74779_i("RNAHelix1");
        creature.createGeneticCode(motherCode.substring(0, 10) + this.slots[3].func_77978_p().func_74779_i("RNAHelix1").substring(10, 18), motherCode.substring(0, 10) + this.slots[4].func_77978_p().func_74779_i("RNAHelix1").substring(10, 18), motherCode.substring(0, 10) + this.slots[5].func_77978_p().func_74779_i("RNAHelix1").substring(10, 18), motherCode.substring(0, 10) + this.slots[6].func_77978_p().func_74779_i("RNAHelix1").substring(10, 18));
        creature.setGenetics(dna1, dna2, dna3, dna4 *= rand + dnaMother * (1.0f - rand));
        return creature;
    }

    private void selectValidPosition(Entity creature) {
        if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
            creature.func_70012_b((double)this.field_145851_c + 1.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
            creature.func_70012_b((double)this.field_145851_c - 1.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
            creature.func_70012_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
            creature.func_70012_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e - 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1)) {
            creature.func_70012_b((double)this.field_145851_c + 1.5, (double)this.field_145848_d, (double)this.field_145849_e + 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1)) {
            creature.func_70012_b((double)this.field_145851_c + 1.5, (double)this.field_145848_d, (double)this.field_145849_e - 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1)) {
            creature.func_70012_b((double)this.field_145851_c - 1.5, (double)this.field_145848_d, (double)this.field_145849_e + 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1)) {
            creature.func_70012_b((double)this.field_145851_c - 1.5, (double)this.field_145848_d, (double)this.field_145849_e - 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e)) {
            creature.func_70012_b((double)this.field_145851_c + 1.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e)) {
            creature.func_70012_b((double)this.field_145851_c - 1.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e + 1)) {
            creature.func_70012_b((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e - 1)) {
            creature.func_70012_b((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e - 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e + 1)) {
            creature.func_70012_b((double)this.field_145851_c + 1.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e - 1)) {
            creature.func_70012_b((double)this.field_145851_c + 1.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e - 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e + 1)) {
            creature.func_70012_b((double)this.field_145851_c - 1.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e - 1)) {
            creature.func_70012_b((double)this.field_145851_c - 1.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e - 1.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        } else {
            creature.func_70012_b((double)this.field_145851_c, (double)(this.field_145848_d + 2), (double)this.field_145849_e, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        }
    }

    private float mixDNAQualities(float DNA1, int priority1, float DNA2, int priority2, float DNA3, int priority3, float DNA4, int priority4, float DNA5, int priority5) {
        float maxPriority = priority1 + priority2 + priority3 + priority4 + priority5;
        return Float.valueOf(DNA1 * (float)priority1 / maxPriority + DNA2 * (float)priority2 / maxPriority + DNA3 * (float)priority3 / maxPriority + DNA4 * (float)priority4 / maxPriority + DNA5 * (float)priority5 / maxPriority).floatValue();
    }

    private boolean hasFourEmptyDNASlots() {
        return this.slots[2] == null || this.slots[3] == null || this.slots[4] == null || this.slots[5] == null || this.slots[6] == null;
    }

    private void recalculateGrowthRate(int id) {
        if (id >= 0) {
            short stages = BygoneAgeGeneticsInformation.values()[id].getNumberOfStages();
            short speed = BygoneAgeGeneticsInformation.values()[id].getHatchSpeed();
            Byte i = 0;
            while (i <= stages - 1) {
                if (i > 0) {
                    this.growthRateList.put((short)(i * speed / stages), i);
                } else {
                    this.growthRateList.put((short)2, (byte)0);
                }
                Byte by = i;
                Byte by2 = i = Byte.valueOf((byte)(i + 1));
            }
        }
    }

    private void resetBaseValues() {
        this.hatcheryTime = 0;
        this.hatcherySpeed = (short)100;
        this.creatureID = (byte)-1;
        this.growthRateList.clear();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean hasItems() {
        return this.slots[0] != null || this.slots[1] != null || this.slots[2] != null || this.slots[3] != null || this.slots[4] != null || this.slots[5] != null || this.slots[6] != null || this.slots[7] != null;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isHatching()) {
                if (this.canCansumeWaterBucket()) {
                    this.consumeWaterBucket();
                }
                if (this.canCansumeFood()) {
                    this.consumeFood();
                }
                if (this.getWaterStored() >= 3 && this.proximateValue > 0 && this.mineralValue > 0 && this.vitaminValue > 0 && this.lipidValue > 0 && this.canHatch()) {
                    this.hatcherySpeed = BygoneAgeGeneticsInformation.values()[this.creatureID].getHatchSpeed();
                    this.embryoStage = 0;
                    this.recalculateGrowthRate(this.creatureID);
                    this.hatcheryTime = 1;
                    this.creatureSize = 0.0f;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else {
                this.hatcheryTime = (short)(this.hatcheryTime + 1);
                if (this.growthRateList.containsKey(this.hatcheryTime)) {
                    this.setCreatureSize(this.hatcheryTime, this.hatcherySpeed);
                    this.setEmbryoStage(this.hatcheryTime);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else if (this.shouldUpdate) {
                    this.setCreatureSize(this.hatcheryTime, this.hatcherySpeed);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.shouldUpdate = false;
                }
                if (this.hatcheryTime >= this.hatcherySpeed) {
                    this.hatchCreature();
                    this.resetBaseValues();
                } else if (this.hasFourEmptyDNASlots()) {
                    this.resetBaseValues();
                }
            }
        }
    }

    public void cancelHatching(float progress) {
        this.setProximateValue((short)(this.getProximateValue() - (int)(progress * (float)BygoneAgeGeneticsInformation.values()[this.getEmbryoID()].getMinimumProximate())));
        this.setMineralValue((short)(this.getMineralValue() - (int)(progress * (float)BygoneAgeGeneticsInformation.values()[this.getEmbryoID()].getMinimumMinerals())));
        this.setVitaminValue((short)(this.getVitaminValue() - (int)(progress * (float)BygoneAgeGeneticsInformation.values()[this.getEmbryoID()].getMinimumvitamins())));
        this.setLipidValue((short)(this.getLipidValue() - (int)(progress * (float)BygoneAgeGeneticsInformation.values()[this.getEmbryoID()].getMinimumLipids())));
        if (progress >= 0.75f) {
            this.setWaterStored((byte)0);
        } else if (progress >= 0.5f) {
            this.setWaterStored((byte)1);
        } else {
            this.setWaterStored((byte)2);
        }
        this.hatcheryTime = 0;
        this.hatcherySpeed = (short)100;
        this.creatureID = (byte)-1;
        this.growthRateList.clear();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int stackSize) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= stackSize) {
                ItemStack splitedStack = this.slots[i];
                this.slots[i] = null;
                return splitedStack;
            }
            ItemStack splitedStack = this.slots[i].func_77979_a(stackSize);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return splitedStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Hatchery";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0 && !this.isHatching();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public int[] func_94128_d(int i) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("CreatureID", this.creatureID);
        nbt.func_74774_a("Water", this.waterStored);
        nbt.func_74777_a("Proximate", this.proximateValue);
        nbt.func_74777_a("Mineral", this.mineralValue);
        nbt.func_74777_a("Vitamin", this.vitaminValue);
        nbt.func_74777_a("Lipid", this.lipidValue);
        nbt.func_74777_a("HatcheryTime", this.hatcheryTime);
        nbt.func_74776_a("CreatureSize", this.creatureSize);
        nbt.func_74776_a("EmbryoStage", (float)this.embryoStage);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.shouldUpdate = true;
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte k = compound.func_74771_c("Slot");
            if (k < 0 || k >= this.slots.length) continue;
            this.slots[k] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.creatureID = nbt.func_74771_c("CreatureID");
        this.creatureSize = nbt.func_74765_d("CreatureSize");
        this.waterStored = nbt.func_74771_c("Water");
        this.hatcheryTime = nbt.func_74765_d("HatcheryTime");
        this.proximateValue = nbt.func_74765_d("Proximate");
        this.mineralValue = nbt.func_74765_d("Mineral");
        this.vitaminValue = nbt.func_74765_d("Vitamin");
        this.lipidValue = nbt.func_74765_d("Lipid");
        this.embryoStage = nbt.func_74771_c("EmbryoStage");
        if (this.creatureID >= 0) {
            this.hatcherySpeed = BygoneAgeGeneticsInformation.values()[this.creatureID].getHatchSpeed();
            this.recalculateGrowthRate(this.creatureID);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }
}

