/*
 * Decompiled with CFR 0.152.
 */
package com.RoiEXsMods.Half_Stick_Mod;

import com.RoiEXsMods.Half_Stick_Mod.Half_Stick_Mod_main;
import cpw.mods.fml.common.Loader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import net.minecraftforge.common.config.Property;

public class Version
implements Runnable {
    private static final String VERSION_FILE = "https://dl.dropboxusercontent.com/s/z0e7dlau8p8xh7q/VERSION.txt";
    public static EnumUpdateState currentVersion = EnumUpdateState.CURRENT;
    private static String recommendedVersion;
    private static Version instance;
    private static boolean sentIMCOutdatedMessage;

    @Override
    public void run() {
        currentVersion = null;
        Half_Stick_Mod_main.logger.info("Beginning version check");
        try {
            for (int count = 0; count < 3 && (currentVersion == null || currentVersion == EnumUpdateState.CONNECTION_ERROR); ++count) {
                Version.versionCheck();
                if (currentVersion != EnumUpdateState.CONNECTION_ERROR) continue;
                Half_Stick_Mod_main.logger.info("Version check attempt " + count + " failed, trying again in 10 seconds");
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (currentVersion == EnumUpdateState.CONNECTION_ERROR) {
            Half_Stick_Mod_main.logger.info("Version check failed");
        }
    }

    public static String getVersion() {
        return "5.0";
    }

    public static boolean isOutdated() {
        return currentVersion == EnumUpdateState.OUTDATED;
    }

    public static boolean needsUpdateNoticeAndMarkAsSeen() {
        if (!Version.isOutdated() || sentIMCOutdatedMessage) {
            return false;
        }
        Property property = Half_Stick_Mod_main.mainConfiguration.get("vars", "version.seen", "5.0");
        property.comment = "indicates the last version the user has been informed about and will suppress further notices on it.";
        String seenVersion = property.getString();
        if (recommendedVersion == null || recommendedVersion.equals(seenVersion)) {
            return false;
        }
        property.set(recommendedVersion);
        Half_Stick_Mod_main.mainConfiguration.save();
        return true;
    }

    public static String getRecommendedVersion() {
        return recommendedVersion;
    }

    public static void versionCheck() {
        try {
            String line;
            if ("0.0".equals("5.0")) {
                return;
            }
            String location = VERSION_FILE;
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                if (conn != null) {
                    ((HttpURLConnection)conn).disconnect();
                }
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            if (conn == null) {
                throw new NullPointerException();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String mcVersion = Loader.instance().getMinecraftModContainer().getVersion();
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(":");
                if (!mcVersion.matches(tokens[0]) || !"Half_Stick_Mod".matches(tokens[1])) continue;
                recommendedVersion = tokens[2];
                if (!"5.0".matches(tokens[2])) continue;
                Half_Stick_Mod_main.logger.trace("Using the latest version [" + Version.getVersion() + "] for Minecraft " + mcVersion);
                currentVersion = EnumUpdateState.CURRENT;
                return;
            }
            Half_Stick_Mod_main.logger.warn("Using outdated version [5.0] for Minecraft " + mcVersion + ". Consider updating to " + recommendedVersion + ".");
            currentVersion = EnumUpdateState.OUTDATED;
            Half_Stick_Mod_main.hasUpdated = false;
            ((HttpURLConnection)conn).disconnect();
            reader.close();
        }
        catch (Exception e) {
            Half_Stick_Mod_main.logger.warn("Unable to read from remote version authority.");
            Half_Stick_Mod_main.logger.warn(e.toString());
            currentVersion = EnumUpdateState.CONNECTION_ERROR;
        }
    }

    public static void check() {
        new Thread(instance).start();
    }

    static {
        instance = new Version();
        sentIMCOutdatedMessage = false;
    }

    public static enum EnumUpdateState {
        CURRENT,
        OUTDATED,
        CONNECTION_ERROR;

    }
}

