/*
 * Decompiled with CFR 0.152.
 */
package assets.pchan3.steamship;

import assets.pchan3.ItemAnchor;
import assets.pchan3.PChan3Mods;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemCoal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityAirship
extends Entity
implements IInventory {
    private ItemStack[] cargoItems;
    private int airshipPosRotationIncrements;
    private double airShipX;
    private double airShipY;
    private double airShipZ;
    private double airshipYaw;
    private double airshipPitch;
    public boolean isGoingUp;
    public boolean isGoingDown;
    public boolean isFiring;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    public boolean isAnchor;
    public Entity thrower;
    private NBTTagCompound leash;

    public EntityAirship(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 1.7f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.cargoItems = new ItemStack[this.func_70302_i_()];
    }

    public EntityAirship(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    public boolean func_70097_a(DamageSource source, float i) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(2);
            this.setDamageTaken(this.getDamageTaken() + i * 10.0f);
            this.func_70018_K();
            if (source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.setDamageTaken(200.0f);
            }
            if (this.getDamageTaken() > 100.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_145778_a(PChan3Mods.airShip, 1, 0.0f);
                this.func_70106_y();
            }
            return true;
        }
        if (this.field_70170_p.field_72995_K && this.field_70128_L) {
            PChan3Mods.proxy.displayShipExplodeFX(source, this);
        }
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return !this.isAnchor;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            if (stack.field_77994_a <= j) {
                this.func_70299_a(i, null);
                this.func_70296_d();
            } else {
                stack = stack.func_77979_a(j);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                    this.func_70296_d();
                }
            }
        }
        return stack;
    }

    public void fireArrow(EntityPlayer entityplayer) {
        boolean shipHasArrows;
        boolean playerHasArrows = entityplayer.field_71071_by.func_146028_b(Items.field_151032_g) && PChan3Mods.usePlayerArrow;
        boolean bl = shipHasArrows = this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() == Items.field_151032_g;
        if ((playerHasArrows || shipHasArrows || entityplayer.field_71075_bZ.field_75098_d) && this.getFireCountDown() == 0) {
            Vec3 vec = entityplayer.func_70040_Z();
            double d8 = 4.0;
            double d1 = this.field_70165_t + vec.field_72450_a * d8;
            double d2 = this.field_70163_u + (double)(this.field_70131_O / 4.0f);
            double d3 = this.field_70161_v + vec.field_72449_c * d8;
            EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)entityplayer, 1.0f);
            this.field_70170_p.func_72956_a((Entity)entityplayer, "random.bow", 1.0f, 1.0f / (new Random().nextFloat() * 0.4f + 0.8f));
            arrow.func_70012_b(d1, d2, d3, 2.6f, 6.0f);
            arrow.func_70239_b(1.0);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)arrow);
                this.setFireCountDown(20);
            }
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                if (shipHasArrows) {
                    if (--this.cargoItems[1].field_77994_a <= 0) {
                        this.func_70299_a(1, null);
                    }
                } else if (playerHasArrows) {
                    entityplayer.field_71071_by.func_146026_a(Items.field_151032_g);
                }
            }
        }
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return par1Entity.field_70121_D;
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public int getFireCountDown() {
        return this.field_70180_af.func_75679_c(31);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    public int getFuelScaled(int i) {
        return this.getFuelTime() * i / 600;
    }

    public int getFuelTime() {
        return this.field_70180_af.func_75679_c(30);
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return "Airship";
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - (double)0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public int func_70302_i_() {
        return 14;
    }

    public ItemStack func_70301_a(int i) {
        return this.cargoItems[i];
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != entityplayer) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack != null) {
                if (itemstack.func_77973_b() instanceof ItemCoal) {
                    if (--itemstack.field_77994_a == 0) {
                        entityplayer.func_71028_bD();
                    }
                    if (this.getFuelTime() == 0) {
                        this.setFuelTime(1600);
                    } else if (this.func_70301_a(0) == null) {
                        this.func_70299_a(0, new ItemStack(itemstack.func_77973_b()));
                    } else if (this.func_70301_a(0).func_77973_b() == Items.field_151044_h) {
                        ++this.cargoItems[0].field_77994_a;
                        this.func_70296_d();
                    }
                    return false;
                }
                if (itemstack.func_77973_b() instanceof ItemAnchor) {
                    if (!this.isAnchor) {
                        this.setAnchor((Entity)entityplayer);
                        if (!entityplayer.field_71075_bZ.field_75098_d && --itemstack.field_77994_a == 0) {
                            entityplayer.func_71028_bD();
                        }
                    }
                    return true;
                }
            } else if (this.isAnchor && this.thrower.func_145782_y() == entityplayer.func_145782_y()) {
                this.unsetAnchor(!entityplayer.field_71075_bZ.field_75098_d);
            }
            entityplayer.func_70078_a((Entity)this);
            return true;
        }
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i > 2 || itemstack.func_77973_b() instanceof ItemCoal && i == 0 || itemstack.func_77973_b() == Items.field_151032_g && i == 1;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return !this.field_70128_L && entityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_70296_d() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getFuelTime() > 0) {
            this.setFuelTime(this.getFuelTime() - 1);
        }
        if (this.getFireCountDown() > 0) {
            this.setFireCountDown(this.getFireCountDown() - 1);
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (this.getFuelTime() == 0 && this.field_70153_n != null) {
            if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() == Items.field_151044_h) {
                this.setFuelTime(1600);
                if (--this.cargoItems[0].field_77994_a <= 0) {
                    this.func_70299_a(0, null);
                }
            } else if (PChan3Mods.usePlayerCoal && ((EntityPlayer)this.field_70153_n).field_71071_by.func_146026_a(Items.field_151044_h)) {
                this.setFuelTime(1600);
            }
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int i = 5;
        double d3 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            if (this.airshipPosRotationIncrements > 0) {
                double d1 = this.field_70165_t + (this.airShipX - this.field_70165_t) / (double)this.airshipPosRotationIncrements;
                double d5 = this.field_70163_u + (this.airShipY - this.field_70163_u) / (double)this.airshipPosRotationIncrements;
                double d9 = this.field_70161_v + (this.airShipZ - this.field_70161_v) / (double)this.airshipPosRotationIncrements;
                double d12 = MathHelper.func_76138_g((double)(this.airshipYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d12 / (double)this.airshipPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.airshipPitch - (double)this.field_70125_A) / (double)this.airshipPosRotationIncrements);
                --this.airshipPosRotationIncrements;
                this.func_70107_b(d1, d5, d9);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double d1 = this.field_70165_t + this.field_70159_w;
                double d6 = this.field_70163_u + this.field_70181_x;
                double d10 = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(d1, d6, d10);
                if (this.getFuelTime() == 0) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                } else if (PChan3Mods.SHOW_BOILER) {
                    PChan3Mods.proxy.displaySmoke(this);
                }
                if (d3 > 0.15) {
                    PChan3Mods.proxy.displaySplashEffect(this, d3);
                }
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
        } else {
            double d19;
            double d7;
            double d11;
            double d5;
            double d4;
            if (!this.isAnchor && this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                d4 = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
                d5 = ((EntityLivingBase)this.field_70153_n).field_70702_br;
                double d0 = -Math.sin(this.field_70153_n.field_70177_z * (float)Math.PI / 180.0f);
                d11 = Math.cos(this.field_70153_n.field_70177_z * (float)Math.PI / 180.0f);
                this.field_70159_w += (d5 * d11 + d0 * d4) * PChan3Mods.airSpeed;
                this.field_70179_y += (d4 * d11 - d0 * d5) * PChan3Mods.airSpeed;
            }
            if ((d4 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.35) {
                d5 = 0.35 / d4;
                this.field_70159_w *= d5;
                this.field_70179_y *= d5;
            }
            if (this.isGoingUp && !this.isAnchor) {
                this.field_70181_x += PChan3Mods.airUpSpeed;
            } else if (this.isGoingDown) {
                for (int j = 0; j < i; ++j) {
                    double d41 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(j - 2) / (double)i - 0.125;
                    double d8 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(j - 4) / (double)i - 0.125;
                    AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.field_70121_D.field_72340_a, (double)d41, (double)this.field_70121_D.field_72339_c, (double)this.field_70121_D.field_72336_d, (double)d8, (double)this.field_70121_D.field_72334_f);
                    if (!this.field_70170_p.func_72830_b(axisalignedbb, Material.field_151586_h)) {
                        this.field_70181_x -= PChan3Mods.airDownSpeed;
                        continue;
                    }
                    this.field_70163_u += 5.0;
                    this.field_70181_x = 0.0;
                }
            }
            if (this.getFuelTime() == 0 && !this.field_70122_E) {
                this.field_70181_x -= 0.006666666666666667;
            }
            if (this.field_70159_w < -(d7 = 1.0)) {
                this.field_70159_w = -d7;
            }
            if (this.field_70159_w > d7) {
                this.field_70159_w = d7;
            }
            if (this.field_70179_y < -d7) {
                this.field_70179_y = -d7;
            }
            if (this.field_70179_y > d7) {
                this.field_70179_y = d7;
            }
            if (this.getFuelTime() == 0 || this.isAnchor) {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            }
            d11 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (!this.field_70123_F || !(d11 > 0.15)) {
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70125_A = 0.0f;
            double d14 = this.field_70177_z;
            double d16 = this.field_70169_q - this.field_70165_t;
            double d17 = this.field_70166_s - this.field_70161_v;
            if (d16 * d16 + d17 * d17 > 0.001) {
                d14 = (float)(Math.atan2(d17, d16) * 180.0 / Math.PI);
            }
            if ((d19 = MathHelper.func_76138_g((double)(d14 - (double)this.field_70177_z))) > 20.0) {
                d19 = 20.0;
            }
            if (d19 < -20.0) {
                d19 = -20.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + d19);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
                if (list != null && list.size() > 0) {
                    for (int j1 = 0; j1 < list.size(); ++j1) {
                        Entity entity = (Entity)list.get(j1);
                        if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityAirship)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                }
            }
            if (this.isFiring && this.getFireCountDown() == 0) {
                this.fireArrow((EntityPlayer)this.field_70153_n);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updateAnchor();
        }
    }

    public void func_70295_k_() {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public void setAnchor(Entity par1Entity) {
        this.isAnchor = true;
        this.thrower = par1Entity;
    }

    public void setDamageTaken(float par1) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(par1));
    }

    public void func_70106_y() {
        for (int var1 = 0; var1 < this.func_70302_i_(); ++var1) {
            ItemStack var2 = this.func_70301_a(var1);
            if (var2 == null) continue;
            float var3 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
            float var4 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
            float var5 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
            while (var2.field_77994_a > 0) {
                int var6 = this.field_70146_Z.nextInt(21) + 10;
                if (var6 > var2.field_77994_a) {
                    var6 = var2.field_77994_a;
                }
                var2.field_77994_a -= var6;
                EntityItem var7 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)var3, this.field_70163_u + (double)var4, this.field_70161_v + (double)var5, new ItemStack(var2.func_77973_b(), var6, var2.func_77960_j()));
                if (var2.func_77942_o()) {
                    var7.func_92059_d().func_77982_d((NBTTagCompound)var2.func_77978_p().func_74737_b());
                }
                float var8 = 0.05f;
                var7.field_70159_w = (float)this.field_70146_Z.nextGaussian() * var8;
                var7.field_70181_x = (float)this.field_70146_Z.nextGaussian() * var8 + 0.2f;
                var7.field_70179_y = (float)this.field_70146_Z.nextGaussian() * var8;
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_72838_d((Entity)var7);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            PChan3Mods.proxy.displayExplodeFX(this);
        }
        super.func_70106_y();
    }

    public void setFireCountDown(int par1) {
        this.field_70180_af.func_75692_b(31, (Object)par1);
    }

    public void setForwardDirection(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)par1);
    }

    public void setFuelTime(int par1) {
        this.field_70180_af.func_75692_b(30, (Object)par1);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.cargoItems[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float f, float f1, int i) {
        this.airshipPosRotationIncrements = i + 5;
        this.airShipX = x;
        this.airShipY = y;
        this.airShipZ = z;
        this.airshipYaw = f;
        this.airshipPitch = f1;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void setTimeSinceHit(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)par1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.velocityX = this.field_70159_w = par1;
        this.velocityY = this.field_70181_x = par3;
        this.velocityZ = this.field_70179_y = par5;
    }

    public void unsetAnchor(boolean forceDrop) {
        if (this.isAnchor) {
            this.isAnchor = false;
            this.thrower = null;
            if (!this.field_70170_p.field_72995_K && forceDrop) {
                this.func_145779_a(PChan3Mods.anchor, 1);
            }
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double d0 = Math.cos((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
            double d1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
            this.field_70153_n.func_70107_b(this.field_70165_t + d0, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + d1);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(30, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(31, (Object)new Integer(0));
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        NBTTagList itemTags = (NBTTagList)par1NBTTagCompound.func_74781_a("Items");
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        for (int id = 0; id < itemTags.func_74745_c(); ++id) {
            NBTTagCompound var4 = itemTags.func_150305_b(id);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.cargoItems.length) continue;
            this.cargoItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.isAnchor = par1NBTTagCompound.func_74767_n("Leashed");
        if (this.isAnchor && par1NBTTagCompound.func_74764_b("Leash")) {
            this.leash = par1NBTTagCompound.func_74775_l("Leash");
        }
    }

    protected void updateAnchor() {
        if (this.leash != null) {
            this.recreateAnchor();
        }
        if (this.isAnchor && (this.thrower == null || this.thrower.field_70128_L)) {
            this.unsetAnchor(true);
        }
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        NBTTagList tags = new NBTTagList();
        for (int id = 0; id < this.cargoItems.length; ++id) {
            if (this.cargoItems[id] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)id);
            this.cargoItems[id].func_77955_b(var4);
            tags.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)tags);
        par1NBTTagCompound.func_74757_a("Leashed", this.isAnchor);
        if (this.thrower != null) {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.thrower instanceof EntityLivingBase) {
                tag.func_74772_a("UUIDMost", this.thrower.func_110124_au().getMostSignificantBits());
                tag.func_74772_a("UUIDLeast", this.thrower.func_110124_au().getLeastSignificantBits());
            }
            par1NBTTagCompound.func_74782_a("Leash", (NBTBase)tag);
        }
    }

    private void recreateAnchor() {
        if (this.isAnchor && this.leash != null) {
            if (this.leash.func_74764_b("UUIDMost") && this.leash.func_74764_b("UUIDLeast")) {
                UUID uuid = new UUID(this.leash.func_74763_f("UUIDMost"), this.leash.func_74763_f("UUIDLeast"));
                List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
                for (EntityLivingBase entitylivingbase : list) {
                    if (!entitylivingbase.func_110124_au().equals(uuid)) continue;
                    this.thrower = entitylivingbase;
                    break;
                }
            } else {
                this.unsetAnchor(true);
            }
        }
        this.leash = null;
    }
}

