/*
 * Decompiled with CFR 0.152.
 */
package com.wondertrademod.wondertrade;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.database.EvolutionInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.wondertrademod.wondertrade.Utilities;
import com.wondertrademod.wondertrade.WonderTrades;
import com.wondertrademod.wondertrade.config.WonderTradeConfig;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class TickHandler {
    public static String strColorRed = EnumChatFormatting.RED + "";
    public static String strColorGreen = EnumChatFormatting.GREEN + "";
    public static String strColorYellow = EnumChatFormatting.YELLOW + "";
    public static String strColorBlue = EnumChatFormatting.AQUA + "";
    public static String strColorWhite = EnumChatFormatting.WHITE + "";
    public static ArrayList<EntityPixelmon> pokemonPool = new ArrayList();
    public static Integer intPoolSize = 100;
    public static Integer TICKSPERSECOND = 40;
    public static Integer intAnnouncementInterval = 21600;
    public static long lngTickCount = 0L;
    public static boolean isInitialized = false;
    public static int intSecondsSinceLastAnnouncement = 0;
    public static ArrayList<String> legendaries = new ArrayList<String>(Arrays.asList("articuno", "zapdos", "moltres", "mewtwo", "mew", "entei", "raikou", "suicune", "ho-oh", "lugia", "celebi", "regirock", "regice", "registeel", "latios", "latias", "groudon", "kyogre", "rayquaza", "jirachi", "deoxys", "uxie", "azelf", "mesprit", "dialga", "palkia", "giratina", "cresselia", "darkrai", "manaphy", "phione", "heatran", "regigigas", "shaymin", "arceus", "victini", "cobalion", "terrakion", "virizion", "keldeo", "thundurus", "tornadus", "landorus", "zekrom", "reshiram", "kyurem", "genesect", "meloetta", "xerneas", "yveltal", "zygarde"));

    public static void initializePool() {
        WonderTrades.world = MinecraftServer.func_71276_C().func_71218_a(0);
        intAnnouncementInterval = WonderTradeConfig.intAnnouncementFrequency <= 0 ? Integer.valueOf(7200) : (WonderTradeConfig.intAnnouncementFrequency > 60 ? Integer.valueOf(7200) : Integer.valueOf(120 * WonderTradeConfig.intAnnouncementFrequency));
        intPoolSize = WonderTradeConfig.intPoolSize <= 0 ? Integer.valueOf(100) : WonderTradeConfig.intPoolSize;
        if (WonderTradeConfig.intTimeLimitMinutes < 0) {
            WonderTradeConfig.intTimeLimitMinutes = 60;
        }
        pokemonPool = TickHandler.generateRandomPool(intPoolSize);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!isInitialized) {
            TickHandler.initializePool();
            isInitialized = true;
        } else if (++lngTickCount % (long)TICKSPERSECOND.intValue() == 0L) {
            ++intSecondsSinceLastAnnouncement;
            if (intAnnouncementInterval != 0) {
                if (intSecondsSinceLastAnnouncement > intAnnouncementInterval) {
                    TickHandler.doPoolAnnouncement(true);
                }
            } else if (intSecondsSinceLastAnnouncement > 7200) {
                TickHandler.doPoolAnnouncement(true);
            }
        }
    }

    public static void checkPoolSize() {
        block3: {
            block2: {
                if (pokemonPool.size() >= intPoolSize) break block2;
                ArrayList<EntityPixelmon> supplimentPool = TickHandler.generateRandomPool(intPoolSize - pokemonPool.size());
                for (EntityPixelmon p : supplimentPool) {
                    pokemonPool.add(p);
                }
                break block3;
            }
            if (pokemonPool.size() <= intPoolSize) break block3;
            for (int i = 0; i < pokemonPool.size() - intPoolSize; ++i) {
                pokemonPool.remove(0);
            }
        }
    }

    public static void doPoolAnnouncement(boolean boolDoPlug) {
        String strAnnouncement = "";
        Integer intCountPool = 0;
        Integer intCountLegendaries = 0;
        Integer intCountShinies = 0;
        intSecondsSinceLastAnnouncement = 0;
        TickHandler.checkPoolSize();
        String name = "";
        boolean isShiny = false;
        for (EntityPixelmon p : pokemonPool) {
            Integer n = intCountPool;
            Integer n2 = intCountPool = Integer.valueOf(intCountPool + 1);
            try {
                if (legendaries.contains(p.getName().toLowerCase())) {
                    n = intCountLegendaries;
                    n2 = intCountLegendaries = Integer.valueOf(intCountLegendaries + 1);
                }
                if (!p.getIsShiny()) continue;
                n = intCountShinies;
                n2 = intCountShinies = Integer.valueOf(intCountShinies + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Utilities.sendServerwideMessage(strColorWhite + "This server is running " + strColorGreen + "WonderTrade " + strColorWhite + "by" + strColorGreen + " GhostWolf!" + strColorWhite + " For a tutorial see: " + strColorBlue + WonderTradeConfig.strTutorialURL);
        Utilities.sendServerwideMessage(strColorWhite + "Current " + strColorGreen + "WonderTrade " + strColorWhite + "Pool contains: " + strColorGreen + intCountPool + strColorWhite + " Pixelmon");
        String strPlural = "";
        if (intCountLegendaries > 0) {
            strPlural = intCountLegendaries == 1 ? "is a LEGENDARY!" : "are LEGENDARIES!";
            Utilities.sendServerwideMessage(strColorRed + intCountLegendaries + " of those " + strPlural);
        }
        if (!WonderTradeConfig.boolInvertShinyAnnouncement) {
            if (intCountShinies > 0) {
                strPlural = intCountShinies == 1 ? "is a SHINY!" : "are SHINY!";
                Utilities.sendServerwideMessage(strColorYellow + intCountShinies + " of those " + strPlural);
            }
        } else {
            int intCountNonShiny = intCountPool - intCountShinies;
            if (intCountNonShiny > 0) {
                strPlural = intCountShinies == 1 ? "is a non-SHINY!" : "are non-SHINY!";
                Utilities.sendServerwideMessage(strColorYellow + intCountNonShiny + " of those " + strPlural);
            }
        }
        Utilities.sendServerwideMessage(strColorGreen + "Try it out yourself with " + strColorWhite + "/wondertrade");
    }

    public static ArrayList<EntityPixelmon> generateRandomPool(Integer intSize) {
        ArrayList<EntityPixelmon> pool = new ArrayList<EntityPixelmon>();
        for (int i = 0; i < intSize; ++i) {
            EntityPixelmon p = TickHandler.getRandomEntityPixelmon();
            if (p == null) continue;
            pool.add(p);
        }
        return pool;
    }

    public static EntityPixelmon getRandomEntityPixelmon() {
        try {
            EntityPixelmon pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName((String)Utilities.getRandomPokemonName(), (World)WonderTrades.world);
            if (legendaries.contains(pokemon.getName().toLowerCase())) {
                if (WonderTradeConfig.intLegendaryRate == 0) {
                    pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName((String)"Rattata", (World)WonderTrades.world);
                } else if (WonderTradeConfig.intLegendaryRate > 0 && new Random().nextInt(WonderTradeConfig.intLegendaryRate) > 1) {
                    pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName((String)"Rattata", (World)WonderTrades.world);
                }
            }
            int intMinLevel = 2;
            int intMaxLevel = 99;
            intMinLevel = WonderTradeConfig.intMinLevel <= 0 ? 2 : (WonderTradeConfig.intMaxLevel > 98 ? 98 : WonderTradeConfig.intMinLevel);
            intMaxLevel = WonderTradeConfig.intMaxLevel <= 0 ? 40 : (WonderTradeConfig.intMaxLevel > 99 ? 99 : WonderTradeConfig.intMaxLevel);
            try {
                pokemon.getLvl().setLevel(RandomHelper.getRandomNumberBetween((int)intMinLevel, (int)intMaxLevel));
            }
            catch (Exception e) {
                pokemon.getLvl().setLevel(10);
            }
            if (WonderTradeConfig.intShinyRate == -1) {
                if (new Random().nextInt(8192) <= 1) {
                    pokemon.setIsShiny(true);
                }
            } else if (WonderTradeConfig.intShinyRate > 0) {
                if (new Random().nextInt(WonderTradeConfig.intShinyRate) <= 1) {
                    pokemon.setIsShiny(true);
                }
            } else if (WonderTradeConfig.intShinyRate == 0) {
                pokemon.setIsShiny(false);
            }
            if (WonderTradeConfig.boolInvertShinyAnnouncement) {
                if (pokemon.getIsShiny()) {
                    pokemon.setIsShiny(false);
                } else {
                    pokemon.setIsShiny(true);
                }
            }
            return pokemon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EntityPixelmon exchangePokemon(String username, EntityPixelmon entityPixelmonFromPlayer) {
        int rand = MinecraftServer.func_71276_C().func_71218_a((int)0).field_73012_v.nextInt(pokemonPool.size());
        EntityPixelmon entityPixelmonFromPool = pokemonPool.get(rand);
        pokemonPool.remove(rand);
        pokemonPool.add(entityPixelmonFromPlayer);
        TickHandler.checkAddAnnouncement(username, entityPixelmonFromPlayer);
        TickHandler.checkRecieveAnnouncement(username, entityPixelmonFromPool);
        return entityPixelmonFromPool;
    }

    public static void addPokemon(EntityPlayerMP player, EntityPixelmon entityPixelmonFromPlayer) {
        pokemonPool.add(entityPixelmonFromPlayer);
        TickHandler.checkAddAnnouncement(player.getDisplayName(), entityPixelmonFromPlayer);
    }

    public static void addPokemon(ICommandSender par1ICommandSender, EntityPixelmon entityPixelmonFromPlayer) {
        pokemonPool.add(entityPixelmonFromPlayer);
        TickHandler.checkAddAnnouncement(par1ICommandSender.func_70005_c_(), entityPixelmonFromPlayer);
    }

    public static void checkAddAnnouncement(String username, EntityPixelmon entityPixelmonFromPlayer) {
        String name = "";
        boolean isShiny = false;
        try {
            if (legendaries.contains(entityPixelmonFromPlayer.getName().toLowerCase())) {
                Utilities.sendServerwideMessage(strColorBlue + username + strColorRed + " has added a LEGENDARY to the WonderTrade Pool!!!");
                Utilities.sendServerwideMessage(strColorGreen + "Try your luck at getting it with " + strColorWhite + "/wondertrade");
            }
            if (!WonderTradeConfig.boolInvertShinyAnnouncement) {
                if (entityPixelmonFromPlayer.getIsShiny()) {
                    Utilities.sendServerwideMessage(strColorBlue + username + strColorYellow + " has added a SHINY to the WonderTrade Pool!!!");
                    Utilities.sendServerwideMessage(strColorGreen + "Try your luck at getting it with " + strColorWhite + "/wondertrade");
                }
            } else if (!entityPixelmonFromPlayer.getIsShiny()) {
                Utilities.sendServerwideMessage(strColorBlue + username + strColorYellow + " has added a NON-SHINY to the WonderTrade Pool!!!");
                Utilities.sendServerwideMessage(strColorGreen + "Try your luck at getting it with " + strColorWhite + "/wondertrade");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkRecieveAnnouncement(String username, EntityPixelmon entityPixelmonToPlayer) {
        try {
            if (legendaries.contains(entityPixelmonToPlayer.getName().toLowerCase())) {
                Utilities.sendServerwideMessage(strColorBlue + username + strColorRed + " has recieved a LEGENDARY from WonderTrade!!!");
                Utilities.sendServerwideMessage(strColorGreen + "Try your luck with " + strColorWhite + "/wondertrade");
            }
            if (!WonderTradeConfig.boolInvertShinyAnnouncement) {
                if (entityPixelmonToPlayer.getIsShiny()) {
                    Utilities.sendServerwideMessage(strColorBlue + username + strColorYellow + " has recieved a SHINY from WonderTrade!!!");
                    Utilities.sendServerwideMessage(strColorGreen + "Try your luck with " + strColorWhite + "/wondertrade");
                }
            } else if (!entityPixelmonToPlayer.getIsShiny()) {
                Utilities.sendServerwideMessage(strColorBlue + username + strColorYellow + " has recieved a NON-SHINY from WonderTrade!!!");
                Utilities.sendServerwideMessage(strColorGreen + "Try your luck with " + strColorWhite + "/wondertrade");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkEvolution(NBTTagCompound pokemon2, PlayerStorage storage1, World worldObj, EntityPixelmon pokemon) {
        int ID = pokemon.baseStats.id;
        ArrayList evolve1 = DatabaseStats.getEvolveList((int)ID);
        for (EvolutionInfo e : evolve1) {
            EntityPixelmon pixelmon;
            if (e.mode != EvolutionInfo.InfoMode.trade) continue;
            if (EnumPokemon.hasPokemon((String)e.extraParam)) {
                storage1.sendOut(PixelmonMethods.getID((NBTTagCompound)pokemon2), worldObj);
                pixelmon = storage1.sendOut(PixelmonMethods.getID((NBTTagCompound)pokemon2), worldObj);
                pixelmon.evolve(e.extraParam);
                storage1.retrieve(pixelmon);
                continue;
            }
            if (!EnumPokemon.hasPokemon((String)e.extraParam2)) continue;
            storage1.sendOut(PixelmonMethods.getID((NBTTagCompound)pokemon2), worldObj);
            pixelmon = storage1.sendOut(PixelmonMethods.getID((NBTTagCompound)pokemon2), worldObj);
            pixelmon.evolve(e.extraParam2);
            storage1.retrieve(pixelmon);
        }
    }
}

