/*
 * Decompiled with CFR 0.152.
 */
package com.wondertrademod.wondertrade;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.wondertrademod.wondertrade.config.WonderTradeConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class Utilities {
    public static String strColorRed = EnumChatFormatting.RED + "";
    public static String strColorGreen = EnumChatFormatting.GREEN + "";
    public static String strColorYellow = EnumChatFormatting.YELLOW + "";
    public static String strColorBlue = EnumChatFormatting.AQUA + "";
    public static String strColorWhite = EnumChatFormatting.WHITE + "";

    public static void sendServerwideMessage(String message) {
        ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation(message, new Object[0]);
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)chatcomponenttranslation);
    }

    public static void sendMessageToPlayer(EntityPlayerMP player, String message) {
        ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation(message, new Object[0]);
        player.func_145747_a((IChatComponent)chatcomponenttranslation);
    }

    public static void sendMessageToCommandSender(ICommandSender par1ICommandSender, String message) {
        try {
            EntityPlayerMP player = CommandBase.func_82359_c((ICommandSender)par1ICommandSender, (String)par1ICommandSender.func_70005_c_());
            Utilities.sendMessageToPlayer(player, message);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public static String getRandomPokemonName() {
        return EnumPokemon.getFromOrdinal((int)new Random().nextInt((int)EnumPokemon.values().length)).name;
    }

    private static String getTimeFile() {
        return Pixelmon.modDirectory + "/wondertrade/times/";
    }

    public static long cooldownRemaining(String username) {
        File saveDirPath = new File(Utilities.getTimeFile());
        String strTimeLine = "";
        if (!saveDirPath.exists()) {
            saveDirPath.mkdirs();
        }
        try {
            saveDirPath = new File(Utilities.getTimeFile() + username + ".txt");
            if (!saveDirPath.exists()) {
                return 0L;
            }
            BufferedReader br = new BufferedReader(new FileReader(saveDirPath));
            String line = br.readLine();
            while (line != null) {
                strTimeLine = line;
                line = br.readLine();
            }
            br.close();
            long intSecondsElapsed = Utilities.getSecondsElapsed(strTimeLine);
            if (intSecondsElapsed >= (long)(WonderTradeConfig.intTimeLimitMinutes * 60)) {
                return 0L;
            }
            return (long)WonderTradeConfig.intTimeLimitMinutes.intValue() - intSecondsElapsed / 60L;
        }
        catch (Exception e) {
            System.out.println("[Error] Error reading wondertrade time file for " + username);
            e.printStackTrace();
            return WonderTradeConfig.intTimeLimitMinutes.intValue();
        }
    }

    public static long getSecondsElapsed(String strTimeLine) {
        Date date = new Date();
        String strCurrentTime = "" + date.getTime();
        long intTimeLine = Long.parseLong(strTimeLine);
        long intCurrentTime = Long.parseLong(strCurrentTime);
        long intDifference = intCurrentTime - intTimeLine;
        long intSecondsElapsed = Integer.valueOf(Math.round(intDifference / 1000L)).intValue();
        return intSecondsElapsed;
    }

    public static void saveTime(String username) {
        File saveDirPath = new File(Utilities.getTimeFile());
        Date date = new Date();
        if (!saveDirPath.exists()) {
            saveDirPath.mkdirs();
        }
        try {
            saveDirPath = new File(Utilities.getTimeFile() + username + ".txt");
            FileWriter fw = new FileWriter(saveDirPath.getAbsoluteFile(), false);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(date.getTime() + "\n");
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("[Error] Error saving charges file for " + username);
            ioe.printStackTrace();
        }
    }

    private static String getLogFile() {
        return Pixelmon.modDirectory + "/wondertrade/";
    }

    public static void writeToLog(String username, String strToLog) {
        File saveDirPath = new File(Utilities.getLogFile());
        Date date = new Date();
        if (!saveDirPath.exists()) {
            saveDirPath.mkdirs();
        }
        try {
            saveDirPath = new File(Utilities.getLogFile() + "WonderTrade.log");
            FileWriter fw = new FileWriter(saveDirPath.getAbsoluteFile(), true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.append(new Timestamp(date.getTime()) + " " + strToLog + "\n");
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("[Error] Error saving log file for " + username);
            ioe.printStackTrace();
        }
    }
}

